package com.netease.nimlib.sdk.mixpush;

import android.content.Intent;

import com.netease.nimlib.apt.annotation.NIMService;
import com.netease.nimlib.sdk.InvocationFuture;
import com.netease.nimlib.sdk.settings.model.NoDisturbConfig;

/**
 * 第三方推送服务
 * 目前接入的第三方推送有：小米、华为、魅族、fcm。
 */
@NIMService("第三方推送服务")
public interface MixPushService {

    /**
     * 开启/关闭第三方推送服务
     *
     * @param enable true 开启，SDK 需要与云信服务器做确认；false 关闭，SDK 也需要通知云信服务器。
     * @return InvocationFuture 可以设置回调函数。只有与服务器交互完成后才算成功，如果出错，会有具体的错误代码。
     */
    public InvocationFuture<Void> enable(boolean enable);

    /**
     * 是否开启了第三方推送服务
     *
     * @return 默认开启
     */
    boolean isEnable();

    /**
     * 设置推送免打扰时间，时间参数为北京时间的24小时计数 HH:mm，该时间段将不再向用户推送消息
     * SDK 3.2.0 版本以前的用户，为了将用户设置的免打扰配置与push免打扰同步，应该在监听到登陆同步完成后，
     * 调用 setPushNoDisturbConfig 方法。如果开发者不使用新版第三方推送功能，只要不调用该方法，则旧的功能不受影响。
     * 此外，在免打扰设置界面也应该做到同时设置push免打扰
     *
     * @param isOpen    是否开启
     * @param startTime 开始时间 格式 HH:mm
     * @param stopTime  结束时间 格式 HH:mm
     * @return InvocationFuture 可以设置回调函数。成功会返回成功信息，错误会返回相应的错误码。
     */
    InvocationFuture<Void> setPushNoDisturbConfig(boolean isOpen, String startTime, String stopTime);

    /**
     * 设置推送是否不展示详情
     *
     * @param showNoDetail 是否不展示详情
     * @return InvocationFuture 可以设置回调函数。成功会返回成功信息，错误会返回相应的错误码。
     */
    InvocationFuture<Void> setPushShowNoDetail(boolean showNoDetail);

    /**
     * 获取推送是否不展示详情
     *
     * @return 当前是否不展示详情
     */
    boolean isPushShowNoDetail();

    /**
     * 获取推送免打扰设置
     *
     * @return NoDisturbConfig
     */
    NoDisturbConfig getPushNoDisturbConfig();

    /**
     * SDK 是否存在推送消息提醒的免打扰。
     *
     * @return SDK 是否存在推送消息提醒的免打扰。
     */
    boolean isPushNoDisturbConfigExist();

    /**
     * Activity是否是由点击 fcm 通知启动
     *
     * @param intent activity intent
     * @return 判断结果
     */
    boolean isFCMIntent(Intent intent);

    /**
     * 从 FCM 中解出 payload 字符串
     *
     * @param intent activity intent
     * @return
     */
    String parseFCMPayload(Intent intent);
}
