package com.netease.nimlib.sdk.mixpush;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.hihonor.push.sdk.HonorPushDataMsg;
import com.netease.nimlib.log.NimLog;
import com.netease.nimlib.mixpush.model.PushType;
import com.netease.nimlib.mixpush.platforms.MixPushPlatforms;

/**
 * 以下这些方法运行在非 UI 线程中, 与荣耀的HonorMessageService 方法一一对应。
 * 当开发者自身也接入荣耀推送，则应将继承 HonorMessageService 改为继承 HonorPushMessageService，其他不变
 */
public class HonorPushMessageService extends Service {

    private static final String TAG = "HonorPushMessageService";
    public static final String ACTION = "com.netease.nimlib.mixpush.honor.action.MESSAGING_EVENT";

    public void onCreate(Context context) {
        NimLog.mixPush(TAG + " onCreate");
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onNewToken(String token) {
        NimLog.mixPush(TAG + " onNewToken, token=" + token);
        MixPushPlatforms.getPushPlatform(PushType.HONOR).onToken(token);
    }

    /**
     * 透传消息， 需要用户自己弹出通知
     *
     * @param msg
     */
    public void onMessageReceived(HonorPushDataMsg msg) {
        NimLog.mixPush(TAG + " onMessageReceived");
    }

}
