package com.netease.nimlib.sdk.mixpush;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;

import androidx.annotation.Nullable;

import com.huawei.hms.push.RemoteMessage;
import com.netease.nimlib.log.NimLog;
import com.netease.nimlib.mixpush.model.PushType;
import com.netease.nimlib.mixpush.platforms.MixPushPlatforms;

/**
 * 以下这些方法运行在非 UI 线程中, 与HuaWei的PHmsMessageService 方法一一对应。
 * 当开发者自身也接入HuaWei推送，则应将继承 HmsMessageService 改为继承 HWPushMessageService，其他不变
 * Created by hzsunyj on 2019-12-17.
 */
public class HWPushMessageService extends Service {

    private static final String TAG = "HWPushMessageService";

    public void onCreate(Context context) {
        NimLog.mixPush(TAG + " onCreate");
    }

    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onNewToken(String token) {
        NimLog.mixPush(TAG + " onNewToken, token=" + token);
        MixPushPlatforms.getPushPlatform(PushType.HUA_WEI).onToken(token);
    }

    /**
     * 透传消息， 需要用户自己弹出通知
     *
     * @param remoteMessage
     */
    public void onMessageReceived(RemoteMessage remoteMessage) {
        NimLog.mixPush(TAG + " onMessageReceived");
    }

    public void onMessageSent(String s) {
        NimLog.mixPush(TAG + " onMessageSent");
    }

    public void onDeletedMessages() {
        NimLog.mixPush(TAG + " onDeletedMessages");
    }

    public void onSendError(String var1, Exception var2) {
        NimLog.mixPush(TAG + " onSendError, " + var2);
    }
}
