/*
 * Decompiled with CFR 0.152.
 */
package org.spongycastle.jcajce;

import org.spongycastle.crypto.CharToByteConverter;
import org.spongycastle.jcajce.PBKDFKey;
import org.spongycastle.util.Arrays;

public class PBKDF2Key
implements PBKDFKey {
    private final char[] password;
    private final CharToByteConverter converter;

    public PBKDF2Key(char[] password, CharToByteConverter converter) {
        this.password = Arrays.clone((char[])password);
        this.converter = converter;
    }

    public char[] getPassword() {
        return this.password;
    }

    public String getAlgorithm() {
        return "PBKDF2";
    }

    public String getFormat() {
        return this.converter.getType();
    }

    public byte[] getEncoded() {
        return this.converter.convert(this.password);
    }
}

