package com.hqwx.android.platform.kt

import android.net.Uri

/**
 * Time:2022/4/14 2:40 PM
 * Author: zhanghanguo@hqwx.com
 * Description: Uri 扩展函数
 */
fun Uri.getIntQueryParameter(key: String): Int {
    return try {
        this.getQueryParameter(key)?.toInt() ?: 0
    } catch (ignored: Exception) {
        0
    }
}

fun Uri.getLongQueryParameter(key: String): Long {
    return try {
        this.getQueryParameter(key)?.toLong() ?: 0L
    } catch (ignored: Exception) {
        0
    }
}