package com.hqwx.android.platform.kt

import com.hqwx.android.platform.mvp.MvpView
import rx.Observable
import rx.android.schedulers.AndroidSchedulers
import rx.schedulers.Schedulers
import rx.subscriptions.CompositeSubscription

/**
 * 显示页面等待
 */
fun <T> Observable<T>.toSubscribe(
    compositeSubscription: CompositeSubscription, mvpView:
    MvpView?, next: (t: T)
    -> Unit, error: (t: Throwable) -> Unit, successHideLoadingView: Boolean = true
) {
    compositeSubscription.add(
        this.subscribeOn(Schedulers.io())
            .doOnSubscribe {
                mvpView?.let {
                    if (it.isActive) {
                        mvpView.showLoadingView()
                    }
                }
            }
            .subscribeOn(AndroidSchedulers.mainThread())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({ t ->
                mvpView?.let { view ->
                    if (view.isActive) {
                        if (successHideLoadingView) {
                            view.hideLoadingView()
                        }
                        next.invoke(t)
                    }
                }
            }, { t ->
                mvpView?.let { view ->
                    if (view.isActive) {
                        view.hideLoadingView()
                        error.invoke(t)
                    }
                }
            })

    )
}

/**
 * 显示操作等待loading
 */
fun <T> Observable<T>.toSubscribeWithLoading(
    compositeSubscription: CompositeSubscription, mvpView:
    MvpView?, next: (t: T)
    -> Unit, error: (t: Throwable) -> Unit
) {
    compositeSubscription.add(
        this.subscribeOn(Schedulers.io())
            .doOnSubscribe {
                mvpView?.let {
                    if (it.isActive) {
                        mvpView.showLoading()
                    }
                }
            }
            .subscribeOn(AndroidSchedulers.mainThread())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({ t ->
                mvpView?.let { view ->
                    if (view.isActive) {
                        view.hideLoading()
                        next.invoke(t)
                    }
                }
            }, { t ->
                mvpView?.let { view ->
                    if (view.isActive) {
                        view.hideLoading()
                        error.invoke(t)
                    }
                }
            })

    )
}

fun <T> Observable<T>.toSubscribeWithoutLoading(
    compositeSubscription: CompositeSubscription, mvpView:
    MvpView?, next: (t: T)
    -> Unit, error: (t: Throwable) -> Unit
) {
    compositeSubscription.add(
        this.subscribeOn(Schedulers.io())
            .observeOn(AndroidSchedulers.mainThread())
            .subscribe({ t ->
                mvpView?.let { view ->
                    if (view.isActive) {
                        next.invoke(t)
                    }
                }
            }, { t ->
                mvpView?.let { view ->
                    if (view.isActive) {
                        error.invoke(t)
                    }
                }
            })

    )
}

fun <T> Observable<T>.toSubscribe(
    next: (t: T)
    -> Unit, error: (t: Throwable) -> Unit
) {
    this.subscribeOn(Schedulers.io())
        .observeOn(AndroidSchedulers.mainThread())
        .subscribe({ t ->
            next.invoke(t)

        }, { t ->
            error.invoke(t)

        })
}
