/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.sessions;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.firebase.sessions.ProcessDetails;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ\r\u0010\u0011\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/google/firebase/sessions/ProcessDetailsProvider;", "", "()V", "buildProcessDetails", "Lcom/google/firebase/sessions/ProcessDetails;", "processName", "", "pid", "", "importance", "isDefaultProcess", "", "getAppProcessDetails", "", "context", "Landroid/content/Context;", "getCurrentProcessDetails", "getProcessName", "getProcessName$com_google_firebase_firebase_sessions", "com.google.firebase-firebase-sessions"})
public final class ProcessDetailsProvider {
    @NotNull
    public static final ProcessDetailsProvider INSTANCE = new ProcessDetailsProvider();

    private ProcessDetailsProvider() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProcessDetails> getAppProcessDetails(@NotNull Context context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ActivityManager.RunningAppProcessInfo it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ActivityManager activityManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int appUid = context.getApplicationInfo().uid;
        String defaultProcessName = context.getApplicationInfo().processName;
        Object object = context.getSystemService("activity");
        ActivityManager activityManager2 = activityManager = object instanceof ActivityManager ? (ActivityManager)object : null;
        Iterable iterable = activityManager2 != null ? activityManager2.getRunningAppProcesses() : null;
        List runningAppProcesses = iterable == null ? CollectionsKt.emptyList() : iterable;
        iterable = CollectionsKt.filterNotNull((Iterable)runningAppProcesses);
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ActivityManager.RunningAppProcessInfo)element$iv$iv;
            boolean bl = false;
            if (!(it.uid == appUid)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void runningAppProcessInfo;
            it = (ActivityManager.RunningAppProcessInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = runningAppProcessInfo.processName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"runningAppProcessInfo.processName");
            collection.add(new ProcessDetails(string, runningAppProcessInfo.pid, runningAppProcessInfo.importance, Intrinsics.areEqual((Object)runningAppProcessInfo.processName, (Object)defaultProcessName)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ProcessDetails getCurrentProcessDetails(@NotNull Context context) {
        ProcessDetails processDetails;
        Object v0;
        int pid;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            pid = Process.myPid();
            Iterable iterable = this.getAppProcessDetails(context);
            for (Object t : iterable) {
                ProcessDetails it = (ProcessDetails)t;
                boolean bl = false;
                if (!(it.getPid() == pid)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((processDetails = (ProcessDetails)v0) == null) {
            processDetails = ProcessDetailsProvider.buildProcessDetails$default(this, this.getProcessName$com_google_firebase_firebase_sessions(), pid, 0, false, 12, null);
        }
        return processDetails;
    }

    private final ProcessDetails buildProcessDetails(String processName, int pid, int importance, boolean isDefaultProcess) {
        return new ProcessDetails(processName, pid, importance, isDefaultProcess);
    }

    static /* synthetic */ ProcessDetails buildProcessDetails$default(ProcessDetailsProvider processDetailsProvider, String string, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            bl = false;
        }
        return processDetailsProvider.buildProcessDetails(string, n, n2, bl);
    }

    @NotNull
    public final String getProcessName$com_google_firebase_firebase_sessions() {
        String string;
        if (Build.VERSION.SDK_INT >= 33) {
            String string2 = Process.myProcessName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"myProcessName()");
            return string2;
        }
        if (Build.VERSION.SDK_INT >= 28 && (string = Application.getProcessName()) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        string = ProcessUtils.getMyProcessName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        return "";
    }
}

