/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.cloudmessaging.CloudMessage;
import com.google.android.gms.cloudmessaging.Rpc;
import com.google.firebase.messaging.DisplayNotification;
import com.google.firebase.messaging.EnhancedIntentService;
import com.google.firebase.messaging.FcmExecutors;
import com.google.firebase.messaging.MessagingAnalytics;
import com.google.firebase.messaging.NotificationParams;
import com.google.firebase.messaging.RemoteMessage;
import com.google.firebase.messaging.SendException;
import com.google.firebase.messaging.ServiceStarter;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ExecutorService;

public class FirebaseMessagingService
extends EnhancedIntentService {
    static final String ACTION_REMOTE_INTENT = "com.google.android.c2dm.intent.RECEIVE";
    public static final String ACTION_DIRECT_BOOT_REMOTE_INTENT = "com.google.firebase.messaging.RECEIVE_DIRECT_BOOT";
    static final String ACTION_NEW_TOKEN = "com.google.firebase.messaging.NEW_TOKEN";
    static final String EXTRA_TOKEN = "token";
    private static final int RECENTLY_RECEIVED_MESSAGE_IDS_MAX_SIZE = 10;
    private static final Queue<String> recentlyReceivedMessageIds = new ArrayDeque<String>(10);
    private Rpc rpc;

    @WorkerThread
    public void onMessageReceived(@NonNull RemoteMessage message) {
    }

    @WorkerThread
    public void onDeletedMessages() {
    }

    @Deprecated
    @WorkerThread
    public void onMessageSent(@NonNull String msgId) {
    }

    @Deprecated
    @WorkerThread
    public void onSendError(@NonNull String msgId, @NonNull Exception exception) {
    }

    @WorkerThread
    public void onNewToken(@NonNull String token) {
    }

    @Override
    protected Intent getStartCommandIntent(Intent originalIntent) {
        return ServiceStarter.getInstance().getMessagingEvent();
    }

    @Override
    public void handleIntent(Intent intent) {
        String action = intent.getAction();
        if (ACTION_REMOTE_INTENT.equals(action) || ACTION_DIRECT_BOOT_REMOTE_INTENT.equals(action)) {
            this.handleMessageIntent(intent);
        } else if (ACTION_NEW_TOKEN.equals(action)) {
            this.onNewToken(intent.getStringExtra(EXTRA_TOKEN));
        } else {
            Log.d((String)"FirebaseMessaging", (String)("Unknown intent action: " + intent.getAction()));
        }
    }

    private void handleMessageIntent(Intent intent) {
        String messageId = intent.getStringExtra("google.message_id");
        if (!this.alreadyReceivedMessage(messageId)) {
            this.passMessageIntentToSdk(intent);
        }
        this.getRpc((Context)this).messageHandled(new CloudMessage(intent));
    }

    private void passMessageIntentToSdk(Intent intent) {
        String messageType = intent.getStringExtra("message_type");
        if (messageType == null) {
            messageType = "gcm";
        }
        switch (messageType) {
            case "gcm": {
                MessagingAnalytics.logNotificationReceived(intent);
                this.dispatchMessage(intent);
                break;
            }
            case "deleted_messages": {
                this.onDeletedMessages();
                break;
            }
            case "send_event": {
                this.onMessageSent(intent.getStringExtra("google.message_id"));
                break;
            }
            case "send_error": {
                this.onSendError(this.getMessageId(intent), new SendException(intent.getStringExtra("error")));
                break;
            }
            default: {
                Log.w((String)"FirebaseMessaging", (String)("Received message with unknown type: " + messageType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessage(Intent intent) {
        Bundle data = intent.getExtras();
        if (data == null) {
            data = new Bundle();
        }
        data.remove("androidx.content.wakelockid");
        if (NotificationParams.isNotification(data)) {
            NotificationParams params = new NotificationParams(data);
            ExecutorService executor = FcmExecutors.newNetworkIOExecutor();
            DisplayNotification displayNotification = new DisplayNotification((Context)this, params, executor);
            try {
                if (displayNotification.handleNotification()) {
                    return;
                }
            }
            finally {
                executor.shutdown();
            }
            if (MessagingAnalytics.shouldUploadScionMetrics(intent)) {
                MessagingAnalytics.logNotificationForeground(intent);
            }
        }
        this.onMessageReceived(new RemoteMessage(data));
    }

    private boolean alreadyReceivedMessage(String messageId) {
        if (TextUtils.isEmpty((CharSequence)messageId)) {
            return false;
        }
        if (recentlyReceivedMessageIds.contains(messageId)) {
            if (Log.isLoggable((String)"FirebaseMessaging", (int)3)) {
                Log.d((String)"FirebaseMessaging", (String)("Received duplicate message: " + messageId));
            }
            return true;
        }
        if (recentlyReceivedMessageIds.size() >= 10) {
            recentlyReceivedMessageIds.remove();
        }
        recentlyReceivedMessageIds.add(messageId);
        return false;
    }

    private String getMessageId(Intent intent) {
        String messageId = intent.getStringExtra("google.message_id");
        if (messageId == null) {
            messageId = intent.getStringExtra("message_id");
        }
        return messageId;
    }

    private Rpc getRpc(Context context) {
        if (this.rpc == null) {
            this.rpc = new Rpc(context.getApplicationContext());
        }
        return this.rpc;
    }

    @VisibleForTesting
    static void resetForTesting() {
        recentlyReceivedMessageIds.clear();
    }

    @VisibleForTesting
    void setRpcForTesting(Rpc rpc) {
        this.rpc = rpc;
    }
}

