/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.installations.local;

import android.content.SharedPreferences;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.json.JSONException;
import org.json.JSONObject;

public class IidStore {
    private static final String IID_SHARED_PREFS_NAME = "com.google.android.gms.appid";
    private static final String STORE_KEY_PUB = "|S||P|";
    private static final String STORE_KEY_ID = "|S|id";
    private static final String STORE_KEY_TOKEN = "|T|";
    private static final String STORE_KEY_SEPARATOR = "|";
    private static final String JSON_TOKEN_KEY = "token";
    private static final String JSON_ENCODED_PREFIX = "{";
    private static final String[] ALLOWABLE_SCOPES = new String[]{"*", "FCM", "GCM", ""};
    @GuardedBy(value="iidPrefs")
    private final SharedPreferences iidPrefs;
    private final String defaultSenderId;

    public IidStore(@NonNull FirebaseApp firebaseApp) {
        this.iidPrefs = firebaseApp.getApplicationContext().getSharedPreferences(IID_SHARED_PREFS_NAME, 0);
        this.defaultSenderId = IidStore.getDefaultSenderId(firebaseApp);
    }

    @VisibleForTesting
    public IidStore(@NonNull SharedPreferences iidPrefs, @Nullable String defaultSenderId) {
        this.iidPrefs = iidPrefs;
        this.defaultSenderId = defaultSenderId;
    }

    private static String getDefaultSenderId(FirebaseApp app) {
        String senderId = app.getOptions().getGcmSenderId();
        if (senderId != null) {
            return senderId;
        }
        String appId = app.getOptions().getApplicationId();
        if (!appId.startsWith("1:") && !appId.startsWith("2:")) {
            return appId;
        }
        String[] parts = appId.split(":");
        if (parts.length != 4) {
            return null;
        }
        String projectNumber = parts[1];
        if (projectNumber.isEmpty()) {
            return null;
        }
        return projectNumber;
    }

    private String createTokenKey(@NonNull String senderId, @NonNull String scope) {
        return STORE_KEY_TOKEN + senderId + STORE_KEY_SEPARATOR + scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readToken() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            for (String scope : ALLOWABLE_SCOPES) {
                String tokenKey = this.createTokenKey(this.defaultSenderId, scope);
                String token = this.iidPrefs.getString(tokenKey, null);
                if (token == null || token.isEmpty()) continue;
                return token.startsWith(JSON_ENCODED_PREFIX) ? this.parseIidTokenFromJson(token) : token;
            }
            return null;
        }
    }

    private String parseIidTokenFromJson(String token) {
        try {
            JSONObject json = new JSONObject(token);
            return json.getString(JSON_TOKEN_KEY);
        }
        catch (JSONException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String readIid() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            String id = this.readInstanceIdFromLocalStorage();
            if (id != null) {
                return id;
            }
            return this.readPublicKeyFromLocalStorageAndCalculateInstanceId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String readInstanceIdFromLocalStorage() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            return this.iidPrefs.getString(STORE_KEY_ID, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String readPublicKeyFromLocalStorageAndCalculateInstanceId() {
        SharedPreferences sharedPreferences = this.iidPrefs;
        synchronized (sharedPreferences) {
            String base64PublicKey = this.iidPrefs.getString(STORE_KEY_PUB, null);
            if (base64PublicKey == null) {
                return null;
            }
            PublicKey publicKey = this.parseKey(base64PublicKey);
            if (publicKey == null) {
                return null;
            }
            return IidStore.getIdFromPublicKey(publicKey);
        }
    }

    @Nullable
    private static String getIdFromPublicKey(@NonNull PublicKey publicKey) {
        byte[] derPub = publicKey.getEncoded();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(derPub);
            int b0 = digest[0];
            b0 = 112 + (0xF & b0);
            digest[0] = (byte)(b0 & 0xFF);
            return Base64.encodeToString((byte[])digest, (int)0, (int)8, (int)11);
        }
        catch (NoSuchAlgorithmException e) {
            Log.w((String)"ContentValues", (String)"Unexpected error, device missing required algorithms");
            return null;
        }
    }

    @Nullable
    private PublicKey parseKey(String base64PublicKey) {
        try {
            byte[] publicKeyBytes = Base64.decode((String)base64PublicKey, (int)8);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(new X509EncodedKeySpec(publicKeyBytes));
        }
        catch (IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            Log.w((String)"ContentValues", (String)("Invalid key stored " + e));
            return null;
        }
    }
}

