/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.ndk;

import androidx.annotation.Nullable;
import com.google.firebase.crashlytics.internal.model.CrashlyticsReport;
import java.io.File;

final class SessionFiles {
    public final NativeCore nativeCore;
    public final File binaryImages;
    public final File metadata;
    public final File session;
    public final File app;
    public final File device;
    public final File os;

    private SessionFiles(Builder builder) {
        this.nativeCore = builder.nativeCore;
        this.binaryImages = builder.binaryImages;
        this.metadata = builder.metadata;
        this.session = builder.session;
        this.app = builder.app;
        this.device = builder.device;
        this.os = builder.os;
    }

    static final class Builder {
        private NativeCore nativeCore;
        private File binaryImages;
        private File metadata;
        private File session;
        private File app;
        private File device;
        private File os;

        Builder() {
        }

        Builder nativeCore(NativeCore nativeCore) {
            this.nativeCore = nativeCore;
            return this;
        }

        Builder binaryImagesFile(File binaryImages) {
            this.binaryImages = binaryImages;
            return this;
        }

        Builder metadataFile(File metadata) {
            this.metadata = metadata;
            return this;
        }

        Builder sessionFile(File session) {
            this.session = session;
            return this;
        }

        Builder appFile(File app) {
            this.app = app;
            return this;
        }

        Builder deviceFile(File device) {
            this.device = device;
            return this;
        }

        Builder osFile(File os) {
            this.os = os;
            return this;
        }

        SessionFiles build() {
            return new SessionFiles(this);
        }
    }

    static final class NativeCore {
        @Nullable
        public final File minidump;
        @Nullable
        public final CrashlyticsReport.ApplicationExitInfo applicationExitInfo;

        NativeCore(@Nullable File minidump, @Nullable CrashlyticsReport.ApplicationExitInfo applicationExitInfo) {
            this.minidump = minidump;
            this.applicationExitInfo = applicationExitInfo;
        }

        boolean hasCore() {
            return this.minidump != null && this.minidump.exists() || this.applicationExitInfo != null;
        }
    }
}

