/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig.interop.rollouts;

import androidx.annotation.NonNull;
import com.google.auto.value.AutoValue;
import com.google.firebase.encoders.DataEncoder;
import com.google.firebase.encoders.annotations.Encodable;
import com.google.firebase.encoders.json.JsonDataEncoderBuilder;
import com.google.firebase.remoteconfig.interop.rollouts.AutoRolloutAssignmentEncoder;
import com.google.firebase.remoteconfig.interop.rollouts.AutoValue_RolloutAssignment;
import org.json.JSONException;
import org.json.JSONObject;

@Encodable
@AutoValue
public abstract class RolloutAssignment {
    private static final String ROLLOUT_ID = "rolloutId";
    private static final String VARIANT_ID = "variantId";
    private static final String PARAMETER_KEY = "parameterKey";
    private static final String PARAMETER_VALUE = "parameterValue";
    private static final String TEMPLATE_VERSION = "templateVersion";
    public static final DataEncoder ROLLOUT_ASSIGNMENT_JSON_ENCODER = new JsonDataEncoderBuilder().configureWith(AutoRolloutAssignmentEncoder.CONFIG).build();

    @NonNull
    public abstract String getRolloutId();

    @NonNull
    public abstract String getVariantId();

    @NonNull
    public abstract String getParameterKey();

    @NonNull
    public abstract String getParameterValue();

    public abstract long getTemplateVersion();

    @NonNull
    public static RolloutAssignment create(@NonNull JSONObject json) throws JSONException {
        return RolloutAssignment.builder().setRolloutId(json.getString(ROLLOUT_ID)).setVariantId(json.getString(VARIANT_ID)).setParameterKey(json.getString(PARAMETER_KEY)).setParameterValue(json.getString(PARAMETER_VALUE)).setTemplateVersion(json.getLong(TEMPLATE_VERSION)).build();
    }

    @NonNull
    public static RolloutAssignment create(@NonNull String jsonString) throws JSONException {
        return RolloutAssignment.create(new JSONObject(jsonString));
    }

    @NonNull
    public static Builder builder() {
        return new AutoValue_RolloutAssignment.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @NonNull
        public abstract Builder setRolloutId(@NonNull String var1);

        @NonNull
        public abstract Builder setVariantId(@NonNull String var1);

        @NonNull
        public abstract Builder setParameterKey(@NonNull String var1);

        @NonNull
        public abstract Builder setParameterValue(@NonNull String var1);

        @NonNull
        public abstract Builder setTemplateVersion(long var1);

        @NonNull
        public abstract RolloutAssignment build();
    }
}

