/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import com.google.android.gms.common.internal.Preconditions;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.TotpSecret;

public final class zzcb
implements TotpSecret {
    private final String zza;
    private final String zzb;
    private final int zzc;
    private final int zzd;
    private final long zze;
    private String zzf;
    private FirebaseAuth zzg;

    @Override
    public final int getCodeIntervalSeconds() {
        return this.zzd;
    }

    @Override
    public final int getCodeLength() {
        return this.zzc;
    }

    @Override
    public final long getEnrollmentCompletionDeadline() {
        return this.zze;
    }

    @Override
    public final String generateQrCodeUrl() {
        String string = Preconditions.checkNotEmpty((String)((FirebaseUser)Preconditions.checkNotNull((Object)this.zzg.getCurrentUser(), (Object)"Current user cannot be null, since user is required to be logged in to enroll for TOTP MFA.")).getEmail(), (Object)"Email cannot be empty, since verified email is required to use MFA.");
        String string2 = this.zzg.getApp().getName();
        return this.generateQrCodeUrl(string, string2);
    }

    @Override
    public final String generateQrCodeUrl(String string, String string2) {
        Preconditions.checkNotEmpty((String)string, (Object)"accountName cannot be empty.");
        Preconditions.checkNotEmpty((String)string2, (Object)"issuer cannot be empty.");
        return String.format(null, "otpauth://totp/%s:%s?secret=%s&issuer=%s&algorithm=%s&digits=%d", string2, string, this.zza, string2, this.zzb, this.zzc);
    }

    @Override
    public final String getHashAlgorithm() {
        return this.zzb;
    }

    @Override
    public final String getSessionInfo() {
        return this.zzf;
    }

    @Override
    public final String getSharedSecretKey() {
        return this.zza;
    }

    public zzcb(String string, String string2, int n, int n2, long l, String string3, FirebaseAuth firebaseAuth) {
        Preconditions.checkNotEmpty((String)string3, (Object)"sessionInfo cannot be empty.");
        Preconditions.checkNotNull((Object)firebaseAuth, (Object)"firebaseAuth cannot be null.");
        this.zza = Preconditions.checkNotEmpty((String)string, (Object)"sharedSecretKey cannot be empty. This is required to generate QR code URL.");
        this.zzb = Preconditions.checkNotEmpty((String)string2, (Object)"hashAlgorithm cannot be empty.");
        this.zzc = n;
        this.zzd = n2;
        this.zze = l;
        this.zzf = string3;
        this.zzg = firebaseAuth;
    }

    @Override
    public final void openInOtpApp(String string) {
        Preconditions.checkNotEmpty((String)string, (Object)"qrCodeUrl cannot be empty.");
        try {
            this.zza(string);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            this.zza("https://play.google.com/store/search?q=otpauth&c=apps");
            return;
        }
    }

    @Override
    public final void openInOtpApp(String string, String string2, Activity activity) {
        Preconditions.checkNotEmpty((String)string, (Object)"QrCodeUrl cannot be empty.");
        Preconditions.checkNotEmpty((String)string2, (Object)"FallbackUrl cannot be empty.");
        Preconditions.checkNotNull((Object)activity, (Object)"Activity cannot be null.");
        try {
            zzcb.zza(string, activity);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzcb.zza(string2, activity);
            return;
        }
    }

    private final void zza(String string) {
        this.zzg.getApp().getApplicationContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)string)).addFlags(0x10000000));
    }

    private static void zza(String string, Activity activity) {
        Preconditions.checkNotNull((Object)activity, (Object)"Activity cannot be null.");
        activity.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)string)).addFlags(0x10000000));
    }
}

