/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.common.util.AndroidUtilsLight;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Hex;
import com.google.android.gms.internal.firebase-auth-api.zzadj;
import com.google.android.gms.internal.firebase-auth-api.zzadk;
import com.google.android.gms.internal.firebase-auth-api.zzadl;
import com.google.android.gms.internal.firebase-auth-api.zzafb;
import com.google.android.gms.internal.firebase-auth-api.zzahr;
import com.google.android.gms.internal.firebase-auth-api.zzb;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.interop.InteropAppCheckTokenProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.internal.zzaq;
import com.google.firebase.auth.internal.zzbf;
import com.google.firebase.auth.internal.zzbh;
import com.google.firebase.auth.internal.zzbm;
import com.google.firebase.auth.internal.zzcd;
import com.google.firebase.auth.internal.zzcf;
import com.google.firebase.auth.internal.zzp;
import com.google.firebase.auth.internal.zzq;
import com.google.firebase.auth.internal.zzs;
import com.google.firebase.inject.Provider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

@KeepName
public class GenericIdpActivity
extends FragmentActivity
implements zzadl {
    private static long zzb = 0L;
    private static final zzcf zzc = zzcf.zzc();
    private boolean zzd = false;

    @Override
    @NonNull
    public final Context zza() {
        return this.getApplicationContext();
    }

    @Nullable
    private final Uri.Builder zza(Uri.Builder builder, Intent intent, String string, String string2) {
        String string3 = intent.getStringExtra("com.google.firebase.auth.KEY_API_KEY");
        String string4 = intent.getStringExtra("com.google.firebase.auth.KEY_PROVIDER_ID");
        String string5 = intent.getStringExtra("com.google.firebase.auth.KEY_TENANT_ID");
        String string6 = intent.getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME");
        ArrayList arrayList = intent.getStringArrayListExtra("com.google.firebase.auth.KEY_PROVIDER_SCOPES");
        String string7 = null;
        if (arrayList != null && !arrayList.isEmpty()) {
            string7 = TextUtils.join((CharSequence)",", (Iterable)arrayList);
        }
        String string8 = GenericIdpActivity.zza(intent.getBundleExtra("com.google.firebase.auth.KEY_PROVIDER_CUSTOM_PARAMS"));
        String string9 = UUID.randomUUID().toString();
        String string10 = zzadk.zza(this, UUID.randomUUID().toString());
        String string11 = intent.getAction();
        String string12 = intent.getStringExtra("com.google.firebase.auth.internal.CLIENT_VERSION");
        zzq.zza().zza(this.getApplicationContext(), string, string9, string10, string11, string4, string5, string6);
        FirebaseApp firebaseApp = FirebaseApp.getInstance((String)string6);
        String string13 = zzs.zza(this.getApplicationContext(), firebaseApp.getPersistenceKey()).zza();
        if (TextUtils.isEmpty((CharSequence)string13)) {
            Log.e((String)"GenericIdpActivity", (String)"Could not generate an encryption key for Generic IDP - cancelling flow.");
            this.zza(zzaq.zza("Failed to generate/retrieve public encryption key for Generic IDP flow."));
            return null;
        }
        if (string10 == null) {
            return null;
        }
        String string14 = string12;
        builder.appendQueryParameter("eid", "p").appendQueryParameter("v", "X" + string14).appendQueryParameter("authType", "signInWithRedirect").appendQueryParameter("apiKey", string3).appendQueryParameter("providerId", string4).appendQueryParameter("sessionId", string10).appendQueryParameter("eventId", string9).appendQueryParameter("apn", string).appendQueryParameter("sha1Cert", string2).appendQueryParameter("publicKey", string13);
        if (!TextUtils.isEmpty((CharSequence)string7)) {
            builder.appendQueryParameter("scopes", string7);
        }
        if (!TextUtils.isEmpty((CharSequence)string8)) {
            builder.appendQueryParameter("customParameters", string8);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            builder.appendQueryParameter("tid", string5);
        }
        return builder;
    }

    @Override
    @Nullable
    public final Uri.Builder zza(@NonNull Intent intent, @NonNull String string, @NonNull String string2) {
        Uri.Builder builder = new Uri.Builder().scheme("https").appendPath("__").appendPath("auth").appendPath("handler");
        return this.zza(builder, intent, string, string2);
    }

    static /* synthetic */ Uri zza(Uri uri, Task task) throws Exception {
        Uri.Builder builder = uri.buildUpon();
        if (task.isSuccessful()) {
            String string;
            AppCheckTokenResult appCheckTokenResult = (AppCheckTokenResult)task.getResult();
            if (appCheckTokenResult.getError() != null) {
                string = String.valueOf(appCheckTokenResult.getError());
                Log.w((String)"GenericIdpActivity", (String)("Error getting App Check token; using placeholder token instead. Error: " + string));
            }
            string = appCheckTokenResult.getToken();
            builder.fragment("fac=" + string);
        } else {
            String string = task.getException().getMessage();
            Log.e((String)"GenericIdpActivity", (String)("Unexpected error getting App Check token: " + string));
        }
        return builder.build();
    }

    @Override
    @NonNull
    public final String zza(@NonNull String string) {
        return zzafb.zzb(string);
    }

    @Nullable
    private static String zza(Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        try {
            for (String string : bundle.keySet()) {
                String string2 = bundle.getString(string);
                if (TextUtils.isEmpty((CharSequence)string2)) continue;
                jSONObject.put(string, (Object)string2);
            }
        }
        catch (JSONException jSONException) {
            Log.e((String)"GenericIdpActivity", (String)"Unexpected JSON exception when serializing developer specified custom params");
        }
        return jSONObject.toString();
    }

    @Override
    @Nullable
    public final HttpURLConnection zza(@NonNull URL uRL) {
        try {
            return (HttpURLConnection)com.google.android.gms.internal.firebase-auth-api.zzb.zza().zza(uRL, "client-firebase-auth-api");
        }
        catch (IOException iOException) {
            Log.e((String)"GenericIdpActivity", (String)"Error generating URL connection");
            return null;
        }
    }

    private final void zzb() {
        zzb = 0L;
        this.zzd = false;
        Intent intent = new Intent();
        intent.putExtra("com.google.firebase.auth.internal.EXTRA_CANCELED", true);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!this.zza(intent)) {
            Status status = zzaq.zza("WEB_CONTEXT_CANCELED");
            zzbm.zza((Context)this, status);
        } else {
            zzc.zza((Context)this);
        }
        this.finish();
    }

    private final void zza(Status status) {
        zzb = 0L;
        this.zzd = false;
        Intent intent = new Intent();
        zzcd.zza(intent, status);
        intent.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
        if (!this.zza(intent)) {
            Status status2 = status;
            zzbm.zza(this.getApplicationContext(), status2);
        } else {
            zzc.zza((Context)this);
        }
        this.finish();
    }

    @Override
    public final void zza(@NonNull String string, @Nullable Status status) {
        if (status == null) {
            this.zzb();
            return;
        }
        this.zza(status);
    }

    @Override
    public final void zza(@NonNull Uri uri, @NonNull String string, @NonNull Provider<InteropAppCheckTokenProvider> provider) {
        Task task;
        Provider<InteropAppCheckTokenProvider> provider2 = provider;
        Uri uri2 = uri;
        InteropAppCheckTokenProvider interopAppCheckTokenProvider = (InteropAppCheckTokenProvider)provider2.get();
        if (interopAppCheckTokenProvider != null) {
            Uri uri3 = uri2;
            task = interopAppCheckTokenProvider.getToken(false).continueWith((Continuation)new zzbh(uri3));
        } else {
            task = Tasks.forResult((Object)uri2);
        }
        String string2 = string;
        GenericIdpActivity genericIdpActivity = this;
        task.addOnCompleteListener((OnCompleteListener)new zzbf(genericIdpActivity, string2));
    }

    protected void onCreate(@NonNull Bundle bundle) {
        super.onCreate(bundle);
        String string = this.getIntent().getAction();
        if (!("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(string) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(string) || "android.intent.action.VIEW".equals(string))) {
            String string2 = string;
            Log.e((String)"GenericIdpActivity", (String)("Could not do operation - unknown action: " + string2));
            this.zzb();
            return;
        }
        long l = DefaultClock.getInstance().currentTimeMillis();
        if (l - zzb < 30000L) {
            Log.e((String)"GenericIdpActivity", (String)"Could not start operation - already in progress");
            return;
        }
        zzb = l;
        if (bundle != null) {
            this.zzd = bundle.getBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN");
        }
    }

    public void onNewIntent(@NonNull Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        if ("android.intent.action.VIEW".equals(this.getIntent().getAction())) {
            Intent intent = this.getIntent();
            GenericIdpActivity genericIdpActivity = this;
            if (intent.hasExtra("firebaseError")) {
                Status status = zzcd.zza(intent.getStringExtra("firebaseError"));
                genericIdpActivity.zza(status);
                return;
            }
            if (intent.hasExtra("link") && intent.hasExtra("eventId")) {
                String string = intent.getStringExtra("link");
                String string2 = intent.getStringExtra("eventId");
                String string3 = genericIdpActivity.getPackageName();
                boolean bl = intent.getBooleanExtra("encryptionEnabled", true);
                zzp zzp2 = zzq.zza().zza((Context)genericIdpActivity, string3, string2);
                if (zzp2 == null) {
                    genericIdpActivity.zzb();
                }
                if (bl) {
                    string = zzs.zza(genericIdpActivity.getApplicationContext(), FirebaseApp.getInstance((String)zzp2.zza()).getPersistenceKey()).zza(string);
                }
                zzahr zzahr2 = new zzahr(zzp2, string);
                String string4 = zzp2.zze();
                String string5 = zzp2.zzb();
                zzahr2.zzb(string4);
                if ("com.google.firebase.auth.internal.NONGMSCORE_SIGN_IN".equals(string5) || "com.google.firebase.auth.internal.NONGMSCORE_LINK".equals(string5) || "com.google.firebase.auth.internal.NONGMSCORE_REAUTHENTICATE".equals(string5)) {
                    String string6 = string4;
                    zzahr zzahr3 = zzahr2;
                    String string7 = string5;
                    GenericIdpActivity genericIdpActivity2 = genericIdpActivity;
                    zzb = 0L;
                    genericIdpActivity2.zzd = false;
                    Intent intent2 = new Intent();
                    SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)zzahr3, (Intent)intent2, (String)"com.google.firebase.auth.internal.VERIFY_ASSERTION_REQUEST");
                    intent2.putExtra("com.google.firebase.auth.internal.OPERATION", string7);
                    intent2.setAction("com.google.firebase.auth.ACTION_RECEIVE_FIREBASE_AUTH_INTENT");
                    if (!genericIdpActivity2.zza(intent2)) {
                        String string8 = string6;
                        String string9 = string7;
                        zzahr zzahr4 = zzahr3;
                        zzbm.zza(genericIdpActivity2.getApplicationContext(), zzahr4, string9, string8);
                    } else {
                        zzc.zza((Context)genericIdpActivity2);
                    }
                    genericIdpActivity2.finish();
                    return;
                }
                String string10 = string5;
                Log.e((String)"GenericIdpActivity", (String)("unsupported operation: " + string10));
                genericIdpActivity.zzb();
                return;
            }
            genericIdpActivity.zzb();
            return;
        }
        if (!this.zzd) {
            block13: {
                String string;
                GenericIdpActivity genericIdpActivity = this;
                String string11 = genericIdpActivity.getPackageName();
                try {
                    string = Hex.bytesToStringUppercase((byte[])AndroidUtilsLight.getPackageCertificateHashBytes((Context)genericIdpActivity, (String)string11)).toLowerCase(Locale.US);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    String string12 = String.valueOf((Object)nameNotFoundException);
                    String string13 = string11;
                    Log.e((String)"GenericIdpActivity", (String)("Could not get package signature: " + string13 + " " + string12));
                    zzadk.zzb(genericIdpActivity, string11);
                    break block13;
                }
                FirebaseApp firebaseApp = FirebaseApp.getInstance((String)genericIdpActivity.getIntent().getStringExtra("com.google.firebase.auth.KEY_FIREBASE_APP_NAME"));
                FirebaseAuth firebaseAuth = FirebaseAuth.getInstance(firebaseApp);
                if (!zzafb.zza(firebaseApp)) {
                    new zzadj(string11, string, genericIdpActivity.getIntent(), firebaseApp, genericIdpActivity).executeOnExecutor(firebaseAuth.zze(), new Void[0]);
                } else {
                    String string14 = zzafb.zza(firebaseApp.getOptions().getApiKey());
                    genericIdpActivity.zza(genericIdpActivity.zza(Uri.parse((String)string14).buildUpon(), genericIdpActivity.getIntent(), string11, string).build(), string11, firebaseAuth.zzc());
                }
            }
            this.zzd = true;
            return;
        }
        this.zzb();
    }

    protected void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("com.google.firebase.auth.internal.KEY_STARTED_SIGN_IN", this.zzd);
    }

    private final boolean zza(Intent intent) {
        return LocalBroadcastManager.getInstance((Context)this).sendBroadcast(intent);
    }
}

