/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase-auth-api.zzahp;
import com.google.android.gms.internal.firebase-auth-api.zzzh;
import com.google.firebase.auth.MultiFactorInfo;
import com.google.firebase.auth.zzas;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Class(creator="TotpMultiFactorInfoCreator")
public class TotpMultiFactorInfo
extends MultiFactorInfo {
    @NonNull
    public static final Parcelable.Creator<TotpMultiFactorInfo> CREATOR = new zzas();
    @SafeParcelable.Field(id=1, getter="getUid")
    private final String zza;
    @SafeParcelable.Field(id=2, getter="getDisplayName")
    @Nullable
    private final String zzb;
    @SafeParcelable.Field(id=3, getter="getEnrollmentTimestamp")
    private final long zzc;
    @SafeParcelable.Field(id=4, getter="getTotpInfo")
    private final zzahp zzd;

    @Override
    public long getEnrollmentTimestamp() {
        return this.zzc;
    }

    @NonNull
    public static TotpMultiFactorInfo zza(@NonNull JSONObject jSONObject) {
        if (!jSONObject.has("enrollmentTimestamp")) {
            throw new IllegalArgumentException("An enrollment timestamp in seconds of UTC time since Unix epoch is required to build a TotpMultiFactorInfo instance.");
        }
        long l = jSONObject.optLong("enrollmentTimestamp");
        if (jSONObject.opt("totpInfo") == null) {
            throw new IllegalArgumentException("A totpInfo is required to build a TotpMultiFactorInfo instance.");
        }
        zzahp zzahp2 = new zzahp();
        String string = jSONObject.optString("uid");
        String string2 = jSONObject.optString("displayName");
        return new TotpMultiFactorInfo(string, string2, l, zzahp2);
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.zzb;
    }

    @Override
    @NonNull
    public String getFactorId() {
        return "totp";
    }

    @Override
    @NonNull
    public String getUid() {
        return this.zza;
    }

    @Override
    @Nullable
    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.putOpt("factorIdKey", (Object)"totp");
            jSONObject.putOpt("uid", (Object)this.zza);
            jSONObject.putOpt("displayName", (Object)this.zzb);
            jSONObject.putOpt("enrollmentTimestamp", (Object)this.zzc);
            jSONObject.putOpt("totpInfo", (Object)this.zzd);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.d((String)"TotpMultiFactorInfo", (String)"Failed to jsonify this object");
            throw new zzzh(jSONException);
        }
    }

    @SafeParcelable.Constructor
    public TotpMultiFactorInfo(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=4) zzahp zzahp2) {
        this.zza = Preconditions.checkNotEmpty((String)string);
        this.zzb = string2;
        this.zzc = l;
        this.zzd = (zzahp)((Object)Preconditions.checkNotNull((Object)((Object)zzahp2), (Object)"totpInfo cannot be null."));
    }

    @SuppressLint(value={"FirebaseUnknownNullness"})
    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        TotpMultiFactorInfo totpMultiFactorInfo = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)((MultiFactorInfo)totpMultiFactorInfo).getUid(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)((MultiFactorInfo)totpMultiFactorInfo).getDisplayName(), (boolean)false);
        SafeParcelWriter.writeLong((Parcel)parcel2, (int)3, (long)((MultiFactorInfo)totpMultiFactorInfo).getEnrollmentTimestamp());
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)totpMultiFactorInfo.zzd, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }
}

