/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.firebase.auth.ActionCodeUrl;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.zzf;

@SafeParcelable.Class(creator="EmailAuthCredentialCreator")
public class EmailAuthCredential
extends AuthCredential {
    @NonNull
    public static final Parcelable.Creator<EmailAuthCredential> CREATOR = new zzf();
    @SafeParcelable.Field(id=1, getter="getEmail")
    private String zza;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getPassword")
    private String zzb;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getSignInLink")
    private final String zzc;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getCachedState")
    private String zzd;
    @SafeParcelable.Field(id=5, getter="isForLinking")
    private boolean zze;

    @Override
    @NonNull
    public final AuthCredential zza() {
        return new EmailAuthCredential(this.zza, this.zzb, this.zzc, this.zzd, this.zze);
    }

    @NonNull
    public final EmailAuthCredential zza(@NonNull FirebaseUser firebaseUser) {
        this.zzd = firebaseUser.zze();
        this.zze = true;
        return this;
    }

    @Nullable
    public final String zzb() {
        return this.zzd;
    }

    @NonNull
    public final String zzc() {
        return this.zza;
    }

    @Nullable
    public final String zzd() {
        return this.zzb;
    }

    @Override
    @NonNull
    public String getProvider() {
        return "password";
    }

    @Nullable
    public final String zze() {
        return this.zzc;
    }

    @Override
    @NonNull
    public String getSignInMethod() {
        if (!TextUtils.isEmpty((CharSequence)this.zzb)) {
            return "password";
        }
        return "emailLink";
    }

    EmailAuthCredential(String string, String string2) {
        this(string, string2, null, null, false);
    }

    @SafeParcelable.Constructor
    EmailAuthCredential(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable String string3, @SafeParcelable.Param(id=4) @Nullable String string4, @SafeParcelable.Param(id=5) boolean bl) {
        this.zza = Preconditions.checkNotEmpty((String)string);
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            throw new IllegalArgumentException("Cannot create an EmailAuthCredential without a password or emailLink.");
        }
        this.zzb = string2;
        this.zzc = string3;
        this.zzd = string4;
        this.zze = bl;
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        EmailAuthCredential emailAuthCredential = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)emailAuthCredential.zza, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)emailAuthCredential.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)emailAuthCredential.zzc, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)emailAuthCredential.zzd, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)emailAuthCredential.zze);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean zzf() {
        return !TextUtils.isEmpty((CharSequence)this.zzc);
    }

    public final boolean zzg() {
        return this.zze;
    }

    public static boolean zza(@NonNull String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        ActionCodeUrl actionCodeUrl = ActionCodeUrl.parseLink(string);
        return actionCodeUrl != null && actionCodeUrl.getOperation() == 4;
    }
}

