/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzmj;
import com.google.android.gms.internal.firebase-auth-api.zzmk;
import com.google.android.gms.internal.firebase-auth-api.zzya;
import com.google.android.gms.internal.firebase-auth-api.zzyd;
import com.google.android.gms.internal.firebase-auth-api.zzyf;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public final class zzyb {
    public static int zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        return (zzmk.zza(ellipticCurve).subtract(BigInteger.ONE).bitLength() + 7) / 8;
    }

    private static BigInteger zza(BigInteger bigInteger, boolean bl, EllipticCurve ellipticCurve) throws GeneralSecurityException {
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        block12: {
            BigInteger bigInteger4;
            bigInteger3 = zzmk.zza(ellipticCurve);
            BigInteger bigInteger5 = ellipticCurve.getA();
            BigInteger bigInteger6 = ellipticCurve.getB();
            BigInteger bigInteger7 = bigInteger3;
            BigInteger bigInteger8 = bigInteger.multiply(bigInteger).add(bigInteger5).multiply(bigInteger).add(bigInteger6).mod(bigInteger3);
            if (bigInteger7.signum() != 1) {
                throw new InvalidAlgorithmParameterException("p must be positive");
            }
            bigInteger8 = bigInteger8.mod(bigInteger7);
            BigInteger bigInteger9 = null;
            if (bigInteger8.equals(BigInteger.ZERO)) {
                bigInteger4 = BigInteger.ZERO;
            } else {
                BigInteger bigInteger10;
                if (bigInteger7.testBit(0) && bigInteger7.testBit(1)) {
                    bigInteger10 = bigInteger7.add(BigInteger.ONE).shiftRight(2);
                    bigInteger9 = bigInteger8.modPow(bigInteger10, bigInteger7);
                } else if (bigInteger7.testBit(0) && !bigInteger7.testBit(1)) {
                    BigInteger bigInteger11;
                    BigInteger bigInteger12;
                    block13: {
                        bigInteger10 = BigInteger.ONE;
                        BigInteger bigInteger13 = bigInteger7.subtract(BigInteger.ONE).shiftRight(1);
                        int n = 0;
                        do {
                            if ((bigInteger12 = bigInteger10.multiply(bigInteger10).subtract(bigInteger8).mod(bigInteger7)).equals(BigInteger.ZERO)) {
                                bigInteger4 = bigInteger10;
                                break block12;
                            }
                            bigInteger11 = bigInteger12.modPow(bigInteger13, bigInteger7);
                            if (bigInteger11.add(BigInteger.ONE).equals(bigInteger7)) break block13;
                            if (!bigInteger11.equals(BigInteger.ONE)) {
                                throw new InvalidAlgorithmParameterException("p is not prime");
                            }
                            bigInteger10 = bigInteger10.add(BigInteger.ONE);
                        } while (++n != 128 || bigInteger7.isProbablePrime(80));
                        throw new InvalidAlgorithmParameterException("p is not prime");
                    }
                    bigInteger11 = bigInteger7.add(BigInteger.ONE).shiftRight(1);
                    BigInteger bigInteger14 = bigInteger10;
                    BigInteger bigInteger15 = BigInteger.ONE;
                    for (int i = bigInteger11.bitLength() - 2; i >= 0; --i) {
                        BigInteger bigInteger16 = bigInteger14.multiply(bigInteger15);
                        bigInteger14 = bigInteger14.multiply(bigInteger14).add(bigInteger15.multiply(bigInteger15).mod(bigInteger7).multiply(bigInteger12)).mod(bigInteger7);
                        bigInteger15 = bigInteger16.add(bigInteger16).mod(bigInteger7);
                        if (!bigInteger11.testBit(i)) continue;
                        bigInteger16 = bigInteger14.multiply(bigInteger10).add(bigInteger15.multiply(bigInteger12)).mod(bigInteger7);
                        bigInteger15 = bigInteger10.multiply(bigInteger15).add(bigInteger14).mod(bigInteger7);
                        bigInteger14 = bigInteger16;
                    }
                    bigInteger9 = bigInteger14;
                }
                if (bigInteger9 != null && bigInteger9.multiply(bigInteger9).mod(bigInteger7).compareTo(bigInteger8) != 0) {
                    throw new GeneralSecurityException("Could not find a modular square root");
                }
                bigInteger4 = bigInteger2 = bigInteger9;
            }
        }
        if (bl != bigInteger2.testBit(0)) {
            bigInteger2 = bigInteger3.subtract(bigInteger2).mod(bigInteger3);
        }
        return bigInteger2;
    }

    public static KeyPair zza(ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = zzyf.zzd.zza("EC");
        keyPairGenerator.initialize(eCParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public static ECPrivateKey zza(zzya zzya2, byte[] byArray) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzyb.zza(zzya2);
        BigInteger bigInteger = zzmj.zza(byArray);
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(bigInteger, eCParameterSpec);
        return (ECPrivateKey)zzyf.zze.zza("EC").generatePrivate(eCPrivateKeySpec);
    }

    public static ECPublicKey zza(zzya zzya2, zzyd zzyd2, byte[] byArray) throws GeneralSecurityException {
        return zzyb.zza(zzyb.zza(zzya2), zzyd2, byArray);
    }

    public static ECPublicKey zza(ECParameterSpec eCParameterSpec, zzyd zzyd2, byte[] byArray) throws GeneralSecurityException {
        ECPoint eCPoint = zzyb.zza(eCParameterSpec.getCurve(), zzyd2, byArray);
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        return (ECPublicKey)zzyf.zze.zza("EC").generatePublic(eCPublicKeySpec);
    }

    public static ECParameterSpec zza(zzya zzya2) throws NoSuchAlgorithmException {
        switch (zzya2.ordinal()) {
            case 0: {
                return zzmk.zza;
            }
            case 1: {
                return zzmk.zzb;
            }
            case 2: {
                return zzmk.zzc;
            }
        }
        String string = String.valueOf((Object)zzya2);
        throw new NoSuchAlgorithmException("curve not implemented:" + string);
    }

    public static ECPoint zza(EllipticCurve ellipticCurve, zzyd zzyd2, byte[] byArray) throws GeneralSecurityException {
        int n = zzyb.zza(ellipticCurve);
        switch (zzyd2.ordinal()) {
            case 0: {
                if (byArray.length != 2 * n + 1) {
                    throw new GeneralSecurityException("invalid point size");
                }
                if (byArray[0] != 4) {
                    throw new GeneralSecurityException("invalid point format");
                }
                BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(byArray, 1, n + 1));
                BigInteger bigInteger2 = new BigInteger(1, Arrays.copyOfRange(byArray, n + 1, byArray.length));
                ECPoint eCPoint = new ECPoint(bigInteger, bigInteger2);
                zzmk.zza(eCPoint, ellipticCurve);
                return eCPoint;
            }
            case 2: {
                if (byArray.length != 2 * n) {
                    throw new GeneralSecurityException("invalid point size");
                }
                BigInteger bigInteger = new BigInteger(1, Arrays.copyOf(byArray, n));
                BigInteger bigInteger3 = new BigInteger(1, Arrays.copyOfRange(byArray, n, byArray.length));
                ECPoint eCPoint = new ECPoint(bigInteger, bigInteger3);
                zzmk.zza(eCPoint, ellipticCurve);
                return eCPoint;
            }
            case 1: {
                boolean bl;
                BigInteger bigInteger = zzmk.zza(ellipticCurve);
                if (byArray.length != n + 1) {
                    throw new GeneralSecurityException("compressed point has wrong length");
                }
                if (byArray[0] == 2) {
                    bl = false;
                } else if (byArray[0] == 3) {
                    bl = true;
                } else {
                    throw new GeneralSecurityException("invalid format");
                }
                BigInteger bigInteger4 = new BigInteger(1, Arrays.copyOfRange(byArray, 1, byArray.length));
                if (bigInteger4.signum() == -1 || bigInteger4.compareTo(bigInteger) >= 0) {
                    throw new GeneralSecurityException("x is out of range");
                }
                BigInteger bigInteger5 = zzyb.zza(bigInteger4, bl, ellipticCurve);
                return new ECPoint(bigInteger4, bigInteger5);
            }
        }
        String string = String.valueOf((Object)zzyd2);
        throw new GeneralSecurityException("invalid format:" + string);
    }

    public static void zza(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws GeneralSecurityException {
        zzyb.zzb(eCPublicKey, eCPrivateKey);
        zzmk.zza(eCPublicKey.getW(), eCPrivateKey.getParams().getCurve());
    }

    private static void zzb(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws GeneralSecurityException {
        try {
            ECParameterSpec eCParameterSpec = eCPublicKey.getParams();
            ECParameterSpec eCParameterSpec2 = eCPrivateKey.getParams();
            if (!zzmk.zza(eCParameterSpec, eCParameterSpec2)) {
                throw new GeneralSecurityException("invalid public key spec");
            }
            return;
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            throw new GeneralSecurityException(runtimeException);
        }
    }

    public static byte[] zza(ECPrivateKey eCPrivateKey, ECPublicKey eCPublicKey) throws GeneralSecurityException {
        zzyb.zzb(eCPublicKey, eCPrivateKey);
        return zzyb.zza(eCPrivateKey, eCPublicKey.getW());
    }

    private static byte[] zza(ECPrivateKey eCPrivateKey, ECPoint eCPoint) throws GeneralSecurityException {
        zzmk.zza(eCPoint, eCPrivateKey.getParams().getCurve());
        ECParameterSpec eCParameterSpec = eCPrivateKey.getParams();
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, eCParameterSpec);
        PublicKey publicKey = zzyf.zze.zza("EC").generatePublic(eCPublicKeySpec);
        KeyAgreement keyAgreement = zzyf.zzc.zza("ECDH");
        keyAgreement.init(eCPrivateKey);
        try {
            keyAgreement.doPhase(publicKey, true);
            byte[] byArray = keyAgreement.generateSecret();
            ECPrivateKey eCPrivateKey2 = eCPrivateKey;
            byte[] byArray2 = byArray;
            EllipticCurve ellipticCurve = eCPrivateKey2.getParams().getCurve();
            BigInteger bigInteger = new BigInteger(1, byArray2);
            if (bigInteger.signum() == -1 || bigInteger.compareTo(zzmk.zza(ellipticCurve)) >= 0) {
                throw new GeneralSecurityException("shared secret is out of range");
            }
            zzyb.zza(bigInteger, true, ellipticCurve);
            return byArray;
        }
        catch (IllegalStateException illegalStateException) {
            throw new GeneralSecurityException(illegalStateException);
        }
    }
}

