/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbl;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzio;
import com.google.android.gms.internal.firebase-auth-api.zzpr;
import com.google.android.gms.internal.firebase-auth-api.zzrg;
import com.google.android.gms.internal.firebase-auth-api.zzxs;
import com.google.android.gms.internal.firebase-auth-api.zzxv;
import com.google.android.gms.internal.firebase-auth-api.zzyv;
import com.google.android.gms.internal.firebase-auth-api.zzyy;
import com.google.android.gms.internal.firebase-auth-api.zzzc;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzxt
implements zzbl {
    private static final zzil.zza zza = zzil.zza.zza;
    private static final Collection<Integer> zzb = Arrays.asList(64);
    private static final byte[] zzc = new byte[16];
    private static final ThreadLocal<Cipher> zzd = new zzxs();
    private final zzyv zze;
    private final byte[] zzf;
    private final byte[] zzg;

    public static zzbl zza(zzio zzio2) throws GeneralSecurityException {
        return new zzxt(zzio2.zze().zza(zzbq.zza()), zzio2.zzd());
    }

    private zzxt(byte[] byArray, zzzc zzzc2) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use AES-SIV in FIPS-mode.");
        }
        if (!zzb.contains(byArray.length)) {
            int n = byArray.length;
            throw new InvalidKeyException("invalid key size: " + n + " bytes; key must have 64 bytes");
        }
        byte[] byArray2 = Arrays.copyOfRange(byArray, 0, byArray.length / 2);
        this.zzf = Arrays.copyOfRange(byArray, byArray.length / 2, byArray.length);
        this.zze = new zzyv(byArray2);
        this.zzg = zzzc2.zzb();
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray.length < 16 + this.zzg.length) {
            throw new GeneralSecurityException("Ciphertext too short.");
        }
        if (!zzpr.zza(this.zzg, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        Cipher cipher = zzd.get();
        byte[] byArray3 = Arrays.copyOfRange(byArray, this.zzg.length, 16 + this.zzg.length);
        byte[] byArray4 = (byte[])byArray3.clone();
        byte[] byArray5 = byArray4;
        byArray4[8] = (byte)(byArray4[8] & 0x7F);
        byArray5[12] = (byte)(byArray5[12] & 0x7F);
        cipher.init(2, (Key)new SecretKeySpec(this.zzf, "AES"), new IvParameterSpec(byArray5));
        int n = 16 + this.zzg.length;
        int n2 = byArray.length - n;
        byte[] byArray6 = cipher.doFinal(byArray, n, n2);
        if (n2 == 0 && byArray6 == null && zzyy.zza()) {
            byArray6 = new byte[]{};
        }
        byte[][] byArrayArray = new byte[][]{byArray2, byArray6};
        zzxt zzxt2 = this;
        byte[] byArray7 = zzxt2.zze.zza(zzc, 16);
        for (int i = 0; i <= 0; ++i) {
            byte[] byArray8 = byArrayArray[i] == null ? new byte[]{} : byArrayArray[i];
            byArray7 = zzxv.zza(zzrg.zzb(byArray7), zzxt2.zze.zza(byArray8, 16));
        }
        byte[] byArray9 = byArrayArray[1];
        if (byArray9.length >= 16) {
            byte[] byArray10 = byArray7;
            byte[] byArray11 = byArray9;
            if (byArray9.length < byArray10.length) {
                throw new IllegalArgumentException("xorEnd requires a.length >= b.length");
            }
            int n3 = byArray11.length - byArray10.length;
            byte[] byArray12 = Arrays.copyOf(byArray11, byArray11.length);
            for (int i = 0; i < byArray10.length; ++i) {
                int n4 = n3 + i;
                byArray12[n4] = (byte)(byArray12[n4] ^ byArray10[i]);
            }
            byArray7 = byArray12;
        } else {
            byArray7 = zzxv.zza(zzrg.zza(byArray9), zzrg.zzb(byArray7));
        }
        byte[] byArray13 = zzxt2.zze.zza(byArray7, 16);
        if (MessageDigest.isEqual(byArray3, byArray13)) {
            return byArray6;
        }
        throw new AEADBadTagException("Integrity check failed.");
    }
}

