/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzdo;
import com.google.android.gms.internal.firebase-auth-api.zzgo;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import com.google.android.gms.internal.firebase-auth-api.zzpr;
import com.google.android.gms.internal.firebase-auth-api.zzzc;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public final class zzxq
implements zzbg {
    private static final zzil.zza zza = zzil.zza.zzb;
    private final SecretKey zzb;
    private final byte[] zzc;

    public static zzbg zza(zzdo zzdo2) throws GeneralSecurityException {
        if (zzdo2.zzc().zzb() != 12) {
            int n = zzdo2.zzc().zzb();
            throw new GeneralSecurityException("Expected IV Size 12, got " + n);
        }
        if (zzdo2.zzc().zzd() != 16) {
            int n = zzdo2.zzc().zzd();
            throw new GeneralSecurityException("Expected tag Size 16, got " + n);
        }
        return new zzxq(zzdo2.zze().zza(zzbq.zza()), zzdo2.zzd());
    }

    private zzxq(byte[] byArray, zzzc zzzc2) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use AES-GCM in FIPS-mode, as BoringCrypto module is not available.");
        }
        this.zzb = zzgo.zzb(byArray);
        this.zzc = zzzc2.zzb();
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        if (byArray.length < this.zzc.length + 12 + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzpr.zza(this.zzc, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        AlgorithmParameterSpec algorithmParameterSpec = zzgo.zza(byArray, this.zzc.length, 12);
        Cipher cipher = zzgo.zza();
        cipher.init(2, (Key)this.zzb, algorithmParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        int n = this.zzc.length + 12;
        int n2 = byArray.length - this.zzc.length - 12;
        return cipher.doFinal(byArray, n, n2);
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        if (byArray == null) {
            throw new NullPointerException("plaintext is null");
        }
        byte[] byArray3 = zzpe.zza(12);
        AlgorithmParameterSpec algorithmParameterSpec = zzgo.zza(byArray3);
        Cipher cipher = zzgo.zza();
        cipher.init(1, (Key)this.zzb, algorithmParameterSpec);
        if (byArray2 != null && byArray2.length != 0) {
            cipher.updateAAD(byArray2);
        }
        if ((n = cipher.getOutputSize(byArray.length)) > Integer.MAX_VALUE - this.zzc.length - 12) {
            throw new GeneralSecurityException("plaintext too long");
        }
        int n2 = this.zzc.length + 12 + n;
        byte[] byArray4 = Arrays.copyOf(this.zzc, n2);
        System.arraycopy(byArray3, 0, byArray4, this.zzc.length, 12);
        if (cipher.doFinal(byArray, 0, byArray.length, byArray4, this.zzc.length + 12) != n) {
            throw new GeneralSecurityException("not enough data written");
        }
        return byArray4;
    }
}

