/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.firebase-auth-api.zzbf;
import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbh;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzbt;
import com.google.android.gms.internal.firebase-auth-api.zzbu;
import com.google.android.gms.internal.firebase-auth-api.zzcc;
import com.google.android.gms.internal.firebase-auth-api.zzce;
import com.google.android.gms.internal.firebase-auth-api.zzcf;
import com.google.android.gms.internal.firebase-auth-api.zzcp;
import com.google.android.gms.internal.firebase-auth-api.zzmc;
import com.google.android.gms.internal.firebase-auth-api.zzmf;
import com.google.android.gms.internal.firebase-auth-api.zzmh;
import com.google.android.gms.internal.firebase-auth-api.zzvu;
import com.google.android.gms.internal.firebase-auth-api.zzyt;
import java.io.CharConversionException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.ProviderException;
import javax.annotation.concurrent.GuardedBy;

public final class zzma {
    private static final Object zza = new Object();
    private static final String zzb = zzma.class.getSimpleName();
    @GuardedBy(value="this")
    private zzcc zzc;

    public final synchronized zzbt zza() throws GeneralSecurityException {
        return this.zzc.zza();
    }

    static /* synthetic */ void zza(zzbt zzbt2, zzce zzce2, zzbg zzbg2) {
        zzbg zzbg3 = zzbg2;
        zzce zzce3 = zzce2;
        zzbt zzbt3 = zzbt2;
        try {
            if (zzbg3 != null) {
                byte[] byArray = new byte[]{};
                zzbg zzbg4 = zzbg3;
                zzbt3.zza(zzce3, zzbg4, byArray);
                return;
            }
            zzcf.zza(zzbt3, zzce3, zzbq.zza());
            return;
        }
        catch (IOException iOException) {
            throw new GeneralSecurityException(iOException);
        }
    }

    private zzma(zza zza2) {
        new zzmh(zza2.zza, zza2.zzb, zza2.zzc);
        this.zzc = zza2.zzi;
    }

    /* synthetic */ zzma(zza zza2, zzmc zzmc2) {
        this(zza2);
    }

    static /* synthetic */ boolean zzd() {
        return true;
    }

    public static final class zza {
        private Context zza = null;
        private String zzb = null;
        private String zzc = null;
        private String zzd = null;
        private zzbg zze = null;
        private boolean zzf = true;
        private zzbu zzg = null;
        private zzvu zzh = null;
        @GuardedBy(value="this")
        private zzcc zzi;

        @Nullable
        private final zzbg zzb() throws GeneralSecurityException {
            boolean bl;
            zzma.zzd();
            zzmf zzmf2 = new zzmf();
            try {
                bl = zzmf.zzc(this.zzd);
            }
            catch (GeneralSecurityException | ProviderException exception) {
                Log.w((String)zzb, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
                return null;
            }
            try {
                return zzmf2.zza(this.zzd);
            }
            catch (GeneralSecurityException | ProviderException exception) {
                if (!bl) {
                    throw new KeyStoreException(String.format("the master key %s exists but is unusable", this.zzd), exception);
                }
                Log.w((String)zzb, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
                return null;
            }
        }

        private static zzcc zza(byte[] byArray) throws GeneralSecurityException, IOException {
            return zzcc.zza(zzbh.zza(zzbf.zza(byArray)));
        }

        private final zzcc zzb(byte[] byArray) throws GeneralSecurityException, IOException {
            try {
                this.zze = new zzmf().zza(this.zzd);
            }
            catch (GeneralSecurityException | ProviderException exception) {
                try {
                    zzcc zzcc2 = com.google.android.gms.internal.firebase-auth-api.zzma$zza.zza(byArray);
                    Log.w((String)zzb, (String)"cannot use Android Keystore, it'll be disabled", (Throwable)exception);
                    return zzcc2;
                }
                catch (IOException iOException) {
                    throw exception;
                }
            }
            try {
                byte[] byArray2;
                byte[] byArray3 = byArray2 = new byte[0];
                return zzcc.zza(zzbt.zza(zzbf.zza(byArray), this.zze, byArray2));
            }
            catch (IOException | GeneralSecurityException exception) {
                try {
                    return com.google.android.gms.internal.firebase-auth-api.zzma$zza.zza(byArray);
                }
                catch (IOException iOException) {
                    throw exception;
                }
            }
        }

        public final zza zza(zzvu zzvu2) {
            this.zzh = zzvu2;
            return this;
        }

        public final zza zza(String string) {
            if (!string.startsWith("android-keystore://")) {
                throw new IllegalArgumentException("key URI must start with android-keystore://");
            }
            if (!this.zzf) {
                throw new IllegalArgumentException("cannot call withMasterKeyUri() after calling doNotUseKeystore()");
            }
            this.zzd = string;
            return this;
        }

        public final zza zza(Context context, String string, String string2) throws IOException {
            if (context == null) {
                throw new IllegalArgumentException("need an Android context");
            }
            this.zza = context;
            this.zzb = string;
            this.zzc = string2;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized zzma zza() throws GeneralSecurityException, IOException {
            if (this.zzb == null) {
                throw new IllegalArgumentException("keysetName cannot be null");
            }
            if (this.zzh != null && this.zzg == null) {
                this.zzg = zzbu.zza(zzcp.zza(this.zzh.zzk()));
            }
            Object object = zza;
            synchronized (object) {
                byte[] byArray = com.google.android.gms.internal.firebase-auth-api.zzma$zza.zzb(this.zza, this.zzb, this.zzc);
                if (byArray == null) {
                    if (this.zzd != null) {
                        this.zze = this.zzb();
                    }
                    zza zza2 = this;
                    if (zza2.zzg == null) {
                        throw new GeneralSecurityException("cannot read or generate keyset");
                    }
                    zzbt zzbt2 = zzbt.zza(zza2.zzg);
                    zzmh zzmh2 = new zzmh(zza2.zza, zza2.zzb, zza2.zzc);
                    zzma.zza(zzbt2, zzmh2, zza2.zze);
                    this.zzi = zzcc.zza(zzbt2);
                } else if (this.zzd == null) {
                    this.zzi = com.google.android.gms.internal.firebase-auth-api.zzma$zza.zza(byArray);
                } else {
                    zzma.zzd();
                    this.zzi = this.zzb(byArray);
                }
                return new zzma(this, null);
            }
        }

        @Nullable
        private static byte[] zzb(Context context, String string, String string2) throws IOException {
            if (string == null) {
                throw new IllegalArgumentException("keysetName cannot be null");
            }
            Context context2 = context.getApplicationContext();
            SharedPreferences sharedPreferences = string2 == null ? PreferenceManager.getDefaultSharedPreferences((Context)context2) : context2.getSharedPreferences(string2, 0);
            try {
                String string3 = sharedPreferences.getString(string, null);
                if (string3 == null) {
                    return null;
                }
                return zzyt.zza(string3);
            }
            catch (ClassCastException | IllegalArgumentException runtimeException) {
                throw new CharConversionException(String.format("can't read keyset; the pref value %s is not a valid hex string", string));
            }
        }
    }
}

