/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzfp;
import com.google.android.gms.internal.firebase-auth-api.zzhj;
import com.google.android.gms.internal.firebase-auth-api.zzpe;
import com.google.android.gms.internal.firebase-auth-api.zzpr;
import com.google.android.gms.internal.firebase-auth-api.zzrq;
import com.google.android.gms.internal.firebase-auth-api.zzyv;
import com.google.android.gms.internal.firebase-auth-api.zzzc;
import java.security.GeneralSecurityException;
import java.util.Arrays;

public final class zzhw
implements zzbg {
    private final byte[] zza;
    private final int zzb;
    private final zzrq zzc;

    public static zzbg zza(zzfp zzfp2) throws GeneralSecurityException {
        if (zzfp2.zzb().zzb() < 8 || zzfp2.zzb().zzb() > 12) {
            throw new GeneralSecurityException("invalid salt size");
        }
        return new zzhw(zzfp2.zzd().zza(zzbq.zza()), zzfp2.zzc(), zzfp2.zzb().zzb());
    }

    private zzhw(byte[] byArray, zzzc zzzc2, int n) throws GeneralSecurityException {
        this.zzc = new zzyv(byArray);
        this.zza = zzzc2.zzb();
        this.zzb = n;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("ciphertext is null");
        }
        if (byArray.length < this.zza.length + this.zzb + 12 + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        if (!zzpr.zza(this.zza, byArray)) {
            throw new GeneralSecurityException("Decryption failed (OutputPrefix mismatch).");
        }
        int n = this.zza.length + this.zzb;
        return new zzhj(this.zza(Arrays.copyOfRange(byArray, this.zza.length, n))).zza(Arrays.copyOfRange(byArray, n, n + 12), byArray, n + 12, byArray2);
    }

    private final byte[] zza(byte[] byArray) throws GeneralSecurityException {
        byte[] byArray2 = new byte[]{0, 1, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray3 = new byte[]{0, 2, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        if (byArray.length > 12 || byArray.length < 8) {
            throw new GeneralSecurityException("invalid salt size");
        }
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        byte[] byArray4 = new byte[32];
        System.arraycopy(this.zzc.zza(byArray2, 16), 0, byArray4, 0, 16);
        System.arraycopy(this.zzc.zza(byArray3, 16), 0, byArray4, 16, 16);
        return byArray4;
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray == null) {
            throw new NullPointerException("plaintext is null");
        }
        byte[] byArray3 = zzpe.zza(this.zzb + 12);
        byte[] byArray4 = Arrays.copyOf(byArray3, this.zzb);
        byte[] byArray5 = Arrays.copyOfRange(byArray3, this.zzb, this.zzb + 12);
        byte[] byArray6 = new zzhj(this.zza(byArray4)).zzb(byArray5, byArray, this.zza.length + this.zzb + byArray5.length, byArray2);
        System.arraycopy(this.zza, 0, byArray6, 0, this.zza.length);
        System.arraycopy(byArray3, 0, byArray6, this.zza.length, byArray3.length);
        return byArray6;
    }
}

