/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzhc;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzhq {
    private static final zzil.zza zza = zzil.zza.zza;
    private final SecretKey zzb;

    public static zzhq zza(byte[] byArray) throws GeneralSecurityException {
        return new zzhq(byArray);
    }

    private zzhq(byte[] byArray) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        if (!zzhq.zza()) {
            throw new GeneralSecurityException("JCE does not support algorithm: ChaCha20-Poly1305");
        }
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zzb = new SecretKeySpec(byArray, "ChaCha20");
    }

    public static boolean zza() {
        return zzhc.zza() != null;
    }

    public final byte[] zza(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws GeneralSecurityException {
        if (byArray2 == null) {
            throw new NullPointerException("ciphertext is null");
        }
        if (byArray.length != 12) {
            throw new GeneralSecurityException("nonce length must be 12 bytes.");
        }
        if (byArray2.length < n + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        Cipher cipher = zzhc.zza();
        cipher.init(2, (Key)this.zzb, ivParameterSpec);
        if (byArray3 != null && byArray3.length != 0) {
            cipher.updateAAD(byArray3);
        }
        return cipher.doFinal(byArray2, n, byArray2.length - n);
    }
}

