/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzhl;
import com.google.android.gms.internal.firebase-auth-api.zzht;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.AEADBadTagException;

abstract class zzhn {
    private static final zzil.zza zza = zzil.zza.zza;
    private final zzhl zzb;
    private final zzhl zzc;

    abstract zzhl zza(byte[] var1, int var2) throws InvalidKeyException;

    public zzhn(byte[] byArray) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        this.zzb = this.zza(byArray, 1);
        this.zzc = this.zza(byArray, 0);
    }

    public void zza(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        if (byteBuffer.remaining() < byArray2.length + 16) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        int n = byteBuffer.position();
        this.zzb.zza(byteBuffer, byArray, byArray2);
        byteBuffer.position(n);
        byteBuffer.limit(byteBuffer.limit() - 16);
        byte[] byArray4 = byArray3;
        if (byArray3 == null) {
            byArray4 = new byte[]{};
        }
        byte[] byArray5 = zzht.zza(this.zza(byArray), zzhn.zza(byArray4, byteBuffer));
        byteBuffer.limit(byteBuffer.limit() + 16);
        byteBuffer.put(byArray5);
    }

    public byte[] zza(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byteBuffer.remaining() < 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        int n = byteBuffer.position();
        byte[] byArray3 = new byte[16];
        byteBuffer.position(byteBuffer.limit() - 16);
        byteBuffer.get(byArray3);
        byteBuffer.position(n);
        byteBuffer.limit(byteBuffer.limit() - 16);
        byte[] byArray4 = byArray2;
        if (byArray2 == null) {
            byArray4 = new byte[]{};
        }
        try {
            byte[] byArray5 = byArray3;
            if (!MessageDigest.isEqual(zzht.zza(this.zza(byArray), zzhn.zza(byArray4, byteBuffer)), byArray5)) {
                throw new GeneralSecurityException("invalid MAC");
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new AEADBadTagException(generalSecurityException.toString());
        }
        byteBuffer.position(n);
        return this.zzb.zza(byArray, byteBuffer);
    }

    public byte[] zza(byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        return this.zza(ByteBuffer.wrap(byArray2), byArray, byArray3);
    }

    private final byte[] zza(byte[] byArray) throws GeneralSecurityException {
        ByteBuffer byteBuffer = this.zzc.zza(byArray, 0);
        byte[] byArray2 = new byte[32];
        byteBuffer.get(byArray2);
        return byArray2;
    }

    private static byte[] zza(byte[] byArray, ByteBuffer byteBuffer) {
        int n = byArray.length % 16 == 0 ? byArray.length : byArray.length + 16 - byArray.length % 16;
        int n2 = byteBuffer.remaining();
        int n3 = n2 % 16 == 0 ? n2 : n2 + 16 - n2 % 16;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n + n3 + 16).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.put(byArray);
        byteBuffer2.position(n);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.position(n + n3);
        byteBuffer2.putLong(byArray.length);
        byteBuffer2.putLong(n2);
        return byteBuffer2.array();
    }
}

