/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzgo;
import com.google.android.gms.internal.firebase-auth-api.zzil;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public final class zzhj {
    private static final zzil.zza zza = zzil.zza.zzb;
    private final SecretKey zzb;

    public zzhj(byte[] byArray) throws GeneralSecurityException {
        if (!zza.zza()) {
            throw new GeneralSecurityException("Can not use AES-GCM in FIPS-mode, as BoringCrypto module is not available.");
        }
        this.zzb = zzgo.zzb(byArray);
    }

    public final byte[] zza(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws GeneralSecurityException {
        if (byArray.length != 12) {
            throw new GeneralSecurityException("iv is wrong size");
        }
        if (byArray2.length < n + 16) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        AlgorithmParameterSpec algorithmParameterSpec = zzgo.zza(byArray);
        Cipher cipher = zzgo.zza();
        cipher.init(2, (Key)this.zzb, algorithmParameterSpec);
        if (byArray3 != null && byArray3.length != 0) {
            cipher.updateAAD(byArray3);
        }
        return cipher.doFinal(byArray2, n, byArray2.length - n);
    }

    public final byte[] zzb(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws GeneralSecurityException {
        int n2;
        if (byArray.length != 12) {
            throw new GeneralSecurityException("iv is wrong size");
        }
        AlgorithmParameterSpec algorithmParameterSpec = zzgo.zza(byArray);
        Cipher cipher = zzgo.zza();
        cipher.init(1, (Key)this.zzb, algorithmParameterSpec);
        if (byArray3 != null && byArray3.length != 0) {
            cipher.updateAAD(byArray3);
        }
        if ((n2 = cipher.getOutputSize(byArray2.length)) > Integer.MAX_VALUE - n) {
            throw new GeneralSecurityException("plaintext too long");
        }
        byte[] byArray4 = new byte[n + n2];
        if (cipher.doFinal(byArray2, 0, byArray2.length, byArray4, n) != n2) {
            throw new GeneralSecurityException("not enough data written");
        }
        return byArray4;
    }
}

