/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzaip;
import com.google.android.gms.internal.firebase-auth-api.zzajk;
import com.google.android.gms.internal.firebase-auth-api.zzajy;
import com.google.android.gms.internal.firebase-auth-api.zzakf;
import com.google.android.gms.internal.firebase-auth-api.zzbg;
import com.google.android.gms.internal.firebase-auth-api.zzbp;
import com.google.android.gms.internal.firebase-auth-api.zzbq;
import com.google.android.gms.internal.firebase-auth-api.zzch;
import com.google.android.gms.internal.firebase-auth-api.zzcp;
import com.google.android.gms.internal.firebase-auth-api.zzcw;
import com.google.android.gms.internal.firebase-auth-api.zznv;
import com.google.android.gms.internal.firebase-auth-api.zzoc;
import com.google.android.gms.internal.firebase-auth-api.zzof;
import com.google.android.gms.internal.firebase-auth-api.zzpc;
import com.google.android.gms.internal.firebase-auth-api.zzvq;
import com.google.android.gms.internal.firebase-auth-api.zzvu;
import com.google.android.gms.internal.firebase-auth-api.zzws;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class zzeo
implements zzbg {
    private static final byte[] zza = new byte[0];
    private static final Set<String> zzb;
    private final String zzc;
    private final zzch zzd;
    private final zzbg zze;

    public static zzbg zza(zzcw zzcw2, zzbg zzbg2) throws GeneralSecurityException {
        zzvu zzvu2;
        try {
            zzvu2 = zzvu.zza(zzcp.zza(zzcw2), zzajk.zza());
        }
        catch (zzakf zzakf2) {
            throw new GeneralSecurityException(zzakf2);
        }
        return new zzeo(zzvu2, zzbg2);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("type.googleapis.com/google.crypto.tink.AesGcmKey");
        hashSet.add("type.googleapis.com/google.crypto.tink.ChaCha20Poly1305Key");
        hashSet.add("type.googleapis.com/google.crypto.tink.XChaCha20Poly1305Key");
        hashSet.add("type.googleapis.com/google.crypto.tink.AesCtrHmacAeadKey");
        hashSet.add("type.googleapis.com/google.crypto.tink.AesGcmSivKey");
        hashSet.add("type.googleapis.com/google.crypto.tink.AesEaxKey");
        zzb = Collections.unmodifiableSet(hashSet);
    }

    @Deprecated
    private zzeo(zzvu zzvu2, zzbg zzbg2) throws GeneralSecurityException {
        String string = zzvu2.zzf();
        if (!zzb.contains(string)) {
            String string2 = zzvu2.zzf();
            throw new IllegalArgumentException("Unsupported DEK key type: " + string2 + ". Only Tink AEAD key types are supported.");
        }
        this.zzc = zzvu2.zzf();
        this.zzd = zzcp.zza(((zzvu)((zzajy)zzvu.zza(zzvu2).zza(zzws.zzd).zze())).zzk());
        this.zze = zzbg2;
    }

    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            int n = byteBuffer.getInt();
            if (n <= 0 || n > 4096 || n > byArray.length - 4) {
                throw new GeneralSecurityException("length of encrypted DEK too large");
            }
            byte[] byArray3 = new byte[n];
            byteBuffer.get(byArray3, 0, n);
            byte[] byArray4 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray4, 0, byteBuffer.remaining());
            byte[] byArray5 = this.zze.zza(byArray3, zza);
            zzpc zzpc2 = zzpc.zza(this.zzc, zzaip.zza(byArray5), zzvq.zzb.zzb, zzws.zzd, null);
            zzbp zzbp2 = zzof.zza().zza(zzpc2, zzbq.zza());
            return zzoc.zza().zza(zzbp2, zzbg.class).zza(byArray4, byArray2);
        }
        catch (IndexOutOfBoundsException | NegativeArraySizeException | BufferUnderflowException runtimeException) {
            throw new GeneralSecurityException("invalid ciphertext", runtimeException);
        }
    }

    @Override
    public final byte[] zzb(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        byte[] byArray3;
        zzbp zzbp2 = zznv.zza().zza(this.zzd, null);
        byte[] byArray4 = zzof.zza().zza(zzbp2, zzpc.class, zzbq.zza()).zzd().zzd();
        byte[] byArray5 = this.zze.zzb(byArray4, zza);
        if (byArray5.length > 4096) {
            throw new GeneralSecurityException("length of encrypted DEK too large");
        }
        byte[] byArray6 = byArray3 = zzoc.zza().zza(zzbp2, zzbg.class).zzb(byArray, byArray2);
        byte[] byArray7 = byArray5;
        return ByteBuffer.allocate(4 + byArray7.length + byArray6.length).putInt(byArray7.length).put(byArray7).put(byArray6).array();
    }
}

