/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.internal.firebase-auth-api.zzcw;
import com.google.android.gms.internal.firebase-auth-api.zzdi;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Objects;
import javax.annotation.Nullable;

public final class zzdg
extends zzcw {
    private final int zza;
    private final int zzb;
    private final int zzc;
    private final int zzd;
    private final zzb zze;
    private final zzc zzf;

    public final int zzb() {
        return this.zza;
    }

    public final int zzc() {
        return this.zzb;
    }

    public final int zzd() {
        return this.zzc;
    }

    public final int zze() {
        return this.zzd;
    }

    public final int hashCode() {
        return Objects.hash(zzdg.class, this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf);
    }

    public static zza zzf() {
        return new zza(null);
    }

    public final zzc zzg() {
        return this.zzf;
    }

    public final zzb zzh() {
        return this.zze;
    }

    public final String toString() {
        int n = this.zzb;
        int n2 = this.zza;
        int n3 = this.zzd;
        int n4 = this.zzc;
        String string = String.valueOf(this.zzf);
        String string2 = String.valueOf(this.zze);
        return "AesCtrHmacAead Parameters (variant: " + string2 + ", hashType: " + string + ", " + n4 + "-byte IV, and " + n3 + "-byte tags, and " + n2 + "-byte AES key, and " + n + "-byte HMAC key)";
    }

    private zzdg(int n, int n2, int n3, int n4, zzb zzb2, zzc zzc2) {
        this.zza = n;
        this.zzb = n2;
        this.zzc = n3;
        this.zzd = n4;
        this.zze = zzb2;
        this.zzf = zzc2;
    }

    /* synthetic */ zzdg(int n, int n2, int n3, int n4, zzb zzb2, zzc zzc2, zzdi zzdi2) {
        this(n, n2, n3, n4, zzb2, zzc2);
    }

    public final boolean equals(Object object) {
        if (!(object instanceof zzdg)) {
            return false;
        }
        zzdg zzdg2 = (zzdg)object;
        return zzdg2.zza == this.zza && zzdg2.zzb == this.zzb && zzdg2.zzc == this.zzc && zzdg2.zzd == this.zzd && zzdg2.zze == this.zze && zzdg2.zzf == this.zzf;
    }

    @Override
    public final boolean zza() {
        return this.zze != com.google.android.gms.internal.firebase-auth-api.zzdg$zzb.zzc;
    }

    public static final class zzb {
        public static final zzb zza = new zzb("TINK");
        public static final zzb zzb = new zzb("CRUNCHY");
        public static final zzb zzc = new zzb("NO_PREFIX");
        private final String zzd;

        public final String toString() {
            return this.zzd;
        }

        private zzb(String string) {
            this.zzd = string;
        }
    }

    public static final class zzc {
        public static final zzc zza = new zzc("SHA1");
        public static final zzc zzb = new zzc("SHA224");
        public static final zzc zzc = new zzc("SHA256");
        public static final zzc zzd = new zzc("SHA384");
        public static final zzc zze = new zzc("SHA512");
        private final String zzf;

        public final String toString() {
            return this.zzf;
        }

        private zzc(String string) {
            this.zzf = string;
        }
    }

    public static final class zza {
        @Nullable
        private Integer zza = null;
        @Nullable
        private Integer zzb = null;
        @Nullable
        private Integer zzc = null;
        @Nullable
        private Integer zzd = null;
        private zzc zze = null;
        private zzb zzf = com.google.android.gms.internal.firebase-auth-api.zzdg$zzb.zzc;

        public final zza zza(int n) throws GeneralSecurityException {
            if (n != 16 && n != 24 && n != 32) {
                throw new InvalidAlgorithmParameterException(String.format("Invalid key size %d; only 16-byte, 24-byte and 32-byte AES keys are supported", n));
            }
            this.zza = n;
            return this;
        }

        public final zza zza(zzc zzc2) {
            this.zze = zzc2;
            return this;
        }

        public final zza zzb(int n) throws GeneralSecurityException {
            if (n < 16) {
                throw new InvalidAlgorithmParameterException(String.format("Invalid key size in bytes %d; HMAC key must be at least 16 bytes", n));
            }
            this.zzb = n;
            return this;
        }

        public final zza zzc(int n) throws GeneralSecurityException {
            if (n < 12 || n > 16) {
                throw new GeneralSecurityException(String.format("Invalid IV size in bytes %d; IV size must be between 12 and 16 bytes", n));
            }
            this.zzc = n;
            return this;
        }

        public final zza zzd(int n) throws GeneralSecurityException {
            if (n < 10) {
                throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; must be at least 10 bytes", n));
            }
            this.zzd = n;
            return this;
        }

        public final zza zza(zzb zzb2) {
            this.zzf = zzb2;
            return this;
        }

        public final zzdg zza() throws GeneralSecurityException {
            if (this.zza == null) {
                throw new GeneralSecurityException("AES key size is not set");
            }
            if (this.zzb == null) {
                throw new GeneralSecurityException("HMAC key size is not set");
            }
            if (this.zzc == null) {
                throw new GeneralSecurityException("iv size is not set");
            }
            if (this.zzd == null) {
                throw new GeneralSecurityException("tag size is not set");
            }
            if (this.zze == null) {
                throw new GeneralSecurityException("hash type is not set");
            }
            if (this.zzf == null) {
                throw new GeneralSecurityException("variant is not set");
            }
            zzc zzc2 = this.zze;
            int n = this.zzd;
            if (zzc2 == com.google.android.gms.internal.firebase-auth-api.zzdg$zzc.zza) {
                if (n > 20) {
                    throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 20 bytes for SHA1", n));
                }
            } else if (zzc2 == com.google.android.gms.internal.firebase-auth-api.zzdg$zzc.zzb) {
                if (n > 28) {
                    throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 28 bytes for SHA224", n));
                }
            } else if (zzc2 == com.google.android.gms.internal.firebase-auth-api.zzdg$zzc.zzc) {
                if (n > 32) {
                    throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 32 bytes for SHA256", n));
                }
            } else if (zzc2 == com.google.android.gms.internal.firebase-auth-api.zzdg$zzc.zzd) {
                if (n > 48) {
                    throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 48 bytes for SHA384", n));
                }
            } else if (zzc2 == com.google.android.gms.internal.firebase-auth-api.zzdg$zzc.zze) {
                if (n > 64) {
                    throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 64 bytes for SHA512", n));
                }
            } else {
                throw new GeneralSecurityException("unknown hash type; must be SHA1, SHA224, SHA256, SHA384 or SHA512");
            }
            return new zzdg(this.zza, this.zzb, this.zzc, this.zzd, this.zzf, this.zze, null);
        }

        private zza() {
        }

        /* synthetic */ zza(zzdi zzdi2) {
            this();
        }
    }
}

