/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.internal.firebase-auth-api.zzabg;
import com.google.android.gms.internal.firebase-auth-api.zzadt;
import com.google.android.gms.internal.firebase-auth-api.zzago;
import com.google.android.gms.internal.firebase-auth-api.zzaid;
import com.google.android.gms.internal.firebase-auth-api.zzzh;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="GetTokenResponseCreator")
public class zzagl
extends AbstractSafeParcelable
implements zzadt<zzagl> {
    private static final String zza = zzagl.class.getSimpleName();
    public static final Parcelable.Creator<zzagl> CREATOR = new zzago();
    @SafeParcelable.Field(id=2, getter="getRefreshToken")
    private String zzb;
    @SafeParcelable.Field(id=3, getter="getAccessToken")
    private String zzc;
    @SafeParcelable.Field(id=4, getter="getExpiresIn")
    private Long zzd;
    @SafeParcelable.Field(id=5, getter="getTokenType")
    private String zze;
    @SafeParcelable.Field(id=6, getter="getIssuedAt")
    private Long zzf;

    public final long zza() {
        if (this.zzd == null) {
            return 0L;
        }
        return this.zzd;
    }

    public final long zzb() {
        return this.zzf;
    }

    @Override
    public final /* synthetic */ zzadt zza(String string) throws zzabg {
        return this.zzd(string);
    }

    public static zzagl zzb(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            zzagl zzagl2 = new zzagl();
            new zzagl().zzb = jSONObject.optString("refresh_token", null);
            zzagl2.zzc = jSONObject.optString("access_token", null);
            zzagl2.zzd = jSONObject.optLong("expires_in");
            zzagl2.zze = jSONObject.optString("token_type", null);
            zzagl2.zzf = jSONObject.optLong("issued_at");
            return zzagl2;
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to read GetTokenResponse from JSONObject");
            throw new zzzh(jSONException);
        }
    }

    private final zzagl zzd(String string) throws zzabg {
        try {
            JSONObject jSONObject = new JSONObject(string);
            this.zzb = Strings.emptyToNull((String)jSONObject.optString("refresh_token"));
            this.zzc = Strings.emptyToNull((String)jSONObject.optString("access_token"));
            this.zzd = jSONObject.optLong("expires_in", 0L);
            this.zze = Strings.emptyToNull((String)jSONObject.optString("token_type"));
            this.zzf = System.currentTimeMillis();
            return this;
        }
        catch (NullPointerException | JSONException throwable) {
            throw zzaid.zza((Exception)throwable, zza, string);
        }
    }

    public final String zzc() {
        return this.zzc;
    }

    public final String zzd() {
        return this.zzb;
    }

    @Nullable
    public final String zze() {
        return this.zze;
    }

    public final String zzf() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("refresh_token", (Object)this.zzb);
            jSONObject.put("access_token", (Object)this.zzc);
            jSONObject.put("expires_in", (Object)this.zzd);
            jSONObject.put("token_type", (Object)this.zze);
            jSONObject.put("issued_at", (Object)this.zzf);
            return jSONObject.toString();
        }
        catch (JSONException jSONException) {
            Log.d((String)zza, (String)"Failed to convert GetTokenResponse to JSON");
            throw new zzzh(jSONException);
        }
    }

    public zzagl() {
        this.zzf = System.currentTimeMillis();
    }

    public zzagl(String string, String string2, Long l, String string3) {
        this(string, string2, l, string3, System.currentTimeMillis());
    }

    @SafeParcelable.Constructor
    zzagl(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) Long l, @SafeParcelable.Param(id=5) String string3, @SafeParcelable.Param(id=6) Long l2) {
        this.zzb = string;
        this.zzc = string2;
        this.zzd = l;
        this.zze = string3;
        this.zzf = l2;
    }

    public final void zzc(String string) {
        this.zzb = Preconditions.checkNotEmpty((String)string);
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzagl zzagl2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzagl2.zzb, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzagl2.zzc, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)4, (Long)zzagl2.zza(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)zzagl2.zze, (boolean)false);
        SafeParcelWriter.writeLongObject((Parcel)parcel2, (int)6, (Long)zzagl2.zzf, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean zzg() {
        long l = this.zzf + this.zzd * 1000L;
        return DefaultClock.getInstance().currentTimeMillis() + 300000L < l;
    }
}

