/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import android.content.Context;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.util.Base64;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.auth.api.phone.SmsRetriever;
import com.google.android.gms.common.logging.Logger;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.firebase-auth-api.zzade;
import com.google.android.gms.internal.firebase-auth-api.zzaev;
import com.google.android.gms.internal.firebase-auth-api.zzaex;
import com.google.android.gms.internal.firebase-auth-api.zzaey;
import com.google.android.gms.internal.firebase-auth-api.zzaez;
import com.google.android.gms.internal.firebase-auth-api.zzafa;
import com.google.android.gms.internal.firebase-auth-api.zzag;
import com.google.android.gms.internal.firebase-auth-api.zzc;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.firebase.auth.PhoneAuthCredential;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class zzaew {
    private static final Logger zza = new Logger("FirebaseAuth", new String[]{"SmsRetrieverHelper"});
    private final Context zzb;
    private final ScheduledExecutorService zzc;
    private final HashMap<String, zzaez> zzd = new HashMap();

    static /* bridge */ /* synthetic */ Logger zza() {
        return zza;
    }

    final zzade zza(zzade zzade2, String string) {
        return new zzaex(this, zzade2, string);
    }

    @VisibleForTesting
    static String zza(String string) {
        Matcher matcher = Pattern.compile("(?<!\\d)\\d{6}(?!\\d)").matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    final String zzb() {
        try {
            String string = this.zzb.getPackageName();
            Signature[] signatureArray = Build.VERSION.SDK_INT < 28 ? Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string, (int)64).signatures : Wrappers.packageManager((Context)this.zzb).getPackageInfo((String)string, (int)0x8000000).signingInfo.getApkContentsSigners();
            String string2 = zzaew.zza(string, signatureArray[0].toCharsString());
            if (string2 != null) {
                return string2;
            }
            zza.e("Hash generation failed.", new Object[0]);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zza.e("Unable to find package to obtain hash.", new Object[0]);
        }
        return null;
    }

    private static String zza(String string, String string2) {
        String string3 = string2;
        String string4 = string;
        String string5 = string4 + " " + string3;
        try {
            String string6;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(string5.getBytes(StandardCharsets.UTF_8));
            string3 = string6 = Base64.encodeToString((byte[])Arrays.copyOf(messageDigest.digest(), 9), (int)3).substring(0, 11);
            string4 = string;
            zza.d("Package: " + string4 + " -- Hash: " + string3, new Object[0]);
            return string6;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            string4 = noSuchAlgorithmException.getMessage();
            zza.e("NoSuchAlgorithm: " + string4, new Object[0]);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ HashMap zza(zzaew zzaew2) {
        return zzaew2.zzd;
    }

    static /* synthetic */ void zza(zzaew zzaew2, String string) {
        String string2 = string;
        zzaez zzaez2 = zzaew2.zzd.get(string2);
        if (zzaez2 == null || zzag.zzc(zzaez2.zzd) || zzag.zzc(zzaez2.zze) || zzaez2.zzb.isEmpty()) {
            return;
        }
        Iterator<zzade> iterator = zzaez2.zzb.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(PhoneAuthCredential.zza(zzaez2.zzd, zzaez2.zze));
        }
        zzaez2.zzh = true;
    }

    static /* synthetic */ void zzb(zzaew zzaew2, String string) {
        zzaew2.zze(string);
    }

    static /* synthetic */ void zzc(zzaew zzaew2, String string) {
        zzaew2.zzf(string);
    }

    zzaew(Context context, ScheduledExecutorService scheduledExecutorService) {
        this.zzb = context;
        this.zzc = scheduledExecutorService;
    }

    final /* synthetic */ void zzb(String string) {
        this.zzf(string);
    }

    private final void zze(String string) {
        zzaez zzaez2 = this.zzd.get(string);
        if (zzaez2 == null) {
            return;
        }
        if (!zzaez2.zzh && !zzag.zzc(zzaez2.zzd)) {
            zza.w("Timed out waiting for SMS.", new Object[0]);
            Iterator<zzade> iterator = zzaez2.zzb.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza(zzaez2.zzd);
            }
            zzaez2.zzi = true;
        }
    }

    private final void zzf(String string) {
        zzaez zzaez2 = this.zzd.get(string);
        if (zzaez2 == null) {
            return;
        }
        if (!zzaez2.zzi) {
            this.zze(string);
        }
        this.zzc(string);
    }

    final void zzb(zzade zzade2, String string) {
        zzaez zzaez2 = this.zzd.get(string);
        if (zzaez2 == null) {
            return;
        }
        zzaez2.zzb.add(zzade2);
        if (zzaez2.zzg) {
            zzade2.zzb(zzaez2.zzd);
        }
        if (zzaez2.zzh) {
            zzade2.zza(PhoneAuthCredential.zza(zzaez2.zzd, zzaez2.zze));
        }
        if (zzaez2.zzi) {
            zzade2.zza(zzaez2.zzd);
        }
    }

    final void zzc(String string) {
        zzaez zzaez2 = this.zzd.get(string);
        if (zzaez2 == null) {
            return;
        }
        if (zzaez2.zzf != null && !zzaez2.zzf.isDone()) {
            zzaez2.zzf.cancel(false);
        }
        zzaez2.zzb.clear();
        this.zzd.remove(string);
    }

    final void zza(String string, zzade zzade2, long l, boolean bl) {
        this.zzd.put(string, new zzaez(l, bl));
        this.zzb(zzade2, string);
        String string2 = string;
        zzaew zzaew2 = this;
        zzaez zzaez2 = zzaew2.zzd.get(string2);
        if (zzaez2.zza <= 0L) {
            zza.w("Timeout of 0 specified; SmsRetriever will not start.", new Object[0]);
            return;
        }
        String string3 = string2;
        zzaew zzaew3 = zzaew2;
        zzaez2.zzf = zzaew2.zzc.schedule(new zzaev(zzaew3, string3), zzaez2.zza, TimeUnit.SECONDS);
        if (!zzaez2.zzc) {
            zza.w("SMS auto-retrieval unavailable; SmsRetriever will not start.", new Object[0]);
            return;
        }
        zzafa zzafa2 = new zzafa(zzaew2, string2);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.google.android.gms.auth.api.phone.SMS_RETRIEVED");
        com.google.android.gms.internal.firebase-auth-api.zzc.zza(zzaew2.zzb.getApplicationContext(), zzafa2, intentFilter);
        SmsRetriever.getClient((Context)zzaew2.zzb).startSmsRetriever().addOnFailureListener((OnFailureListener)new zzaey(zzaew2));
    }

    final boolean zzd(String string) {
        return this.zzd.get(string) != null;
    }
}

