/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase-auth-api;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.firebase-auth-api.zzabg;
import com.google.android.gms.internal.firebase-auth-api.zzadq;
import com.google.android.gms.internal.firebase-auth-api.zzadr;
import com.google.android.gms.internal.firebase-auth-api.zzadt;
import com.google.android.gms.internal.firebase-auth-api.zzadu;
import com.google.android.gms.internal.firebase-auth-api.zzael;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import org.json.JSONException;

public final class zzaeo {
    private static void zza(HttpURLConnection httpURLConnection, zzael<?> zzael2, Type type) {
        try {
            Object object;
            int n = httpURLConnection.getResponseCode();
            InputStream inputStream = zzaeo.zza(n) ? httpURLConnection.getInputStream() : httpURLConnection.getErrorStream();
            StringBuilder stringBuilder = new StringBuilder();
            try (Object object2 = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));){
                while ((object = ((BufferedReader)object2).readLine()) != null) {
                    stringBuilder.append((String)object);
                }
            }
            object2 = stringBuilder.toString();
            if (!zzaeo.zza(n)) {
                object = (String)zzadr.zza((String)object2, String.class);
                zzael2.zza(object);
            } else {
                object = (zzadt)zzadr.zza((String)object2, type);
                zzael2.zza(object);
            }
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            zzael2.zza("TIMEOUT");
            return;
        }
        catch (zzabg | IOException exception) {
            zzael2.zza(exception.getMessage());
            return;
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public static void zza(String string, zzael<?> zzael2, Type type, zzadu zzadu2) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setConnectTimeout(60000);
            zzadu2.zza(httpURLConnection);
            zzaeo.zza(httpURLConnection, zzael2, type);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            zzael2.zza("TIMEOUT");
            return;
        }
        catch (UnknownHostException unknownHostException) {
            zzael2.zza("<<Network Error>>");
            return;
        }
        catch (IOException iOException) {
            zzael2.zza(iOException.getMessage());
            return;
        }
    }

    public static void zza(String string, zzadq zzadq2, zzael<?> zzael2, Type type, zzadu zzadu2) {
        try {
            Preconditions.checkNotNull((Object)zzadq2);
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setDoOutput(true);
            byte[] byArray = zzadq2.zza().getBytes(Charset.defaultCharset());
            httpURLConnection.setFixedLengthStreamingMode(byArray.length);
            httpURLConnection.setRequestProperty("Content-Type", "application/json");
            httpURLConnection.setConnectTimeout(60000);
            zzadu2.zza(httpURLConnection);
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(httpURLConnection.getOutputStream(), byArray.length);){
                ((OutputStream)bufferedOutputStream).write(byArray, 0, byArray.length);
            }
            zzaeo.zza(httpURLConnection, zzael2, type);
            return;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            zzael2.zza("TIMEOUT");
            return;
        }
        catch (UnknownHostException unknownHostException) {
            zzael2.zza("<<Network Error>>");
            return;
        }
        catch (IOException | NullPointerException | JSONException throwable) {
            zzael2.zza(throwable.getMessage());
            return;
        }
    }

    private static final boolean zza(int n) {
        return n >= 200 && n < 300;
    }
}

