/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.processor.internal.optionvalues.BooleanValue;
import dagger.hilt.processor.internal.optionvalues.GradleProjectType;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.tools.Diagnostic;

public final class HiltCompilerOptions {
    private static final EnumOption<BooleanValue> DISABLE_ANDROID_SUPERCLASS_VALIDATION = new EnumOption<BooleanValue>("android.internal.disableAndroidSuperclassValidation", BooleanValue.FALSE);
    private static final EnumOption<BooleanValue> USE_AGGREGATING_ROOT_PROCESSOR = new EnumOption<BooleanValue>("internal.useAggregatingRootProcessor", BooleanValue.TRUE);
    private static final EnumOption<BooleanValue> DISABLE_CROSS_COMPILATION_ROOT_VALIDATION = new EnumOption<BooleanValue>("disableCrossCompilationRootValidation", BooleanValue.FALSE);
    private static final EnumOption<BooleanValue> DISABLE_MODULES_HAVE_INSTALL_IN_CHECK = new EnumOption<BooleanValue>("disableModulesHaveInstallInCheck", BooleanValue.FALSE);
    private static final EnumOption<BooleanValue> SHARE_TEST_COMPONENTS = new EnumOption<BooleanValue>("shareTestComponents", BooleanValue.TRUE);
    private static final EnumOption<GradleProjectType> GRADLE_PROJECT_TYPE = new EnumOption<GradleProjectType>("android.internal.projectType", GradleProjectType.UNSET);
    private static final ImmutableSet<String> DEPRECATED_OPTIONS = ImmutableSet.of((Object)"dagger.hilt.android.useFragmentGetContextFix");

    public static boolean isAndroidSuperClassValidationDisabled(XTypeElement element) {
        EnumOption<BooleanValue> option = DISABLE_ANDROID_SUPERCLASS_VALIDATION;
        XProcessingEnv processorEnv = XConverters.getProcessingEnv((XElement)element);
        return option.get(processorEnv) == BooleanValue.TRUE;
    }

    public static boolean isCrossCompilationRootValidationDisabled(ImmutableSet<XTypeElement> rootElements, XProcessingEnv env) {
        EnumOption<BooleanValue> option = DISABLE_CROSS_COMPILATION_ROOT_VALIDATION;
        return option.get(env) == BooleanValue.TRUE;
    }

    public static boolean isModuleInstallInCheckDisabled(XProcessingEnv env) {
        return DISABLE_MODULES_HAVE_INSTALL_IN_CHECK.get(env) == BooleanValue.TRUE;
    }

    public static boolean isSharedTestComponentsEnabled(XProcessingEnv env) {
        return SHARE_TEST_COMPONENTS.get(env) == BooleanValue.TRUE;
    }

    public static boolean useAggregatingRootProcessor(XProcessingEnv env) {
        return USE_AGGREGATING_ROOT_PROCESSOR.get(env) == BooleanValue.TRUE;
    }

    public static GradleProjectType getGradleProjectType(XProcessingEnv env) {
        return GRADLE_PROJECT_TYPE.get(env);
    }

    public static void checkWrongAndDeprecatedOptions(XProcessingEnv env) {
        Set<String> knownOptions = HiltCompilerOptions.getProcessorOptions();
        for (String option : env.getOptions().keySet()) {
            if (knownOptions.contains(option)) continue;
            if (DEPRECATED_OPTIONS.contains((Object)option)) {
                env.getMessager().printMessage(Diagnostic.Kind.ERROR, "The compiler option " + option + " is deprecated and no longer does anything. Please do not set this option.");
                continue;
            }
            if (!option.startsWith("dagger.hilt.")) continue;
            env.getMessager().printMessage(Diagnostic.Kind.ERROR, "The compiler option " + option + " is not a recognized Hilt option. Is there a typo?");
        }
    }

    public static Set<String> getProcessorOptions() {
        return (Set)EnumOption.getAllOptions().stream().map(EnumOption::getQualifiedName).collect(DaggerStreams.toImmutableSet());
    }

    private static final class EnumOption<E extends Enum<E>> {
        private final String name;
        private final E defaultValue;
        private static final Set<EnumOption<?>> options = new HashSet();

        EnumOption(String name, E defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
            options.add(this);
        }

        String getQualifiedName() {
            return "dagger.hilt." + this.name;
        }

        E get(XProcessingEnv env) {
            String uppercaseValue;
            String value = (String)env.getOptions().get(this.getQualifiedName());
            if (value == null) {
                return this.defaultValue;
            }
            ImmutableSet validOptionNames = (ImmutableSet)Arrays.stream((Enum[])((Enum)this.defaultValue).getDeclaringClass().getEnumConstants()).map(Enum::name).collect(DaggerStreams.toImmutableSet());
            if (validOptionNames.contains((Object)(uppercaseValue = Ascii.toUpperCase((String)value)))) {
                return Enum.valueOf(((Enum)this.defaultValue).getDeclaringClass(), uppercaseValue);
            }
            throw new IllegalStateException(String.format(Locale.ROOT, "Expected a value of %s  for the flag \"%s\". Got instead: %s", String.join((CharSequence)"/", (Iterable<? extends CharSequence>)validOptionNames), this.name, value));
        }

        static Set<EnumOption<?>> getAllOptions() {
            return options;
        }
    }
}

