/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.ResponseData;
import com.google.android.gms.fido.u2f.api.common.zzi;
import com.google.android.gms.internal.fido.zzam;
import com.google.android.gms.internal.fido.zzan;
import com.google.android.gms.internal.fido.zzch;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="RegisterResponseDataCreator")
public class RegisterResponseData
extends ResponseData {
    @NonNull
    public static final Parcelable.Creator<RegisterResponseData> CREATOR = new zzi();
    @SafeParcelable.Field(id=2, getter="getRegisterData")
    private final byte[] zza;
    @SafeParcelable.Field(id=3, getter="getProtocolVersionAsString", type="java.lang.String")
    private final ProtocolVersion zzb;
    @SafeParcelable.Field(id=4, getter="getClientDataString")
    @Nullable
    private final String zzc;

    public int getVersionCode() {
        switch (this.zzb.ordinal()) {
            default: {
                return -1;
            }
            case 1: {
                return 1;
            }
            case 2: 
        }
        return 2;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzb, Arrays.hashCode(this.zza), this.zzc});
    }

    @NonNull
    public ProtocolVersion getProtocolVersion() {
        return this.zzb;
    }

    @NonNull
    public String getClientDataString() {
        return this.zzc;
    }

    @NonNull
    public String toString() {
        zzam zzam2 = zzan.zza(this_);
        zzam2.zzb("protocolVersion", (Object)this_.zzb);
        String string = zzch.zzf().zzg(this_.zza, 0, this_.zza.length);
        zzam2.zzb("registerData", string);
        Object this_ = this_.zzc;
        if (this_ != null) {
            zzam2.zzb("clientDataString", this_);
        }
        return zzam2.toString();
    }

    @Override
    @NonNull
    public JSONObject toJsonObject() {
        JSONObject jSONObject;
        block3: {
            Object object;
            String string;
            try {
                jSONObject = new JSONObject();
                string = "registrationData";
                Object object2 = object.zza;
                object2 = Base64.encodeToString((byte[])object2, (int)11);
                jSONObject.put(string, object2);
                jSONObject.put("version", (Object)object.zzb.toString());
                object = object.zzc;
                if (object == null) break block3;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
            string = "clientData";
            object = ((String)object).getBytes();
            object = Base64.encodeToString((byte[])object, (int)11);
            jSONObject.put(string, object);
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     */
    public RegisterResponseData(@NonNull byte[] registerData) {
        void var1_1;
        this.zza = (byte[])Preconditions.checkNotNull((Object)var1_1);
        this.zzb = ProtocolVersion.V1;
        this.zzc = null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public RegisterResponseData(@NonNull byte[] registerData, @NonNull ProtocolVersion protocolVersion, @Nullable String clientDataString) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.zza = (byte[])Preconditions.checkNotNull((Object)var1_1);
        this.zzb = (ProtocolVersion)((Object)Preconditions.checkNotNull((Object)var2_3));
        boolean bl = var2_3 != ProtocolVersion.UNKNOWN;
        Preconditions.checkArgument((boolean)bl);
        if (var2_3 != ProtocolVersion.V1) {
            this.zzc = (String)Preconditions.checkNotNull((Object)var3_4);
            return;
        }
        bl = var3_4 == null;
        Preconditions.checkArgument((boolean)bl);
        this.zzc = null;
    }

    @SafeParcelable.Constructor
    RegisterResponseData(@SafeParcelable.Param(id=2) byte[] byArray, @SafeParcelable.Param(id=3) String string, @Nullable @SafeParcelable.Param(id=4) String string2) {
        this.zza = byArray;
        try {
            this.zzb = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzc = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)2, (byte[])this.getRegisterData(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zzb.toString(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)4, (String)this.getClientDataString(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object obj) {
        RegisterResponseData registerResponseData;
        if (!(obj instanceof RegisterResponseData)) {
            return false;
        }
        registerResponseData = registerResponseData;
        return Objects.equal((Object)((Object)this.zzb), (Object)((Object)registerResponseData.zzb)) && Arrays.equals(this.zza, registerResponseData.zza) && Objects.equal((Object)this.zzc, (Object)registerResponseData.zzc);
    }

    @NonNull
    public byte[] getRegisterData() {
        return this.zza;
    }
}

