/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.u2f.api.common.ProtocolVersion;
import com.google.android.gms.fido.u2f.api.common.zzg;
import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
@SafeParcelable.Class(creator="RegisterRequestCreator")
public class RegisterRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<RegisterRequest> CREATOR = new zzg();
    public static final int U2F_V1_CHALLENGE_BYTE_LENGTH = 65;
    @SafeParcelable.VersionField(id=1, getter="getVersionCode")
    private final int zza;
    @SafeParcelable.Field(id=2, getter="getProtocolVersionAsString", type="java.lang.String")
    private final ProtocolVersion zzb;
    @SafeParcelable.Field(id=3, getter="getChallengeValue")
    private final byte[] zzc;
    @SafeParcelable.Field(id=4, getter="getAppId")
    private final String zzd;

    public int getVersionCode() {
        return this.zza;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int hashCode() {
        int n;
        int n2 = ((RegisterRequest)((Object)this_)).zzb.hashCode();
        n2 = (Arrays.hashCode(((RegisterRequest)((Object)this_)).zzc) + 31) * 31 + n2;
        String this_ = ((RegisterRequest)((Object)this_)).zzd;
        if (this_ == null) {
            n = 0;
            return n2 * 31 + n;
        }
        n = this_.hashCode();
        return n2 * 31 + n;
    }

    @NonNull
    public ProtocolVersion getProtocolVersion() {
        return this.zzb;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static RegisterRequest parseFromJson(@NonNull JSONObject registerRequest) throws JSONException {
        ProtocolVersion protocolVersion;
        JSONObject jSONObject;
        if (registerRequest.has("version")) {
            String string = jSONObject.getString("version");
        } else {
            Object var1_10 = null;
        }
        try {
            void var1_8;
            protocolVersion = ProtocolVersion.fromString((String)var1_8);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new JSONException(unsupportedProtocolException.toString());
        }
        Object object = jSONObject.getString("challenge");
        try {}
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.toString());
        }
        object = Base64.decode((String)object, (int)8);
        if (jSONObject.has("appId")) {
            String string = jSONObject.getString("appId");
        } else {
            Object var0_3 = null;
        }
        try {
            void var0_2;
            return new RegisterRequest(protocolVersion, (byte[])object, (String)var0_2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new JSONException(illegalArgumentException.getMessage());
        }
    }

    @NonNull
    public String getAppId() {
        return this.zzd;
    }

    @NonNull
    public JSONObject toJson() {
        JSONObject jSONObject;
        block3: {
            jSONObject = new JSONObject();
            try {
                jSONObject.put("version", (Object)object.zzb.toString());
                jSONObject.put("challenge", (Object)Base64.encodeToString((byte[])object.zzc, (int)11));
                Object object = object.zzd;
                if (object == null) break block3;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException(jSONException);
            }
            String string = "appId";
            jSONObject.put(string, object);
        }
        return jSONObject;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public RegisterRequest(@NonNull ProtocolVersion protocolVersion, @NonNull byte[] challengeValue, @NonNull String appId) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.zza = 1;
        this.zzb = (ProtocolVersion)((Object)Preconditions.checkNotNull((Object)var1_1));
        this.zzc = (byte[])Preconditions.checkNotNull((Object)var2_3);
        if (var1_1 == ProtocolVersion.V1) {
            boolean bl = ((void)var2_3).length == 65;
            Preconditions.checkArgument((boolean)bl, (Object)"invalid challengeValue length for V1");
        }
        this.zzd = var3_4;
    }

    @SafeParcelable.Constructor
    RegisterRequest(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) byte[] byArray, @SafeParcelable.Param(id=4) String string2) {
        this.zza = n;
        try {
            this.zzb = ProtocolVersion.fromString(string);
        }
        catch (ProtocolVersion.UnsupportedProtocolException unsupportedProtocolException) {
            throw new IllegalArgumentException(unsupportedProtocolException);
        }
        this.zzc = byArray;
        this.zzd = string2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)1, (int)this.getVersionCode());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.zzb.toString(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)3, (byte[])this.getChallengeValue(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)4, (String)this.getAppId(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@NonNull Object obj) {
        RegisterRequest registerRequest;
        if (this_ == registerRequest) {
            return true;
        }
        if (!(registerRequest instanceof RegisterRequest)) {
            return false;
        }
        registerRequest = registerRequest;
        if (!Arrays.equals(((RegisterRequest)((Object)this_)).zzc, registerRequest.zzc)) {
            return false;
        }
        if (((RegisterRequest)((Object)this_)).zzb != registerRequest.zzb) {
            return false;
        }
        String this_ = ((RegisterRequest)((Object)this_)).zzd;
        return !(this_ == null ? registerRequest.zzd != null : !this_.equals(registerRequest.zzd));
    }

    @NonNull
    public byte[] getChallengeValue() {
        return this.zzc;
    }
}

