/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.fido2.api.common.UvmEntry;
import com.google.android.gms.fido.fido2.api.common.zzaz;
import com.google.android.gms.internal.fido.zzap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

@SafeParcelable.Class(creator="UvmEntriesCreator")
public class UvmEntries
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<UvmEntries> CREATOR = new zzaz();
    @SafeParcelable.Field(id=1, getter="getUvmEntryList")
    @Nullable
    private final List zza;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{new HashSet(this.zza)});
    }

    @Nullable
    public List<UvmEntry> getUvmEntryList() {
        return this.zza;
    }

    @SafeParcelable.Constructor
    UvmEntries(@Nullable @SafeParcelable.Param(id=1) List list) {
        this.zza = list;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        void v0 = var1_1;
        SafeParcelWriter.writeTypedList((Parcel)v0, (int)1, this.getUvmEntryList(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v0, (int)SafeParcelWriter.beginObjectHeader((Parcel)dest));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@NonNull Object obj) {
        UvmEntries uvmEntries;
        if (!(obj instanceof UvmEntries)) {
            return false;
        }
        uvmEntries = uvmEntries;
        List list = this.zza;
        if (list == null) {
            if (uvmEntries.zza == null) return true;
        }
        if (list == null) return false;
        List list2 = uvmEntries.zza;
        if (list2 == null) return false;
        if (!list.containsAll(list2)) return false;
        if (!uvmEntries.zza.containsAll(this.zza)) return false;
        return true;
    }

    @NonNull
    public final JSONArray zza() {
        JSONArray jSONArray;
        block5: {
            int n;
            try {
                jSONArray = new JSONArray();
                List list = this.zza;
                if (list == null) break block5;
                n = 0;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Error encoding UvmEntries to JSON object", jSONException);
            }
            while (true) {
                int n2 = this.zza.size();
                if (n >= n2) break block5;
                break;
            }
            {
                int n3 = n++;
                UvmEntry uvmEntry = (UvmEntry)((Object)this.zza.get(n3));
                JSONArray jSONArray2 = new JSONArray();
                jSONArray2.put((int)uvmEntry.getMatcherProtectionType());
                jSONArray2.put((int)uvmEntry.getKeyProtectionType());
                jSONArray2.put((int)uvmEntry.getMatcherProtectionType());
                jSONArray.put(n3, (Object)jSONArray2);
                continue;
            }
        }
        return jSONArray;
    }

    public static final class Builder {
        private final List zza = new ArrayList();

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public Builder addAll(@NonNull List<UvmEntry> uvmEntryList) {
            void var1_1;
            boolean bl = this.zza.size() + var1_1.size() <= 3;
            zzap.zzc(bl);
            this.zza.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder addUvmEntry(@Nullable UvmEntry uvmEntry) {
            void var1_1;
            if (this.zza.size() >= 3) {
                throw new IllegalStateException();
            }
            this.zza.add(var1_1);
            return this;
        }

        @NonNull
        public UvmEntries build() {
            return new UvmEntries(this.zza);
        }
    }
}

