/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.fido.fido2.api.common.AttestationConveyancePreference;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorSelectionCriteria;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialDescriptor;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialParameters;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRpEntity;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialUserEntity;
import com.google.android.gms.fido.fido2.api.common.RequestOptions;
import com.google.android.gms.fido.fido2.api.common.TokenBinding;
import com.google.android.gms.fido.fido2.api.common.zzak;
import java.util.Arrays;
import java.util.List;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="PublicKeyCredentialCreationOptionsCreator")
public class PublicKeyCredentialCreationOptions
extends RequestOptions {
    @NonNull
    public static final Parcelable.Creator<PublicKeyCredentialCreationOptions> CREATOR = new zzak();
    @NonNull
    @SafeParcelable.Field(id=2, getter="getRp")
    private final PublicKeyCredentialRpEntity zza;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getUser")
    private final PublicKeyCredentialUserEntity zzb;
    @NonNull
    @SafeParcelable.Field(id=4, getter="getChallenge")
    private final byte[] zzc;
    @NonNull
    @SafeParcelable.Field(id=5, getter="getParameters")
    private final List zzd;
    @Nullable
    @SafeParcelable.Field(id=6, getter="getTimeoutSeconds")
    private final Double zze;
    @Nullable
    @SafeParcelable.Field(id=7, getter="getExcludeList")
    private final List zzf;
    @Nullable
    @SafeParcelable.Field(id=8, getter="getAuthenticatorSelection")
    private final AuthenticatorSelectionCriteria zzg;
    @Nullable
    @SafeParcelable.Field(id=9, getter="getRequestId")
    private final Integer zzh;
    @Nullable
    @SafeParcelable.Field(id=10, getter="getTokenBinding")
    private final TokenBinding zzi;
    @Nullable
    @SafeParcelable.Field(id=11, getter="getAttestationConveyancePreferenceAsString", type="java.lang.String")
    private final AttestationConveyancePreference zzj;
    @Nullable
    @SafeParcelable.Field(id=12, getter="getAuthenticationExtensions")
    private final AuthenticationExtensions zzk;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, Arrays.hashCode(this.zzc), this.zzd, this.zze, this.zzf, this.zzg, this.zzh, this.zzi, this.zzj, this.zzk});
    }

    @Nullable
    public AttestationConveyancePreference getAttestationConveyancePreference() {
        return this.zzj;
    }

    @Override
    @Nullable
    public AuthenticationExtensions getAuthenticationExtensions() {
        return this.zzk;
    }

    @Nullable
    public AuthenticatorSelectionCriteria getAuthenticatorSelection() {
        return this.zzg;
    }

    @NonNull
    public static PublicKeyCredentialCreationOptions deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (PublicKeyCredentialCreationOptions)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @NonNull
    public PublicKeyCredentialRpEntity getRp() {
        return this.zza;
    }

    @NonNull
    public PublicKeyCredentialUserEntity getUser() {
        return this.zzb;
    }

    @Override
    @Nullable
    public TokenBinding getTokenBinding() {
        return this.zzi;
    }

    @Override
    @Nullable
    public Double getTimeoutSeconds() {
        return this.zze;
    }

    @Override
    @Nullable
    public Integer getRequestId() {
        return this.zzh;
    }

    @Nullable
    public String getAttestationConveyancePreferenceAsString() {
        Object this_ = this_.zzj;
        if (this_ == null) {
            return null;
        }
        return ((AttestationConveyancePreference)((Object)this_)).toString();
    }

    @Nullable
    public List<PublicKeyCredentialDescriptor> getExcludeList() {
        return this.zzf;
    }

    @NonNull
    public List<PublicKeyCredentialParameters> getParameters() {
        return this.zzd;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    PublicKeyCredentialCreationOptions(@NonNull @SafeParcelable.Param(id=2) PublicKeyCredentialRpEntity publicKeyCredentialRpEntity, @NonNull @SafeParcelable.Param(id=3) PublicKeyCredentialUserEntity publicKeyCredentialUserEntity, @NonNull @SafeParcelable.Param(id=4) byte[] byArray, @NonNull @SafeParcelable.Param(id=5) List list, @Nullable @SafeParcelable.Param(id=6) Double d, @Nullable @SafeParcelable.Param(id=7) List list2, @Nullable @SafeParcelable.Param(id=8) AuthenticatorSelectionCriteria authenticatorSelectionCriteria, @Nullable @SafeParcelable.Param(id=9) Integer n, @Nullable @SafeParcelable.Param(id=10) TokenBinding tokenBinding, @Nullable @SafeParcelable.Param(id=11) String string, @Nullable @SafeParcelable.Param(id=12) AuthenticationExtensions authenticationExtensions) {
        this.zza = (PublicKeyCredentialRpEntity)((Object)Preconditions.checkNotNull((Object)((Object)publicKeyCredentialRpEntity)));
        this.zzb = (PublicKeyCredentialUserEntity)((Object)Preconditions.checkNotNull((Object)((Object)publicKeyCredentialUserEntity)));
        this.zzc = (byte[])Preconditions.checkNotNull((Object)byArray);
        this.zzd = (List)Preconditions.checkNotNull((Object)list);
        this.zze = d;
        this.zzf = list2;
        this.zzg = authenticatorSelectionCriteria;
        this.zzh = n;
        this.zzi = tokenBinding;
        if (string != null) {
            try {
                this.zzj = AttestationConveyancePreference.fromString(string);
            }
            catch (AttestationConveyancePreference.UnsupportedAttestationConveyancePreferenceException unsupportedAttestationConveyancePreferenceException) {
                throw new IllegalArgumentException(unsupportedAttestationConveyancePreferenceException);
            }
        } else {
            this.zzj = null;
        }
        this.zzk = authenticationExtensions;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getRp(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getUser(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)4, (byte[])this.getChallenge(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)5, this.getParameters(), (boolean)false);
        SafeParcelWriter.writeDoubleObject((Parcel)var1_1, (int)6, (Double)this.getTimeoutSeconds(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)7, this.getExcludeList(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)8, (Parcelable)this.getAuthenticatorSelection(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeIntegerObject((Parcel)var1_1, (int)9, (Integer)this.getRequestId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)10, (Parcelable)this.getTokenBinding(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)11, (String)this.getAttestationConveyancePreferenceAsString(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeParcelable((Parcel)v1, (int)12, (Parcelable)this.getAuthenticationExtensions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@NonNull Object obj) {
        List list;
        List list2;
        PublicKeyCredentialCreationOptions publicKeyCredentialCreationOptions;
        if (!(obj instanceof PublicKeyCredentialCreationOptions)) {
            return false;
        }
        publicKeyCredentialCreationOptions = publicKeyCredentialCreationOptions;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)publicKeyCredentialCreationOptions.zza)) && Objects.equal((Object)((Object)this.zzb), (Object)((Object)publicKeyCredentialCreationOptions.zzb)) && Arrays.equals(this.zzc, publicKeyCredentialCreationOptions.zzc) && Objects.equal((Object)this.zze, (Object)publicKeyCredentialCreationOptions.zze) && this.zzd.containsAll(publicKeyCredentialCreationOptions.zzd) && publicKeyCredentialCreationOptions.zzd.containsAll(this.zzd) && ((list2 = this.zzf) == null && publicKeyCredentialCreationOptions.zzf == null || list2 != null && (list = publicKeyCredentialCreationOptions.zzf) != null && list2.containsAll(list) && publicKeyCredentialCreationOptions.zzf.containsAll(this.zzf)) && Objects.equal((Object)((Object)this.zzg), (Object)((Object)publicKeyCredentialCreationOptions.zzg)) && Objects.equal((Object)this.zzh, (Object)publicKeyCredentialCreationOptions.zzh) && Objects.equal((Object)((Object)this.zzi), (Object)((Object)publicKeyCredentialCreationOptions.zzi)) && Objects.equal((Object)((Object)this.zzj), (Object)((Object)publicKeyCredentialCreationOptions.zzj)) && Objects.equal((Object)((Object)this.zzk), (Object)((Object)publicKeyCredentialCreationOptions.zzk));
    }

    @Override
    @NonNull
    public byte[] getChallenge() {
        return this.zzc;
    }

    @Override
    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    public static final class Builder {
        private PublicKeyCredentialRpEntity zza;
        private PublicKeyCredentialUserEntity zzb;
        private byte[] zzc;
        private List zzd;
        private Double zze;
        private List zzf;
        private AuthenticatorSelectionCriteria zzg;
        private Integer zzh;
        private TokenBinding zzi;
        private AttestationConveyancePreference zzj;
        private AuthenticationExtensions zzk;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAttestationConveyancePreference(@Nullable AttestationConveyancePreference attestationConveyancePreference) {
            void var1_1;
            this.zzj = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticationExtensions(@Nullable AuthenticationExtensions authenticationExtensions) {
            void var1_1;
            this.zzk = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAuthenticatorSelection(@Nullable AuthenticatorSelectionCriteria authenticatorSelection) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setChallenge(@NonNull byte[] challenge) {
            void var1_1;
            this.zzc = (byte[])Preconditions.checkNotNull((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setExcludeList(@Nullable List<PublicKeyCredentialDescriptor> excludeList) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setParameters(@NonNull List<PublicKeyCredentialParameters> parameters) {
            void var1_1;
            this.zzd = (List)Preconditions.checkNotNull((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestId(@Nullable Integer requestId) {
            void var1_1;
            this.zzh = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRp(@NonNull PublicKeyCredentialRpEntity rp) {
            void var1_1;
            this.zza = (PublicKeyCredentialRpEntity)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTimeoutSeconds(@Nullable Double timeoutSeconds) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTokenBinding(@Nullable TokenBinding tokenBinding) {
            void var1_1;
            this.zzi = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setUser(@NonNull PublicKeyCredentialUserEntity user) {
            void var1_1;
            this.zzb = (PublicKeyCredentialUserEntity)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @NonNull
        public PublicKeyCredentialCreationOptions build() {
            void var1_13;
            PublicKeyCredentialRpEntity publicKeyCredentialRpEntity = this.zza;
            PublicKeyCredentialUserEntity publicKeyCredentialUserEntity = this.zzb;
            byte[] byArray = this.zzc;
            List list = this.zzd;
            Double d = this.zze;
            List list2 = this.zzf;
            AuthenticatorSelectionCriteria authenticatorSelectionCriteria = this.zzg;
            Integer n = this.zzh;
            TokenBinding tokenBinding = this.zzi;
            AttestationConveyancePreference attestationConveyancePreference = this.zzj;
            if (attestationConveyancePreference == null) {
                Object var1_12 = null;
                return new PublicKeyCredentialCreationOptions(publicKeyCredentialRpEntity, publicKeyCredentialUserEntity, byArray, list, d, list2, authenticatorSelectionCriteria, n, tokenBinding, (String)var1_13, this.zzk);
            }
            String string = attestationConveyancePreference.toString();
            return new PublicKeyCredentialCreationOptions(publicKeyCredentialRpEntity, publicKeyCredentialUserEntity, byArray, list, d, list2, authenticatorSelectionCriteria, n, tokenBinding, (String)var1_13, this.zzk);
        }
    }
}

