/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.fido.fido2.api.common.zzy;
import java.util.Arrays;

@SafeParcelable.Class(creator="FidoCredentialDetailsCreator")
public class FidoCredentialDetails
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<FidoCredentialDetails> CREATOR = new zzy();
    @Nullable
    @SafeParcelable.Field(id=1, getter="getUserName")
    private final String zza;
    @Nullable
    @SafeParcelable.Field(id=2, getter="getUserDisplayName")
    private final String zzb;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getUserId")
    private final byte[] zzc;
    @NonNull
    @SafeParcelable.Field(id=4, getter="getCredentialId")
    private final byte[] zzd;
    @SafeParcelable.Field(id=5, getter="getIsDiscoverable")
    private final boolean zze;
    @SafeParcelable.Field(id=6, getter="getIsPaymentCredential")
    private final boolean zzf;
    @SafeParcelable.Field(id=7, defaultValue="0", getter="getLastUsedTime")
    private final long zzg;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg});
    }

    public long getLastUsedTime() {
        return this.zzg;
    }

    @NonNull
    public static FidoCredentialDetails deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (FidoCredentialDetails)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @Nullable
    public String getUserDisplayName() {
        return this.zzb;
    }

    @Nullable
    public String getUserName() {
        return this.zza;
    }

    @SafeParcelable.Constructor
    FidoCredentialDetails(@Nullable @SafeParcelable.Param(id=1) String string, @Nullable @SafeParcelable.Param(id=2) String string2, @Nullable @SafeParcelable.Param(id=3) byte[] byArray, @NonNull @SafeParcelable.Param(id=4) byte[] byArray2, @SafeParcelable.Param(id=5) boolean bl, @SafeParcelable.Param(id=6) boolean bl2, @SafeParcelable.Param(id=7) long l) {
        this.zza = string;
        this.zzb = string2;
        this.zzc = byArray;
        this.zzd = byArray2;
        this.zze = bl;
        this.zzf = bl2;
        this.zzg = l;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)1, (String)this.getUserName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getUserDisplayName(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)3, (byte[])this.getUserId(), (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)4, (byte[])this.getCredentialId(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)5, (boolean)this.getIsDiscoverable());
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)6, (boolean)this.getIsPaymentCredential());
        void v1 = var1_1;
        SafeParcelWriter.writeLong((Parcel)v1, (int)7, (long)this.getLastUsedTime());
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@Nullable Object obj) {
        FidoCredentialDetails fidoCredentialDetails;
        if (!(obj instanceof FidoCredentialDetails)) {
            return false;
        }
        fidoCredentialDetails = fidoCredentialDetails;
        return Objects.equal((Object)this.zza, (Object)fidoCredentialDetails.zza) && Objects.equal((Object)this.zzb, (Object)fidoCredentialDetails.zzb) && Arrays.equals(this.zzc, fidoCredentialDetails.zzc) && Arrays.equals(this.zzd, fidoCredentialDetails.zzd) && this.zze == fidoCredentialDetails.zze && this.zzf == fidoCredentialDetails.zzf && this.zzg == fidoCredentialDetails.zzg;
    }

    public boolean getIsDiscoverable() {
        return this.zze;
    }

    public boolean getIsPaymentCredential() {
        return this.zzf;
    }

    @NonNull
    public byte[] getCredentialId() {
        return this.zzd;
    }

    @Nullable
    public byte[] getUserId() {
        return this.zzc;
    }

    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }
}

