/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.fido.fido2.api.common.AuthenticationExtensions;
import com.google.android.gms.fido.fido2.api.common.BrowserRequestOptions;
import com.google.android.gms.fido.fido2.api.common.PublicKeyCredentialRequestOptions;
import com.google.android.gms.fido.fido2.api.common.TokenBinding;
import com.google.android.gms.fido.fido2.api.common.zzo;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="BrowserPublicKeyCredentialRequestOptionsCreator")
public class BrowserPublicKeyCredentialRequestOptions
extends BrowserRequestOptions {
    @NonNull
    public static final Parcelable.Creator<BrowserPublicKeyCredentialRequestOptions> CREATOR = new zzo();
    @NonNull
    @SafeParcelable.Field(id=2, getter="getPublicKeyCredentialRequestOptions")
    private final PublicKeyCredentialRequestOptions zza;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getOrigin")
    private final Uri zzb;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getClientDataHash")
    private final byte[] zzc;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb});
    }

    @Override
    @NonNull
    public Uri getOrigin() {
        return this.zzb;
    }

    @Override
    @Nullable
    public AuthenticationExtensions getAuthenticationExtensions() {
        return this.zza.getAuthenticationExtensions();
    }

    @NonNull
    public static BrowserPublicKeyCredentialRequestOptions deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (BrowserPublicKeyCredentialRequestOptions)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @NonNull
    public PublicKeyCredentialRequestOptions getPublicKeyCredentialRequestOptions() {
        return this.zza;
    }

    @Override
    @Nullable
    public TokenBinding getTokenBinding() {
        return this.zza.getTokenBinding();
    }

    @Override
    @Nullable
    public Double getTimeoutSeconds() {
        return this.zza.getTimeoutSeconds();
    }

    @Override
    @Nullable
    public Integer getRequestId() {
        return this.zza.getRequestId();
    }

    @SafeParcelable.Constructor
    BrowserPublicKeyCredentialRequestOptions(@NonNull @SafeParcelable.Param(id=2) PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions, @NonNull @SafeParcelable.Param(id=3) Uri uri, @Nullable @SafeParcelable.Param(id=4) byte[] byArray) {
        this.zza = (PublicKeyCredentialRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)publicKeyCredentialRequestOptions)));
        BrowserPublicKeyCredentialRequestOptions.zzc(uri);
        this.zzb = uri;
        BrowserPublicKeyCredentialRequestOptions.zzd(byArray);
        this.zzc = byArray;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getPublicKeyCredentialRequestOptions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)3, (Parcelable)this.getOrigin(), (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeByteArray((Parcel)v1, (int)4, (byte[])this.getClientDataHash(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@NonNull Object o) {
        BrowserPublicKeyCredentialRequestOptions browserPublicKeyCredentialRequestOptions;
        if (!(o instanceof BrowserPublicKeyCredentialRequestOptions)) {
            return false;
        }
        browserPublicKeyCredentialRequestOptions = browserPublicKeyCredentialRequestOptions;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)browserPublicKeyCredentialRequestOptions.zza)) && Objects.equal((Object)this.zzb, (Object)browserPublicKeyCredentialRequestOptions.zzb);
    }

    @Override
    @NonNull
    public byte[] getChallenge() {
        return this.zza.getChallenge();
    }

    @Override
    @Nullable
    public byte[] getClientDataHash() {
        return this.zzc;
    }

    @Override
    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    static /* bridge */ /* synthetic */ Uri zza(Uri uri) {
        BrowserPublicKeyCredentialRequestOptions.zzc(uri);
        return uri;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Uri zzc(Uri uri) {
        Preconditions.checkNotNull((Object)uri);
        boolean bl = uri.getScheme() != null;
        Preconditions.checkArgument((boolean)bl, (Object)"origin scheme must be non-empty");
        bl = uri.getAuthority() != null;
        Preconditions.checkArgument((boolean)bl, (Object)"origin authority must be non-empty");
        return uri;
    }

    static /* bridge */ /* synthetic */ byte[] zzb(byte[] byArray) {
        BrowserPublicKeyCredentialRequestOptions.zzd(byArray);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] zzd(byte[] byArray) {
        boolean bl = byArray != null ? byArray.length == 32 : true;
        Preconditions.checkArgument((boolean)bl, (Object)"clientDataHash must be 32 bytes long");
        return byArray;
    }

    public static final class Builder {
        private PublicKeyCredentialRequestOptions zza;
        private Uri zzb;
        private byte[] zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setClientDataHash(@NonNull byte[] clientDataHash) {
            void var1_1;
            BrowserPublicKeyCredentialRequestOptions.zzb(clientDataHash);
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setOrigin(@NonNull Uri origin) {
            void var1_1;
            BrowserPublicKeyCredentialRequestOptions.zza(origin);
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPublicKeyCredentialRequestOptions(@NonNull PublicKeyCredentialRequestOptions publicKeyCredentialRequestOptions) {
            void var1_1;
            this.zza = (PublicKeyCredentialRequestOptions)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        @NonNull
        public BrowserPublicKeyCredentialRequestOptions build() {
            return new BrowserPublicKeyCredentialRequestOptions(this.zza, this.zzb, this.zzc);
        }
    }
}

