/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.fido2.api.common.Attachment;
import com.google.android.gms.fido.fido2.api.common.ResidentKeyRequirement;
import com.google.android.gms.fido.fido2.api.common.zzax;
import com.google.android.gms.fido.fido2.api.common.zzay;
import com.google.android.gms.fido.fido2.api.common.zzm;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AuthenticatorSelectionCriteriaCreator")
public class AuthenticatorSelectionCriteria
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<AuthenticatorSelectionCriteria> CREATOR = new zzm();
    @Nullable
    @SafeParcelable.Field(id=2, getter="getAttachmentAsString", type="java.lang.String")
    private final Attachment zza;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getRequireResidentKey")
    private final Boolean zzb;
    @Nullable
    @SafeParcelable.Field(id=4, getter="getRequireUserVerificationAsString", type="java.lang.String")
    private final zzay zzc;
    @Nullable
    @SafeParcelable.Field(id=5, getter="getResidentKeyRequirementAsString", type="java.lang.String")
    private final ResidentKeyRequirement zzd;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc, this.getResidentKeyRequirement()});
    }

    @Nullable
    public Attachment getAttachment() {
        return this.zza;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public ResidentKeyRequirement getResidentKeyRequirement() {
        ResidentKeyRequirement residentKeyRequirement = ((AuthenticatorSelectionCriteria)((Object)this_)).zzd;
        if (residentKeyRequirement != null) return residentKeyRequirement;
        Boolean this_ = ((AuthenticatorSelectionCriteria)((Object)this_)).zzb;
        if (this_ == null) return null;
        if (this_ != false) return ResidentKeyRequirement.RESIDENT_KEY_REQUIRED;
        return null;
    }

    @Nullable
    public Boolean getRequireResidentKey() {
        return this.zzb;
    }

    @Nullable
    public String getAttachmentAsString() {
        Object this_ = this_.zza;
        if (this_ == null) {
            return null;
        }
        return ((Attachment)((Object)this_)).toString();
    }

    @Nullable
    public String getResidentKeyRequirementAsString() {
        if (this.getResidentKeyRequirement() == null) {
            return null;
        }
        return this.getResidentKeyRequirement().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SafeParcelable.Constructor
    AuthenticatorSelectionCriteria(@Nullable @SafeParcelable.Param(id=2) String object, @Nullable @SafeParcelable.Param(id=3) Boolean bl, @Nullable @SafeParcelable.Param(id=4) String string, @Nullable @SafeParcelable.Param(id=5) String string2) {
        if (object == null) {
            object = null;
        } else {
            object = Attachment.fromString(object);
        }
        try {
            this.zza = object;
            this.zzb = bl;
            object = string == null ? null : zzay.zza(string);
            this.zzc = object;
            object = string2 == null ? null : ResidentKeyRequirement.fromString(string2);
            this.zzd = object;
            return;
        }
        catch (Attachment.UnsupportedAttachmentException | ResidentKeyRequirement.UnsupportedResidentKeyRequirementException | zzax exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var2_5;
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getAttachmentAsString(), (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)var1_1, (int)3, (Boolean)this.getRequireResidentKey(), (boolean)false);
        zzay zzay2 = this.zzc;
        if (zzay2 == null) {
            Object var2_4 = null;
        } else {
            String string = zzay2.toString();
        }
        SafeParcelWriter.writeString((Parcel)var1_1, (int)4, (String)var2_5, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getResidentKeyRequirementAsString(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n2);
    }

    public boolean equals(@NonNull Object obj) {
        AuthenticatorSelectionCriteria authenticatorSelectionCriteria;
        if (!(obj instanceof AuthenticatorSelectionCriteria)) {
            return false;
        }
        authenticatorSelectionCriteria = authenticatorSelectionCriteria;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)authenticatorSelectionCriteria.zza)) && Objects.equal((Object)this.zzb, (Object)authenticatorSelectionCriteria.zzb) && Objects.equal((Object)((Object)this.zzc), (Object)((Object)authenticatorSelectionCriteria.zzc)) && Objects.equal((Object)((Object)this.getResidentKeyRequirement()), (Object)((Object)authenticatorSelectionCriteria.getResidentKeyRequirement()));
    }

    public static class Builder {
        private Attachment zza;
        private Boolean zzb;
        private ResidentKeyRequirement zzc;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAttachment(@Nullable Attachment attachment) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequireResidentKey(@Nullable Boolean requireResidentKey) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setResidentKeyRequirement(@Nullable ResidentKeyRequirement residentKeyRequirement) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NonNull
        public AuthenticatorSelectionCriteria build() {
            void var0_3;
            void var1_8;
            Attachment attachment = this.zza;
            if (attachment == null) {
                Object var1_7 = null;
            } else {
                String string = attachment.toString();
            }
            Boolean bl = this.zzb;
            ResidentKeyRequirement residentKeyRequirement = this.zzc;
            if (residentKeyRequirement == null) {
                Object var0_2 = null;
                return new AuthenticatorSelectionCriteria((String)var1_8, bl, null, (String)var0_3);
            } else {
                String string = residentKeyRequirement.toString();
            }
            return new AuthenticatorSelectionCriteria((String)var1_8, bl, null, (String)var0_3);
        }
    }
}

