/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zze;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.common.zzi;
import java.util.HashMap;
import javax.annotation.concurrent.GuardedBy;

final class zzf
extends GmsClientSupervisor
implements Handler.Callback {
    @GuardedBy(value="mConnectionStatus")
    private final HashMap<GmsClientSupervisor.zza, zze> zzem = new HashMap();
    private final Context zzen;
    private final Handler handler;
    private final ConnectionTracker zzeo;
    private final long zzep;
    private final long zzeq;

    zzf(Context context) {
        this.zzen = context.getApplicationContext();
        this.handler = new zzi(context.getMainLooper(), this);
        this.zzeo = ConnectionTracker.getInstance();
        this.zzep = 5000L;
        this.zzeq = 300000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean zza(GmsClientSupervisor.zza zza2, ServiceConnection serviceConnection, String string2) {
        ServiceConnection serviceConnection2;
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        ServiceConnection serviceConnection3 = serviceConnection2 = serviceConnection;
        HashMap<GmsClientSupervisor.zza, zze> hashMap = this.zzem;
        synchronized (hashMap) {
            zze zze2 = this.zzem.get(zza2);
            if (zze2 == null) {
                zze2 = new zze(this, zza2);
                zze2.zza(serviceConnection, serviceConnection3, string2);
                zze2.zze(string2);
                this.zzem.put(zza2, zze2);
            } else {
                this.handler.removeMessages(0, (Object)zza2);
                if (zze2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zze2.zza(serviceConnection, serviceConnection3, string2);
                switch (zze2.getState()) {
                    case 1: {
                        serviceConnection3.onServiceConnected(zze2.getComponentName(), zze2.getBinder());
                        break;
                    }
                    case 2: {
                        zze2.zze(string2);
                    }
                }
            }
            return zze2.isBound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void zzb(GmsClientSupervisor.zza zza2, ServiceConnection serviceConnection, String string2) {
        Preconditions.checkNotNull(serviceConnection, "ServiceConnection must not be null");
        HashMap<GmsClientSupervisor.zza, zze> hashMap = this.zzem;
        synchronized (hashMap) {
            zze zze2 = this.zzem.get(zza2);
            if (zze2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zze2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zze2.zza(serviceConnection, string2);
            if (zze2.zzr()) {
                Message message = this.handler.obtainMessage(0, (Object)zza2);
                this.handler.sendMessageDelayed(message, this.zzep);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                HashMap<GmsClientSupervisor.zza, zze> hashMap = this.zzem;
                synchronized (hashMap) {
                    GmsClientSupervisor.zza zza2 = (GmsClientSupervisor.zza)message.obj;
                    zze zze2 = this.zzem.get(zza2);
                    if (zze2 != null && zze2.zzr()) {
                        if (zze2.isBound()) {
                            zze2.zzf("GmsClientSupervisor");
                        }
                        this.zzem.remove(zza2);
                    }
                }
                return true;
            }
            case 1: {
                HashMap<GmsClientSupervisor.zza, zze> hashMap = this.zzem;
                synchronized (hashMap) {
                    GmsClientSupervisor.zza zza3 = (GmsClientSupervisor.zza)message.obj;
                    zze zze3 = this.zzem.get(zza3);
                    if (zze3 != null && zze3.getState() == 3) {
                        String string2 = String.valueOf(zza3);
                        Log.e((String)"GmsClientSupervisor", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Timeout waiting for ServiceConnection callback ").append(string2).toString(), (Throwable)new Exception());
                        string2 = zze3.getComponentName();
                        if (string2 == null) {
                            string2 = zza3.getComponentName();
                        }
                        if (string2 == null) {
                            string2 = new ComponentName(zza3.getPackage(), "unknown");
                        }
                        zze3.onServiceDisconnected((ComponentName)string2);
                    }
                }
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ HashMap zza(zzf zzf2) {
        return zzf2.zzem;
    }

    static /* synthetic */ Handler zzb(zzf zzf2) {
        return zzf2.handler;
    }

    static /* synthetic */ Context zzc(zzf zzf2) {
        return zzf2.zzen;
    }

    static /* synthetic */ ConnectionTracker zzd(zzf zzf2) {
        return zzf2.zzeo;
    }

    static /* synthetic */ long zze(zzf zzf2) {
        return zzf2.zzeq;
    }
}

