/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzb
extends Fragment
implements LifecycleFragment {
    private static WeakHashMap<Activity, WeakReference<zzb>> zzbt = new WeakHashMap();
    private Map<String, LifecycleCallback> zzbu = new ArrayMap();
    private int zzbv = 0;
    private Bundle zzbw;

    public static zzb zza(Activity activity) {
        zzb zzb2;
        WeakReference<zzb> weakReference = zzbt.get(activity);
        if (weakReference != null && (zzb2 = (zzb)weakReference.get()) != null) {
            return zzb2;
        }
        try {
            zzb2 = (zzb)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzb2 == null || zzb2.isRemoving()) {
            zzb2 = new zzb();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzb2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        zzbt.put(activity, new WeakReference<zzb>(zzb2));
        return zzb2;
    }

    @Override
    public final <T extends LifecycleCallback> T getCallbackOrNull(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzbu.get(string2)));
    }

    @Override
    public final void addCallback(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzbu.containsKey(string2)) {
            this.zzbu.put(string2, lifecycleCallback);
            LifecycleCallback lifecycleCallback2 = lifecycleCallback;
            String string3 = string2;
            zzb zzb2 = this;
            if (zzb2.zzbv > 0) {
                new zzi(Looper.getMainLooper()).post(new zza(zzb2, lifecycleCallback2, string3));
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
    }

    @Override
    public final boolean isCreated() {
        return this.zzbv > 0;
    }

    @Override
    public final boolean isStarted() {
        return this.zzbv >= 2;
    }

    @Override
    public final Activity getLifecycleActivity() {
        return this.getActivity();
    }

    public final void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbv = 1;
        this.zzbw = bundle;
        for (Map.Entry<String, LifecycleCallback> entry : this.zzbu.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public final void onStart() {
        super.onStart();
        this.zzbv = 2;
        Iterator<LifecycleCallback> iterator = this.zzbu.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStart();
        }
    }

    public final void onResume() {
        super.onResume();
        this.zzbv = 3;
        Iterator<LifecycleCallback> iterator = this.zzbu.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onResume();
        }
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator<LifecycleCallback> iterator = this.zzbu.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onActivityResult(n, n2, intent);
        }
    }

    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, LifecycleCallback> entry : this.zzbu.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public final void onStop() {
        super.onStop();
        this.zzbv = 4;
        Iterator<LifecycleCallback> iterator = this.zzbu.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onStop();
        }
    }

    public final void onDestroy() {
        super.onDestroy();
        this.zzbv = 5;
        Iterator<LifecycleCallback> iterator = this.zzbu.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().onDestroy();
        }
    }

    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator<LifecycleCallback> iterator = this.zzbu.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    static /* synthetic */ int zza(zzb zzb2) {
        return zzb2.zzbv;
    }

    static /* synthetic */ Bundle zzb(zzb zzb2) {
        return zzb2.zzbw;
    }
}

