/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="ScopeCreator")
@KeepForSdk
public final class Scope
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<Scope> CREATOR = new zza();
    @SafeParcelable.VersionField(id=1)
    private final int zzq;
    @SafeParcelable.Field(id=2, getter="getScopeUri")
    private final String zzbc;

    @SafeParcelable.Constructor
    Scope(@SafeParcelable.Param(id=1) int n, @SafeParcelable.Param(id=2) String string2) {
        Preconditions.checkNotEmpty(string2, "scopeUri must not be null or empty");
        this.zzq = n;
        this.zzbc = string2;
    }

    public Scope(String string2) {
        this(1, string2);
    }

    @KeepForSdk
    public final String getScopeUri() {
        return this.zzbc;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Scope)) {
            return false;
        }
        return this.zzbc.equals(((Scope)object).zzbc);
    }

    public final int hashCode() {
        return this.zzbc.hashCode();
    }

    public final String toString() {
        return this.zzbc;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Scope scope = this;
        int n2 = SafeParcelWriter.beginObjectHeader(parcel2);
        SafeParcelWriter.writeInt(parcel2, 1, scope.zzq);
        SafeParcelWriter.writeString(parcel2, 2, scope.getScopeUri(), false);
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }
}

