/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.signin.internal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import androidx.loader.app.LoaderManager;
import com.google.android.gms.auth.api.signin.GoogleSignInAccount;
import com.google.android.gms.auth.api.signin.GoogleSignInOptions;
import com.google.android.gms.auth.api.signin.SignInAccount;
import com.google.android.gms.auth.api.signin.internal.SignInConfiguration;
import com.google.android.gms.auth.api.signin.internal.zbn;
import com.google.android.gms.auth.api.signin.internal.zbw;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.api.Status;

@KeepName
public class SignInHubActivity
extends FragmentActivity {
    private static boolean zba = false;
    private boolean zbb = false;
    private SignInConfiguration zbc;
    private boolean zbd;
    private int zbe;
    private Intent zbf;

    protected final void onActivityResult(int n, int n2, @Nullable Intent intent) {
        if (this.zbb) {
            return;
        }
        this.setResult(0);
        switch (n) {
            case 40962: {
                if (intent != null) {
                    SignInAccount signInAccount = (SignInAccount)intent.getParcelableExtra("signInAccount");
                    if (signInAccount != null && signInAccount.zba() != null) {
                        signInAccount = signInAccount.zba();
                        zbn zbn2 = zbn.zbc((Context)this);
                        GoogleSignInOptions googleSignInOptions = this.zbc.zba();
                        if (signInAccount == null) {
                            throw null;
                        }
                        zbn2.zbe(googleSignInOptions, (GoogleSignInAccount)signInAccount);
                        intent.removeExtra("signInAccount");
                        intent.putExtra("googleSignInAccount", (Parcelable)signInAccount);
                        this.zbd = true;
                        this.zbe = n2;
                        this.zbf = intent;
                        this.zbc();
                        return;
                    }
                    if (intent.hasExtra("errorCode")) {
                        int n3 = intent.getIntExtra("errorCode", 8);
                        if (n3 == 13) {
                            n3 = 12501;
                        }
                        this.zbd(n3);
                        return;
                    }
                }
                this.zbd(8);
                return;
            }
        }
    }

    protected final void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Object object = this.getIntent();
        String string = object.getAction();
        if (string != null) {
            if ("com.google.android.gms.auth.NO_IMPL".equals(string)) {
                this.zbd(12500);
                return;
            }
            if (string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN") || string.equals("com.google.android.gms.auth.APPAUTH_SIGN_IN")) {
                if ((object = object.getBundleExtra("config")) != null) {
                    boolean bl;
                    if ((object = (SignInConfiguration)object.getParcelable("config")) == null) {
                        Log.e((String)"AuthSignInClient", (String)"Activity started with invalid configuration.");
                        this.setResult(0);
                        this.finish();
                        return;
                    }
                    this.zbc = object;
                    if (bundle == null) {
                        if (zba) {
                            this.setResult(0);
                            this.zbd(12502);
                            return;
                        }
                        zba = true;
                        this.zbe(string);
                        return;
                    }
                    this.zbd = bl = bundle.getBoolean("signingInGoogleApiClients");
                    if (bl) {
                        this.zbe = bundle.getInt("signInResultCode");
                        if ((bundle = (Intent)bundle.getParcelable("signInResultData")) == null) {
                            throw null;
                        }
                        this.zbf = bundle;
                        this.zbc();
                        return;
                    }
                    return;
                }
                throw null;
            }
        } else {
            throw null;
        }
        Log.e((String)"AuthSignInClient", (String)"Unknown action: ".concat(String.valueOf(object.getAction())));
        this.finish();
    }

    public final void onDestroy() {
        super.onDestroy();
        zba = false;
    }

    protected final void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("signingInGoogleApiClients", this.zbd);
        if (this.zbd) {
            bundle.putInt("signInResultCode", this.zbe);
            bundle.putParcelable("signInResultData", (Parcelable)this.zbf);
            return;
        }
    }

    public final boolean dispatchPopulateAccessibilityEvent(@NonNull AccessibilityEvent accessibilityEvent) {
        return true;
    }

    static /* bridge */ /* synthetic */ int zba(SignInHubActivity signInHubActivity) {
        return signInHubActivity.zbe;
    }

    static /* bridge */ /* synthetic */ Intent zbb(SignInHubActivity signInHubActivity) {
        return signInHubActivity.zbf;
    }

    private final void zbc() {
        LoaderManager loaderManager = this.getSupportLoaderManager();
        zbw zbw2 = new zbw(this, null);
        loaderManager.initLoader(0, null, (LoaderManager.LoaderCallbacks)zbw2);
        zba = false;
    }

    private final void zbd(int n) {
        Status status = new Status(n);
        Intent intent = new Intent();
        intent.putExtra("googleSignInStatus", (Parcelable)status);
        this.setResult(0, intent);
        this.finish();
        zba = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zbe(String string) {
        Intent intent = new Intent(string);
        if (string.equals("com.google.android.gms.auth.GOOGLE_SIGN_IN")) {
            intent.setPackage("com.google.android.gms");
        } else {
            intent.setPackage(this.getPackageName());
        }
        intent.putExtra("config", (Parcelable)this.zbc);
        try {
            this.startActivityForResult(intent, 40962);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            this.zbb = true;
            Log.w((String)"AuthSignInClient", (String)"Could not launch sign in Intent. Google Play Service is probably being updated...");
            this.zbd(17);
            return;
        }
    }
}

