/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.zbi;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.List;

@SafeParcelable.Class(creator="SaveAccountLinkingTokenRequestCreator")
public class SaveAccountLinkingTokenRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    @NonNull
    public static final String TOKEN_TYPE_AUTH_CODE = "auth_code";
    @NonNull
    public static final String EXTRA_TOKEN = "extra_token";
    @NonNull
    public static final Parcelable.Creator<SaveAccountLinkingTokenRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getConsentPendingIntent")
    private final PendingIntent zba;
    @SafeParcelable.Field(id=2, getter="getTokenType")
    private final String zbb;
    @SafeParcelable.Field(id=3, getter="getServiceId")
    private final String zbc;
    @SafeParcelable.Field(id=4, getter="getScopes")
    private final List zbd;
    @SafeParcelable.Field(id=5, getter="getSessionId")
    @Nullable
    private final String zbe;
    @SafeParcelable.Field(id=6, getter="getTheme")
    private final int zbf;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zba, this.zbb, this.zbc, this.zbd, this.zbe};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public PendingIntent getConsentPendingIntent() {
        return this.zba;
    }

    @NonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    @NonNull
    public String getServiceId() {
        return this.zbc;
    }

    @NonNull
    public String getTokenType() {
        return this.zbb;
    }

    @NonNull
    public List<String> getScopes() {
        return this.zbd;
    }

    static {
        zbi zbi2;
        CREATOR = zbi2 = new zbi();
    }

    @SafeParcelable.Constructor
    SaveAccountLinkingTokenRequest(@SafeParcelable.Param(id=1) PendingIntent pendingIntent, @SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2, @SafeParcelable.Param(id=4) List list, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=6) int n) {
        this.zba = pendingIntent;
        this.zbb = string;
        this.zbc = string2;
        this.zbd = list;
        this.zbe = string3;
        this.zbf = n;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)1, (Parcelable)this.getConsentPendingIntent(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getTokenType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getServiceId(), (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)var1_1, (int)4, this.getScopes(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.zbe, (boolean)false);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)6, (int)this.zbf);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        SaveAccountLinkingTokenRequest saveAccountLinkingTokenRequest;
        if (!(o instanceof SaveAccountLinkingTokenRequest)) {
            return false;
        }
        saveAccountLinkingTokenRequest = saveAccountLinkingTokenRequest;
        if (this.zbd.size() != saveAccountLinkingTokenRequest.zbd.size() || !this.zbd.containsAll(saveAccountLinkingTokenRequest.zbd)) {
            return false;
        }
        return Objects.equal((Object)this.zba, (Object)saveAccountLinkingTokenRequest.zba) && Objects.equal((Object)this.zbb, (Object)saveAccountLinkingTokenRequest.zbb) && Objects.equal((Object)this.zbc, (Object)saveAccountLinkingTokenRequest.zbc) && Objects.equal((Object)this.zbe, (Object)saveAccountLinkingTokenRequest.zbe) && this.zbf == saveAccountLinkingTokenRequest.zbf;
    }

    @NonNull
    public static Builder zba(@NonNull SaveAccountLinkingTokenRequest object) {
        Preconditions.checkNotNull((Object)object);
        Builder builder = SaveAccountLinkingTokenRequest.builder();
        builder.setScopes(object.getScopes());
        builder.setServiceId(object.getServiceId());
        builder.setConsentPendingIntent(object.getConsentPendingIntent());
        builder.setTokenType(object.getTokenType());
        builder.zbb(object.zbf);
        object = object.zbe;
        if (!TextUtils.isEmpty((CharSequence)object)) {
            builder.zba((String)object);
        }
        return builder;
    }

    public static final class Builder {
        private PendingIntent zba;
        private String zbb;
        private String zbc;
        private List zbd;
        private String zbe;
        private int zbf;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setConsentPendingIntent(@NonNull PendingIntent consentPendingIntent) {
            void var1_1;
            this.zba = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setScopes(@NonNull List<String> scopes) {
            void var1_1;
            this.zbd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setServiceId(@NonNull String serviceId) {
            void var1_1;
            this.zbc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTokenType(@NonNull String tokenType) {
            void var1_1;
            this.zbb = var1_1;
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @NonNull
        public SaveAccountLinkingTokenRequest build() {
            boolean bl = this.zba != null;
            Preconditions.checkArgument((boolean)bl, (Object)"Consent PendingIntent cannot be null");
            Preconditions.checkArgument((boolean)SaveAccountLinkingTokenRequest.TOKEN_TYPE_AUTH_CODE.equals(this.zbb), (Object)"Invalid tokenType");
            Preconditions.checkArgument((boolean)(TextUtils.isEmpty((CharSequence)this.zbc) ^ true), (Object)"serviceId cannot be null or empty");
            bl = this.zbd != null;
            Preconditions.checkArgument((boolean)bl, (Object)"scopes cannot be null");
            return new SaveAccountLinkingTokenRequest(this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf);
        }

        public Builder() {
            ArrayList arrayList;
            this.zbd = arrayList = new ArrayList();
        }

        @NonNull
        public final Builder zba(@NonNull String string) {
            this.zbe = string;
            return this;
        }

        @NonNull
        public final Builder zbb(int n) {
            this.zbf = n;
            return this;
        }
    }
}

