/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.zba;
import com.google.android.gms.auth.api.identity.zbg;
import com.google.android.gms.auth.api.identity.zbh;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Class(creator="BeginSignInRequestCreator")
public final class BeginSignInRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<BeginSignInRequest> CREATOR;
    @SafeParcelable.Field(id=1, getter="getPasswordRequestOptions")
    private final PasswordRequestOptions zba;
    @SafeParcelable.Field(id=2, getter="getGoogleIdTokenRequestOptions")
    private final GoogleIdTokenRequestOptions zbb;
    @SafeParcelable.Field(id=3, getter="getSessionId")
    @Nullable
    private final String zbc;
    @SafeParcelable.Field(id=4, getter="isAutoSelectEnabled")
    private final boolean zbd;
    @SafeParcelable.Field(id=5, getter="getTheme")
    private final int zbe;

    public int hashCode() {
        Object[] objectArray = new Object[]{this.zba, this.zbb, this.zbc, this.zbd};
        return Objects.hashCode((Object[])objectArray);
    }

    @NonNull
    public static Builder builder() {
        Builder builder = new Builder();
        return builder;
    }

    @NonNull
    public GoogleIdTokenRequestOptions getGoogleIdTokenRequestOptions() {
        return this.zbb;
    }

    @NonNull
    public PasswordRequestOptions getPasswordRequestOptions() {
        return this.zba;
    }

    static {
        zba zba2;
        CREATOR = zba2 = new zba();
    }

    @SafeParcelable.Constructor
    BeginSignInRequest(@SafeParcelable.Param(id=1) PasswordRequestOptions passwordRequestOptions, @SafeParcelable.Param(id=2) GoogleIdTokenRequestOptions googleIdTokenRequestOptions, @SafeParcelable.Param(id=3) @Nullable String string, @SafeParcelable.Param(id=4) boolean bl, @SafeParcelable.Param(id=5) int n) {
        this.zba = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)passwordRequestOptions)));
        this.zbb = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)googleIdTokenRequestOptions)));
        this.zbc = string;
        this.zbd = bl;
        this.zbe = n;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)1, (Parcelable)this.getPasswordRequestOptions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)2, (Parcelable)this.getGoogleIdTokenRequestOptions(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.zbc, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.isAutoSelectEnabled());
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)5, (int)this.zbe);
        SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
    }

    public boolean equals(@Nullable Object o) {
        BeginSignInRequest beginSignInRequest;
        if (!(o instanceof BeginSignInRequest)) {
            return false;
        }
        beginSignInRequest = beginSignInRequest;
        return Objects.equal((Object)((Object)this.zba), (Object)((Object)beginSignInRequest.zba)) && Objects.equal((Object)((Object)this.zbb), (Object)((Object)beginSignInRequest.zbb)) && Objects.equal((Object)this.zbc, (Object)beginSignInRequest.zbc) && this.zbd == beginSignInRequest.zbd && this.zbe == beginSignInRequest.zbe;
    }

    public boolean isAutoSelectEnabled() {
        return this.zbd;
    }

    @NonNull
    public static Builder zba(@NonNull BeginSignInRequest object) {
        Preconditions.checkNotNull((Object)object);
        Builder builder = BeginSignInRequest.builder();
        builder.setGoogleIdTokenRequestOptions(object.getGoogleIdTokenRequestOptions());
        builder.setPasswordRequestOptions(object.getPasswordRequestOptions());
        builder.setAutoSelectEnabled(object.zbd);
        builder.zbb(object.zbe);
        object = object.zbc;
        if (object != null) {
            builder.zba((String)object);
        }
        return builder;
    }

    public static final class Builder {
        private PasswordRequestOptions zba;
        private GoogleIdTokenRequestOptions zbb;
        @Nullable
        private String zbc;
        private boolean zbd;
        private int zbe;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAutoSelectEnabled(boolean autoSelectEnabled) {
            void var1_1;
            this.zbd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setGoogleIdTokenRequestOptions(@NonNull GoogleIdTokenRequestOptions googleIdTokenRequestOptions) {
            void var1_1;
            this.zbb = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setPasswordRequestOptions(@NonNull PasswordRequestOptions passwordRequestOptions) {
            void var1_1;
            this.zba = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)var1_1));
            return this;
        }

        @NonNull
        public BeginSignInRequest build() {
            BeginSignInRequest beginSignInRequest = new BeginSignInRequest(this.zba, this.zbb, this.zbc, this.zbd, this.zbe);
            return beginSignInRequest;
        }

        public Builder() {
            Object object = PasswordRequestOptions.builder();
            ((PasswordRequestOptions.Builder)object).setSupported(false);
            this.zba = ((PasswordRequestOptions.Builder)object).build();
            object = GoogleIdTokenRequestOptions.builder();
            ((GoogleIdTokenRequestOptions.Builder)object).setSupported(false);
            this.zbb = ((GoogleIdTokenRequestOptions.Builder)object).build();
        }

        @NonNull
        public final Builder zba(@NonNull String string) {
            this.zbc = string;
            return this;
        }

        @NonNull
        public final Builder zbb(int n) {
            this.zbe = n;
            return this;
        }
    }

    @SafeParcelable.Class(creator="PasswordRequestOptionsCreator")
    public static final class PasswordRequestOptions
    extends AbstractSafeParcelable {
        @NonNull
        public static final Parcelable.Creator<PasswordRequestOptions> CREATOR;
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zba;

        public int hashCode() {
            Object[] objectArray = new Object[]{this.zba};
            return Objects.hashCode((Object[])objectArray);
        }

        @NonNull
        public static Builder builder() {
            Builder builder = new Builder();
            return builder;
        }

        static {
            zbh zbh2;
            CREATOR = zbh2 = new zbh();
        }

        @SafeParcelable.Constructor
        PasswordRequestOptions(@SafeParcelable.Param(id=1) boolean bl) {
            this.zba = bl;
        }

        /*
         * WARNING - void declaration
         */
        public void writeToParcel(@NonNull Parcel dest, int n) {
            void var1_1;
            n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)1, (boolean)this.isSupported());
            SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
        }

        public boolean equals(@Nullable Object o) {
            PasswordRequestOptions passwordRequestOptions;
            if (!(o instanceof PasswordRequestOptions)) {
                return false;
            }
            passwordRequestOptions = passwordRequestOptions;
            return this.zba == passwordRequestOptions.zba;
        }

        public boolean isSupported() {
            return this.zba;
        }

        public static final class Builder {
            private boolean zba = false;

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setSupported(boolean supported) {
                void var1_1;
                this.zba = var1_1;
                return this;
            }

            @NonNull
            public PasswordRequestOptions build() {
                PasswordRequestOptions passwordRequestOptions = new PasswordRequestOptions(this.zba);
                return passwordRequestOptions;
            }
        }
    }

    @SafeParcelable.Class(creator="GoogleIdTokenRequestOptionsCreator")
    public static final class GoogleIdTokenRequestOptions
    extends AbstractSafeParcelable {
        @NonNull
        public static final Parcelable.Creator<GoogleIdTokenRequestOptions> CREATOR;
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zba;
        @SafeParcelable.Field(id=2, getter="getServerClientId")
        @Nullable
        private final String zbb;
        @SafeParcelable.Field(id=3, getter="getNonce")
        @Nullable
        private final String zbc;
        @SafeParcelable.Field(id=4, getter="filterByAuthorizedAccounts")
        private final boolean zbd;
        @SafeParcelable.Field(id=5, getter="getLinkedServiceId")
        @Nullable
        private final String zbe;
        @SafeParcelable.Field(id=6, getter="getIdTokenDepositionScopes")
        @Nullable
        private final List zbf;
        @SafeParcelable.Field(id=7, getter="requestVerifiedPhoneNumber")
        private final boolean zbg;

        public int hashCode() {
            Object[] objectArray = new Object[]{this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf, this.zbg};
            return Objects.hashCode((Object[])objectArray);
        }

        @NonNull
        public static Builder builder() {
            Builder builder = new Builder();
            return builder;
        }

        @Nullable
        public String getLinkedServiceId() {
            return this.zbe;
        }

        @Nullable
        public String getNonce() {
            return this.zbc;
        }

        @Nullable
        public String getServerClientId() {
            return this.zbb;
        }

        @Nullable
        public List<String> getIdTokenDepositionScopes() {
            return this.zbf;
        }

        static {
            zbg zbg2;
            CREATOR = zbg2 = new zbg();
        }

        /*
         * Enabled aggressive block sorting
         */
        @SafeParcelable.Constructor
        GoogleIdTokenRequestOptions(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable String string2, @SafeParcelable.Param(id=4) boolean bl2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=6) @Nullable List list, @SafeParcelable.Param(id=7) boolean bl3) {
            ArrayList arrayList;
            boolean bl4 = bl2 ? !bl3 : true;
            Preconditions.checkArgument((boolean)bl4, (Object)"filterByAuthorizedAccounts and requestVerifiedPhoneNumber must not both be true; the Verified Phone Number feature only works in sign-ups.");
            this.zba = bl;
            if (bl) {
                Preconditions.checkNotNull((Object)string, (Object)"serverClientId must be provided if Google ID tokens are requested");
            }
            this.zbb = string;
            this.zbc = string2;
            this.zbd = bl2;
            if (list != null) {
                if (list.isEmpty()) {
                    arrayList = null;
                } else {
                    arrayList = new ArrayList(list);
                    Collections.sort(arrayList);
                }
            } else {
                arrayList = null;
            }
            this.zbf = arrayList;
            this.zbe = string3;
            this.zbg = bl3;
        }

        /*
         * WARNING - void declaration
         */
        public void writeToParcel(@NonNull Parcel dest, int n) {
            void var1_1;
            n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)1, (boolean)this.isSupported());
            SafeParcelWriter.writeString((Parcel)var1_1, (int)2, (String)this.getServerClientId(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getNonce(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)4, (boolean)this.filterByAuthorizedAccounts());
            SafeParcelWriter.writeString((Parcel)var1_1, (int)5, (String)this.getLinkedServiceId(), (boolean)false);
            SafeParcelWriter.writeStringList((Parcel)var1_1, (int)6, this.getIdTokenDepositionScopes(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)var1_1, (int)7, (boolean)this.requestVerifiedPhoneNumber());
            SafeParcelWriter.finishObjectHeader((Parcel)var1_1, (int)n);
        }

        public boolean equals(@Nullable Object o) {
            GoogleIdTokenRequestOptions googleIdTokenRequestOptions;
            if (!(o instanceof GoogleIdTokenRequestOptions)) {
                return false;
            }
            googleIdTokenRequestOptions = googleIdTokenRequestOptions;
            return this.zba == googleIdTokenRequestOptions.zba && Objects.equal((Object)this.zbb, (Object)googleIdTokenRequestOptions.zbb) && Objects.equal((Object)this.zbc, (Object)googleIdTokenRequestOptions.zbc) && this.zbd == googleIdTokenRequestOptions.zbd && Objects.equal((Object)this.zbe, (Object)googleIdTokenRequestOptions.zbe) && Objects.equal((Object)this.zbf, (Object)googleIdTokenRequestOptions.zbf) && this.zbg == googleIdTokenRequestOptions.zbg;
        }

        public boolean filterByAuthorizedAccounts() {
            return this.zbd;
        }

        public boolean isSupported() {
            return this.zba;
        }

        public boolean requestVerifiedPhoneNumber() {
            return this.zbg;
        }

        public static final class Builder {
            private boolean zba = false;
            @Nullable
            private String zbb = null;
            @Nullable
            private String zbc = null;
            private boolean zbd = true;
            @Nullable
            private String zbe = null;
            @Nullable
            private List zbf = null;
            private boolean zbg = false;

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder associateLinkedAccounts(@NonNull String linkedServiceId, @Nullable List<String> idTokenDepositionScopes) {
                void var2_2;
                void var1_1;
                this.zbe = (String)Preconditions.checkNotNull((Object)var1_1, (Object)"linkedServiceId must be provided if you want to associate linked accounts.");
                this.zbf = var2_2;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setFilterByAuthorizedAccounts(boolean filterByAuthorizedAccounts) {
                void var1_1;
                this.zbd = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setNonce(@Nullable String nonce) {
                void var1_1;
                this.zbc = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setRequestVerifiedPhoneNumber(boolean requestVerifiedPhoneNumber) {
                void var1_1;
                this.zbg = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setServerClientId(@NonNull String serverClientId) {
                void var1_1;
                this.zbb = Preconditions.checkNotEmpty((String)var1_1);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @NonNull
            public Builder setSupported(boolean supported) {
                void var1_1;
                this.zba = var1_1;
                return this;
            }

            @NonNull
            public GoogleIdTokenRequestOptions build() {
                GoogleIdTokenRequestOptions googleIdTokenRequestOptions = new GoogleIdTokenRequestOptions(this.zba, this.zbb, this.zbc, this.zbd, this.zbe, this.zbf, this.zbg);
                return googleIdTokenRequestOptions;
            }
        }
    }
}

