/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.auth-api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.BeginSignInRequest;
import com.google.android.gms.auth.api.identity.BeginSignInResult;
import com.google.android.gms.auth.api.identity.GetSignInIntentRequest;
import com.google.android.gms.auth.api.identity.SignInClient;
import com.google.android.gms.auth.api.identity.SignInCredential;
import com.google.android.gms.auth.api.identity.zzl;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.GoogleApiManager;
import com.google.android.gms.common.api.internal.RemoteCall;
import com.google.android.gms.common.api.internal.TaskApiCall;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.internal.auth-api.zzaq;
import com.google.android.gms.internal.auth-api.zzar;
import com.google.android.gms.internal.auth-api.zzas;
import com.google.android.gms.internal.auth-api.zzat;
import com.google.android.gms.internal.auth-api.zzaw;
import com.google.android.gms.internal.auth-api.zzay;
import com.google.android.gms.internal.auth-api.zzba;
import com.google.android.gms.tasks.Task;
import java.util.Iterator;

public final class zzao
extends GoogleApi<zzl>
implements SignInClient {
    private static final Api.ClientKey<zzaw> CLIENT_KEY = new Api.ClientKey();
    private static final Api.AbstractClientBuilder<zzaw, zzl> zzbn = new zzas();
    private static final Api<zzl> API = new Api("Auth.Api.Identity.SignIn.API", zzbn, CLIENT_KEY);

    public zzao(@NonNull Context context, @NonNull zzl zzl2) {
        super(context, API, (Api.ApiOptions)zzl.zzc.zzc(zzl2).zzh(zzba.zzw()).zzk(), GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    public zzao(@NonNull Activity activity, @NonNull zzl zzl2) {
        super(activity, API, (Api.ApiOptions)zzl.zzc.zzc(zzl2).zzh(zzba.zzw()).zzk(), GoogleApi.Settings.DEFAULT_SETTINGS);
    }

    @Override
    public final Task<BeginSignInResult> beginSignIn(@NonNull BeginSignInRequest beginSignInRequest) {
        BeginSignInRequest beginSignInRequest2 = BeginSignInRequest.zzc(beginSignInRequest).zzd(((zzl)this.getApiOptions()).zzh()).build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zzay.zzdc}).run((RemoteCall)new zzar(this, beginSignInRequest2)).setAutoResolveMissingFeatures(false).build());
    }

    @Override
    public final Task<Void> signOut() {
        this.getApplicationContext().getSharedPreferences("com.google.android.gms.signin", 0).edit().clear().apply();
        Iterator iterator = GoogleApiClient.getAllClients().iterator();
        while (iterator.hasNext()) {
            ((GoogleApiClient)iterator.next()).maybeSignOut();
        }
        GoogleApiManager.reportSignOut();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zzay.zzdd}).run((RemoteCall)new zzaq(this)).setAutoResolveMissingFeatures(false).build());
    }

    @Override
    public final SignInCredential getSignInCredentialFromIntent(@Nullable Intent intent) throws ApiException {
        if (intent == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        Status status = (Status)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"status", (Parcelable.Creator)Status.CREATOR);
        if (status == null) {
            throw new ApiException(Status.RESULT_CANCELED);
        }
        if (!status.isSuccess()) {
            throw new ApiException(status);
        }
        SignInCredential signInCredential = (SignInCredential)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"sign_in_credential", SignInCredential.CREATOR);
        if (signInCredential == null) {
            throw new ApiException(Status.RESULT_INTERNAL_ERROR);
        }
        return signInCredential;
    }

    @Override
    public final Task<PendingIntent> getSignInIntent(@NonNull GetSignInIntentRequest getSignInIntentRequest) {
        GetSignInIntentRequest getSignInIntentRequest2 = GetSignInIntentRequest.zzc(getSignInIntentRequest).zzf(((zzl)this.getApiOptions()).zzh()).build();
        return this.doRead(TaskApiCall.builder().setFeatures(new Feature[]{zzay.zzdh}).run((RemoteCall)new zzat(this, getSignInIntentRequest2)).build());
    }
}

