/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.zzg;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="GetSignInIntentRequestCreator")
public class GetSignInIntentRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<GetSignInIntentRequest> CREATOR = new zzg();
    @SafeParcelable.Field(id=1, getter="getServerClientId")
    private final String zzax;
    @SafeParcelable.Field(id=2, getter="getHostedDomainFilter")
    @Nullable
    private final String zzbd;
    @SafeParcelable.Field(id=3, getter="getSessionId")
    @Nullable
    private String zzau;

    public static Builder builder() {
        return new Builder();
    }

    @SafeParcelable.Constructor
    GetSignInIntentRequest(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=2) @Nullable String string2, @SafeParcelable.Param(id=3) @Nullable String string3) {
        Preconditions.checkNotNull((Object)string);
        this.zzax = string;
        this.zzbd = string2;
        this.zzau = string3;
    }

    public String getServerClientId() {
        return this.zzax;
    }

    @Nullable
    public String getHostedDomainFilter() {
        return this.zzbd;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        GetSignInIntentRequest getSignInIntentRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)getSignInIntentRequest.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)getSignInIntentRequest.getHostedDomainFilter(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)getSignInIntentRequest.zzau, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static Builder zzc(GetSignInIntentRequest getSignInIntentRequest) {
        Preconditions.checkNotNull((Object)((Object)getSignInIntentRequest));
        Builder builder = GetSignInIntentRequest.builder().setServerClientId(getSignInIntentRequest.getServerClientId()).filterByHostedDomain(getSignInIntentRequest.getHostedDomainFilter());
        String string = getSignInIntentRequest.zzau;
        if (string != null) {
            builder.zzf(string);
        }
        return builder;
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof GetSignInIntentRequest)) {
            return false;
        }
        GetSignInIntentRequest getSignInIntentRequest = (GetSignInIntentRequest)((Object)object);
        return Objects.equal((Object)this.zzax, (Object)getSignInIntentRequest.zzax) && Objects.equal((Object)this.zzbd, (Object)getSignInIntentRequest.zzbd) && Objects.equal((Object)this.zzau, (Object)getSignInIntentRequest.zzau);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzax, this.zzbd, this.zzau});
    }

    public static final class Builder {
        private String zzax;
        @Nullable
        private String zzbd;
        @Nullable
        private String zzau;

        public final Builder setServerClientId(String string) {
            Preconditions.checkNotNull((Object)string);
            this.zzax = string;
            return this;
        }

        public final Builder filterByHostedDomain(@Nullable String string) {
            this.zzbd = string;
            return this;
        }

        public final Builder zzf(@Nullable String string) {
            this.zzau = string;
            return this;
        }

        public final GetSignInIntentRequest build() {
            return new GetSignInIntentRequest(this.zzax, this.zzbd, this.zzau);
        }
    }
}

