/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.identity;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.auth.api.identity.zzc;
import com.google.android.gms.auth.api.identity.zzh;
import com.google.android.gms.auth.api.identity.zzi;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Class(creator="BeginSignInRequestCreator")
public final class BeginSignInRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<BeginSignInRequest> CREATOR = new zzc();
    @SafeParcelable.Field(id=1, getter="getPasswordRequestOptions")
    private final PasswordRequestOptions zzas;
    @SafeParcelable.Field(id=2, getter="getGoogleIdTokenRequestOptions")
    private final GoogleIdTokenRequestOptions zzat;
    @SafeParcelable.Field(id=3, getter="getSessionId")
    @Nullable
    private final String zzau;
    @SafeParcelable.Field(id=4, getter="isAutoSelectEnabled")
    private final boolean zzav;

    public static Builder builder() {
        return new Builder();
    }

    @SafeParcelable.Constructor
    BeginSignInRequest(@SafeParcelable.Param(id=1) PasswordRequestOptions passwordRequestOptions, @SafeParcelable.Param(id=2) GoogleIdTokenRequestOptions googleIdTokenRequestOptions, @SafeParcelable.Param(id=3) @Nullable String string, @SafeParcelable.Param(id=4) boolean bl) {
        this.zzas = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)passwordRequestOptions)));
        this.zzat = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)googleIdTokenRequestOptions)));
        this.zzau = string;
        this.zzav = bl;
    }

    public final PasswordRequestOptions getPasswordRequestOptions() {
        return this.zzas;
    }

    public final GoogleIdTokenRequestOptions getGoogleIdTokenRequestOptions() {
        return this.zzat;
    }

    public final boolean isAutoSelectEnabled() {
        return this.zzav;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzas, this.zzat, this.zzau, this.zzav});
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof BeginSignInRequest)) {
            return false;
        }
        BeginSignInRequest beginSignInRequest = (BeginSignInRequest)((Object)object);
        return Objects.equal((Object)((Object)this.zzas), (Object)((Object)beginSignInRequest.zzas)) && Objects.equal((Object)((Object)this.zzat), (Object)((Object)beginSignInRequest.zzat)) && Objects.equal((Object)this.zzau, (Object)beginSignInRequest.zzau) && this.zzav == beginSignInRequest.zzav;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        BeginSignInRequest beginSignInRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)beginSignInRequest.getPasswordRequestOptions(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)beginSignInRequest.getGoogleIdTokenRequestOptions(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)beginSignInRequest.zzau, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)beginSignInRequest.isAutoSelectEnabled());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static Builder zzc(BeginSignInRequest beginSignInRequest) {
        Preconditions.checkNotNull((Object)((Object)beginSignInRequest));
        Builder builder = BeginSignInRequest.builder().setGoogleIdTokenRequestOptions(beginSignInRequest.getGoogleIdTokenRequestOptions()).setPasswordRequestOptions(beginSignInRequest.getPasswordRequestOptions()).setAutoSelectEnabled(beginSignInRequest.zzav);
        String string = beginSignInRequest.zzau;
        if (string != null) {
            builder.zzd(string);
        }
        return builder;
    }

    @Nullable
    private static List<String> zzc(@Nullable List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list);
        Collections.sort(arrayList);
        return arrayList;
    }

    @SafeParcelable.Class(creator="GoogleIdTokenRequestOptionsCreator")
    public static final class GoogleIdTokenRequestOptions
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<GoogleIdTokenRequestOptions> CREATOR = new zzh();
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zzaw;
        @SafeParcelable.Field(id=2, getter="getServerClientId")
        @Nullable
        private final String zzax;
        @SafeParcelable.Field(id=3, getter="getNonce")
        @Nullable
        private final String zzay;
        @SafeParcelable.Field(id=4, getter="filterByAuthorizedAccounts")
        private final boolean zzaz;
        @SafeParcelable.Field(id=5, getter="getLinkedServiceId")
        @Nullable
        private final String zzba;
        @SafeParcelable.Field(id=6, getter="getIdTokenDepositionScopes")
        @Nullable
        private final List<String> zzbb;

        public static Builder builder() {
            return new Builder();
        }

        @SafeParcelable.Constructor
        GoogleIdTokenRequestOptions(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable String string2, @SafeParcelable.Param(id=4) boolean bl2, @SafeParcelable.Param(id=5) @Nullable String string3, @SafeParcelable.Param(id=6) @Nullable List<String> list) {
            this.zzaw = bl;
            if (bl) {
                Preconditions.checkNotNull((Object)string, (Object)"serverClientId must be provided if Google ID tokens are requested");
            }
            this.zzax = string;
            this.zzay = string2;
            this.zzaz = bl2;
            this.zzbb = BeginSignInRequest.zzc(list);
            this.zzba = string3;
        }

        public final boolean isSupported() {
            return this.zzaw;
        }

        @Nullable
        public final String getServerClientId() {
            return this.zzax;
        }

        @Nullable
        public final String getNonce() {
            return this.zzay;
        }

        public final boolean filterByAuthorizedAccounts() {
            return this.zzaz;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzaw, this.zzax, this.zzay, this.zzaz, this.zzba, this.zzbb});
        }

        public final boolean equals(@Nullable Object object) {
            if (!(object instanceof GoogleIdTokenRequestOptions)) {
                return false;
            }
            GoogleIdTokenRequestOptions googleIdTokenRequestOptions = (GoogleIdTokenRequestOptions)((Object)object);
            return this.zzaw == googleIdTokenRequestOptions.zzaw && Objects.equal((Object)this.zzax, (Object)googleIdTokenRequestOptions.zzax) && Objects.equal((Object)this.zzay, (Object)googleIdTokenRequestOptions.zzay) && this.zzaz == googleIdTokenRequestOptions.zzaz && Objects.equal((Object)this.zzba, (Object)googleIdTokenRequestOptions.zzba) && Objects.equal(this.zzbb, googleIdTokenRequestOptions.zzbb);
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            GoogleIdTokenRequestOptions googleIdTokenRequestOptions = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)googleIdTokenRequestOptions.isSupported());
            SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)googleIdTokenRequestOptions.getServerClientId(), (boolean)false);
            SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)googleIdTokenRequestOptions.getNonce(), (boolean)false);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)googleIdTokenRequestOptions.filterByAuthorizedAccounts());
            SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)googleIdTokenRequestOptions.zzba, (boolean)false);
            SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, googleIdTokenRequestOptions.zzbb, (boolean)false);
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public static final class Builder {
            private boolean zzaw = false;
            @Nullable
            private String zzax = null;
            @Nullable
            private String zzay = null;
            private boolean zzaz = true;
            @Nullable
            private String zzba = null;
            @Nullable
            private List<String> zzbb = null;

            public final Builder setSupported(boolean bl) {
                this.zzaw = bl;
                return this;
            }

            public final Builder setServerClientId(@NonNull String string) {
                this.zzax = Preconditions.checkNotEmpty((String)string);
                return this;
            }

            public final Builder setNonce(@Nullable String string) {
                this.zzay = string;
                return this;
            }

            public final Builder setFilterByAuthorizedAccounts(boolean bl) {
                this.zzaz = bl;
                return this;
            }

            public final GoogleIdTokenRequestOptions build() {
                return new GoogleIdTokenRequestOptions(this.zzaw, this.zzax, this.zzay, this.zzaz, null, null);
            }
        }
    }

    @SafeParcelable.Class(creator="PasswordRequestOptionsCreator")
    public static final class PasswordRequestOptions
    extends AbstractSafeParcelable {
        public static final Parcelable.Creator<PasswordRequestOptions> CREATOR = new zzi();
        @SafeParcelable.Field(id=1, getter="isSupported")
        private final boolean zzaw;

        public static Builder builder() {
            return new Builder();
        }

        @SafeParcelable.Constructor
        PasswordRequestOptions(@SafeParcelable.Param(id=1) boolean bl) {
            this.zzaw = bl;
        }

        public final boolean isSupported() {
            return this.zzaw;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.zzaw});
        }

        public final boolean equals(@Nullable Object object) {
            if (!(object instanceof PasswordRequestOptions)) {
                return false;
            }
            PasswordRequestOptions passwordRequestOptions = (PasswordRequestOptions)((Object)object);
            return this.zzaw == passwordRequestOptions.zzaw;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            Parcel parcel2 = parcel;
            PasswordRequestOptions passwordRequestOptions = this;
            int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
            SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)passwordRequestOptions.isSupported());
            SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
        }

        public static final class Builder {
            private boolean zzaw = false;

            public final Builder setSupported(boolean bl) {
                this.zzaw = bl;
                return this;
            }

            public final PasswordRequestOptions build() {
                return new PasswordRequestOptions(this.zzaw);
            }
        }
    }

    public static final class Builder {
        private PasswordRequestOptions zzas = PasswordRequestOptions.builder().setSupported(false).build();
        private GoogleIdTokenRequestOptions zzat = GoogleIdTokenRequestOptions.builder().setSupported(false).build();
        @Nullable
        private String zzau;
        private boolean zzav;

        public final Builder setPasswordRequestOptions(@NonNull PasswordRequestOptions passwordRequestOptions) {
            this.zzas = (PasswordRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)passwordRequestOptions)));
            return this;
        }

        public final Builder setGoogleIdTokenRequestOptions(@NonNull GoogleIdTokenRequestOptions googleIdTokenRequestOptions) {
            this.zzat = (GoogleIdTokenRequestOptions)((Object)Preconditions.checkNotNull((Object)((Object)googleIdTokenRequestOptions)));
            return this;
        }

        public final Builder zzd(@NonNull String string) {
            this.zzau = string;
            return this;
        }

        public final Builder setAutoSelectEnabled(boolean bl) {
            this.zzav = bl;
            return this;
        }

        public final BeginSignInRequest build() {
            return new BeginSignInRequest(this.zzas, this.zzat, this.zzau, this.zzav);
        }
    }
}

