/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.graphics.Point;
import android.media.MediaCodecInfo;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaf;
import com.google.android.gms.internal.ads.zzbt;
import com.google.android.gms.internal.ads.zzee;
import com.google.android.gms.internal.ads.zzew;
import com.google.android.gms.internal.ads.zzhc;
import com.google.android.gms.internal.ads.zzqw;
import com.google.android.gms.internal.ads.zzrj;
import com.google.android.gms.internal.ads.zzrp;

public final class zzqx {
    public final String zza;
    public final String zzb;
    public final String zzc;
    @Nullable
    public final MediaCodecInfo.CodecCapabilities zzd;
    public final boolean zze;
    public final boolean zzf;
    public final boolean zzg;
    private final boolean zzh;

    @Nullable
    @RequiresApi(value=21)
    public final Point zza(int n, int n2) {
        zzqx zzqx2 = zzqx2.zzd;
        if (zzqx2 == null) {
            return null;
        }
        if ((zzqx2 = zzqx2.getVideoCapabilities()) == null) {
            return null;
        }
        return zzqx.zzi((MediaCodecInfo.VideoCapabilities)zzqx2, n, n2);
    }

    @RequiresApi(value=21)
    private static Point zzi(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2) {
        int n3 = videoCapabilities.getWidthAlignment();
        int n4 = videoCapabilities.getHeightAlignment();
        return new Point(zzew.zze(n, n3) * n3, zzew.zze(n2, n4) * n4);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzhc zzb(zzaf zzaf2, zzaf zzaf3) {
        String string2;
        String string3;
        int n = true != zzew.zzU(zzaf2.zzm, zzaf3.zzm) ? 8 : 0;
        if (this.zzh) {
            if (zzaf2.zzu != zzaf3.zzu) {
                n |= 0x400;
            }
            if (!(this.zze || zzaf2.zzr == zzaf3.zzr && zzaf2.zzs == zzaf3.zzs)) {
                n |= 0x200;
            }
            if (!zzew.zzU(zzaf2.zzy, zzaf3.zzy)) {
                n |= 0x800;
            }
            String string4 = this.zza;
            if (zzew.zzd.startsWith("SM-T230") && "OMX.MARVELL.VIDEO.HW.CODA7542DECODER".equals(string4) && !zzaf2.zze(zzaf3)) {
                n |= 2;
            }
            if (n != 0) return new zzhc(this.zza, zzaf2, zzaf3, 0, n);
            string4 = this.zza;
            int n2 = true != zzaf2.zze(zzaf3) ? 2 : 3;
            return new zzhc(string4, zzaf2, zzaf3, n2, 0);
        }
        if (zzaf2.zzz != zzaf3.zzz) {
            n |= 0x1000;
        }
        if (zzaf2.zzA != zzaf3.zzA) {
            n |= 0x2000;
        }
        if (zzaf2.zzB != zzaf3.zzB) {
            n |= 0x4000;
        }
        if (n == 0 && "audio/mp4a-latm".equals(string3 = this.zzb)) {
            string3 = zzrp.zzb(zzaf2);
            Pair pair = zzrp.zzb(zzaf3);
            if (string3 != null && pair != null) {
                int n3 = (Integer)pair.first;
                if ((Integer)((Pair)string3).first == 42 && n3 == 42) {
                    return new zzhc(this.zza, zzaf2, zzaf3, 3, 0);
                }
            }
        }
        if (!zzaf2.zze(zzaf3)) {
            n |= 0x20;
        }
        if ("audio/opus".equals(string2 = this.zzb)) {
            n |= 2;
        }
        if (n == 0) return new zzhc(this.zza, zzaf2, zzaf3, 1, 0);
        return new zzhc(this.zza, zzaf2, zzaf3, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzqx zzc(String string2, String string3, String string4, @Nullable MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        bl4 = codecCapabilities != null ? (codecCapabilities.isFeatureSupported("adaptive-playback") ? (zzew.zza <= 22 ? ("ODROID-XU3".equals(zzew.zzd) || "Nexus 10".equals(zzew.zzd) ? (!"OMX.Exynos.AVC.Decoder".equals(string2) ? !"OMX.Exynos.AVC.Decoder.secure".equals(string2) : false) : true) : true) : false) : false;
        boolean bl6 = codecCapabilities != null ? (zzew.zza >= 21 ? codecCapabilities.isFeatureSupported("tunneled-playback") : false) : false;
        bl5 = !bl5 ? (codecCapabilities != null ? (zzew.zza >= 21 ? codecCapabilities.isFeatureSupported("secure-playback") : false) : false) : true;
        return new zzqx(string2, string3, string4, codecCapabilities, bl, bl2, bl3, bl4, bl6, bl5);
    }

    public final String toString() {
        return this.zza;
    }

    @VisibleForTesting
    zzqx(String string2, String string3, String string4, @Nullable MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        if (string2 == null) {
            throw null;
        }
        this.zza = string2;
        this.zzb = string3;
        this.zzc = string4;
        this.zzd = codecCapabilities;
        this.zzg = bl;
        this.zze = bl4;
        this.zzf = bl6;
        this.zzh = zzbt.zzh(string3);
    }

    private final void zzj(String string2) {
        String string3 = ((zzqx)object).zza;
        Object object = ((zzqx)object).zzb;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NoSupport [");
        stringBuilder.append(string2);
        stringBuilder.append("] [");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append((String)object);
        stringBuilder.append("] [");
        stringBuilder.append(zzew.zze);
        stringBuilder.append("]");
        object = stringBuilder.toString();
        zzee.zza("MediaCodecInfo", (String)object);
    }

    @RequiresApi(value=21)
    private static boolean zzk(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2, double d) {
        Point point = zzqx.zzi(videoCapabilities, n, n2);
        n = point.x;
        n2 = point.y;
        if (d == -1.0 || d < 1.0) {
            return videoCapabilities.isSizeSupported(n, n2);
        }
        return videoCapabilities.areSizeAndRateSupported(n, n2, Math.floor(d));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final boolean zzl(zzaf object, boolean bl) {
        void var5_17;
        String string2;
        int n;
        int n2;
        block33: {
            block35: {
                Pair pair = zzrp.zzb((zzaf)object);
                if (pair == null) {
                    return true;
                }
                n2 = (Integer)pair.first;
                n = (Integer)pair.second;
                String string3 = ((zzaf)object).zzm;
                if (!"video/dolby-vision".equals(string3)) break block35;
                String string4 = this.zzb;
                if ("video/avc".equals(string4)) {
                    n = 8;
                    n2 = 0;
                    break block33;
                } else {
                    String string5 = this.zzb;
                    if ("video/hevc".equals(string5)) {
                        n = 2;
                        n2 = 0;
                        break block33;
                    } else {
                        int n3 = n;
                        n = n2;
                        n2 = n3;
                    }
                }
                break block33;
            }
            int n4 = n;
            n = n2;
            n2 = n4;
        }
        if (!this.zzh && n != 42) {
            return true;
        }
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = this.zzh();
        if (zzew.zza <= 23 && "video/x-vnd.on2.vp9".equals(string2 = this.zzb) && codecProfileLevelArray.length == 0) {
            void var5_15;
            void var5_13;
            MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
            if (codecCapabilities != null) {
                MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
                if (videoCapabilities != null) {
                    int n5 = (Integer)videoCapabilities.getBitrateRange().getUpper();
                } else {
                    boolean bl2 = false;
                }
            } else {
                boolean bl3 = false;
            }
            if (var5_13 >= 180000000) {
                int n6 = 1024;
            } else if (var5_13 >= 120000000) {
                int n7 = 512;
            } else if (var5_13 >= 60000000) {
                int n8 = 256;
            } else if (var5_13 >= 30000000) {
                int n9 = 128;
            } else if (var5_13 >= 18000000) {
                int n10 = 64;
            } else if (var5_13 >= 12000000) {
                int n11 = 32;
            } else if (var5_13 >= 0x6DDD00) {
                int n12 = 16;
            } else if (var5_13 >= 3600000) {
                int n13 = 8;
            } else if (var5_13 >= 1800000) {
                int n14 = 4;
            } else if (var5_13 >= 800000) {
                int n15 = 2;
            } else {
                boolean bl4 = true;
            }
            string2 = new MediaCodecInfo.CodecProfileLevel();
            ((MediaCodecInfo.CodecProfileLevel)string2).profile = 1;
            ((MediaCodecInfo.CodecProfileLevel)string2).level = var5_15;
            MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray2 = new MediaCodecInfo.CodecProfileLevel[]{string2};
        }
        int n16 = ((void)var5_17).length;
        int n17 = 0;
        while (true) {
            String string6;
            if (n17 >= n16) {
                object = ((zzaf)object).zzj;
                zzqx zzqx2 = this;
                String string7 = zzqx2.zzc;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("codec.profileLevel, ");
                stringBuilder.append((String)object);
                stringBuilder.append(", ");
                stringBuilder.append(string7);
                zzqx2.zzj(stringBuilder.toString());
                return false;
            }
            void var8_35 = var5_17[n17];
            if (var8_35.profile == n && (var8_35.level >= n2 || !bl) && (!"video/hevc".equals(string6 = this.zzb) || n != 2 || !"sailfish".equals(zzew.zzb) && !"marlin".equals(zzew.zzb))) break;
            ++n17;
        }
        return true;
    }

    public final boolean zzd(zzaf zzaf2) {
        return this.zzm(zzaf2) && this.zzl(zzaf2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean zze(zzaf zzaf2) throws zzrj {
        int n;
        int n2;
        block17: {
            int n3;
            block18: {
                block20: {
                    block21: {
                        block22: {
                            block23: {
                                block24: {
                                    block25: {
                                        block26: {
                                            block27: {
                                                block28: {
                                                    String string2;
                                                    String string3;
                                                    block19: {
                                                        if (!this.zzm(zzaf2)) {
                                                            return false;
                                                        }
                                                        if (!this.zzl(zzaf2, true)) {
                                                            return false;
                                                        }
                                                        if (this.zzh) {
                                                            if (zzaf2.zzr <= 0) return true;
                                                            if (zzaf2.zzs <= 0) {
                                                                return true;
                                                            }
                                                            if (zzew.zza >= 21) {
                                                                return this.zzg(zzaf2.zzr, zzaf2.zzs, zzaf2.zzt);
                                                            }
                                                            boolean bl = zzaf2.zzr * zzaf2.zzs <= zzrp.zza();
                                                            if (bl) return bl;
                                                            int n4 = zzaf2.zzr;
                                                            int n5 = zzaf2.zzs;
                                                            StringBuilder stringBuilder = new StringBuilder();
                                                            stringBuilder.append("legacyFrameSize, ");
                                                            stringBuilder.append(n4);
                                                            stringBuilder.append("x");
                                                            stringBuilder.append(n5);
                                                            this.zzj(stringBuilder.toString());
                                                            return bl;
                                                        }
                                                        if (zzew.zza < 21) {
                                                            return true;
                                                        }
                                                        n2 = zzaf2.zzA;
                                                        if (n2 != -1) {
                                                            MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
                                                            if (codecCapabilities == null) {
                                                                this.zzj("sampleRate.caps");
                                                                return false;
                                                            }
                                                            MediaCodecInfo.AudioCapabilities audioCapabilities = codecCapabilities.getAudioCapabilities();
                                                            if (audioCapabilities == null) {
                                                                this.zzj("sampleRate.aCaps");
                                                                return false;
                                                            }
                                                            if (!audioCapabilities.isSampleRateSupported(n2)) {
                                                                StringBuilder stringBuilder = new StringBuilder();
                                                                stringBuilder.append("sampleRate.support, ");
                                                                stringBuilder.append(n2);
                                                                this.zzj(stringBuilder.toString());
                                                                return false;
                                                            }
                                                        }
                                                        if ((n2 = zzaf2.zzz) == -1) {
                                                            return true;
                                                        }
                                                        zzaf2 = this.zzd;
                                                        if (zzaf2 == null) {
                                                            this.zzj("channelCount.caps");
                                                            return false;
                                                        }
                                                        if ((zzaf2 = zzaf2.getAudioCapabilities()) == null) {
                                                            this.zzj("channelCount.aCaps");
                                                            return false;
                                                        }
                                                        string3 = this.zza;
                                                        string2 = this.zzb;
                                                        n3 = zzaf2.getMaxInputChannelCount();
                                                        if (n3 > 1) break block18;
                                                        if (zzew.zza < 26 || n3 <= 0) break block19;
                                                        n = n3;
                                                        break block17;
                                                    }
                                                    if ("audio/mpeg".equals(string2)) break block20;
                                                    if ("audio/3gpp".equals(string2)) break block21;
                                                    if ("audio/amr-wb".equals(string2)) break block22;
                                                    if ("audio/mp4a-latm".equals(string2)) break block23;
                                                    if ("audio/vorbis".equals(string2)) break block24;
                                                    if ("audio/opus".equals(string2)) break block25;
                                                    if ("audio/raw".equals(string2)) break block26;
                                                    if ("audio/flac".equals(string2)) break block27;
                                                    if ("audio/g711-alaw".equals(string2)) break block28;
                                                    if (!"audio/g711-mlaw".equals(string2)) {
                                                        if ("audio/gsm".equals(string2)) {
                                                            n = n3;
                                                            break block17;
                                                        } else {
                                                            n = "audio/ac3".equals(string2) ? 6 : ("audio/eac3".equals(string2) ? 16 : 30);
                                                            StringBuilder stringBuilder = new StringBuilder();
                                                            stringBuilder.append("AssumedMaxChannelAdjustment: ");
                                                            stringBuilder.append(string3);
                                                            stringBuilder.append(", [");
                                                            stringBuilder.append(n3);
                                                            stringBuilder.append(" to ");
                                                            stringBuilder.append(n);
                                                            stringBuilder.append("]");
                                                            String string4 = stringBuilder.toString();
                                                            zzee.zze("MediaCodecInfo", string4);
                                                        }
                                                        break block17;
                                                    } else {
                                                        n = n3;
                                                    }
                                                    break block17;
                                                }
                                                n = n3;
                                                break block17;
                                            }
                                            n = n3;
                                            break block17;
                                        }
                                        n = n3;
                                        break block17;
                                    }
                                    n = n3;
                                    break block17;
                                }
                                n = n3;
                                break block17;
                            }
                            n = n3;
                            break block17;
                        }
                        n = n3;
                        break block17;
                    }
                    n = n3;
                    break block17;
                }
                n = n3;
                break block17;
            }
            n = n3;
        }
        if (n >= n2) return true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("channelCount.support, ");
        stringBuilder.append(n2);
        this.zzj(stringBuilder.toString());
        return false;
    }

    private final boolean zzm(zzaf zzaf2) {
        return this.zzb.equals(zzaf2.zzm) || this.zzb.equals(zzrp.zze(zzaf2));
    }

    public final boolean zzf(zzaf zzaf2) {
        if (zzqx2.zzh) {
            return zzqx2.zze;
        }
        zzqx zzqx2 = zzrp.zzb(zzaf2);
        return zzqx2 != null && (Integer)((Pair)zzqx2).first == 42;
    }

    @RequiresApi(value=21)
    public final boolean zzg(int n, int n2, double d) {
        block9: {
            MediaCodecInfo.CodecCapabilities codecCapabilities;
            block8: {
                codecCapabilities = ((zzqx)object).zzd;
                if (codecCapabilities == null) {
                    ((zzqx)object).zzj("sizeAndRate.caps");
                    return false;
                }
                if ((codecCapabilities = codecCapabilities.getVideoCapabilities()) == null) {
                    ((zzqx)object).zzj("sizeAndRate.vCaps");
                    return false;
                }
                if (zzew.zza < 29) break block8;
                int n3 = zzqw.zza((MediaCodecInfo.VideoCapabilities)codecCapabilities, n, n2, d);
                if (n3 == 2) {
                    return true;
                }
                if (n3 == 1) break block9;
            }
            if (!zzqx.zzk((MediaCodecInfo.VideoCapabilities)codecCapabilities, n, n2, d)) {
                String string2;
                if (n >= n2 || "OMX.MTK.VIDEO.DECODER.HEVC".equals(string2 = ((zzqx)object).zza) && "mcv5a".equals(zzew.zzb) || !zzqx.zzk((MediaCodecInfo.VideoCapabilities)codecCapabilities, n2, n, d)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("sizeAndRate.support, ");
                    stringBuilder.append(n);
                    stringBuilder.append("x");
                    stringBuilder.append(n2);
                    stringBuilder.append("@");
                    stringBuilder.append(d);
                    ((zzqx)object).zzj(stringBuilder.toString());
                    return false;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("sizeAndRate.rotated, ");
                stringBuilder.append(n);
                stringBuilder.append("x");
                stringBuilder.append(n2);
                stringBuilder.append("@");
                stringBuilder.append(d);
                String string3 = stringBuilder.toString();
                String string4 = ((zzqx)object).zza;
                Object object = ((zzqx)object).zzb;
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append("AssumedSupport [");
                stringBuilder2.append(string3);
                stringBuilder2.append("] [");
                stringBuilder2.append(string4);
                stringBuilder2.append(", ");
                stringBuilder2.append((String)object);
                stringBuilder2.append("] [");
                stringBuilder2.append(zzew.zze);
                stringBuilder2.append("]");
                object = stringBuilder2.toString();
                zzee.zza("MediaCodecInfo", (String)object);
            }
            return true;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("sizeAndRate.cover, ");
        stringBuilder.append(n);
        stringBuilder.append("x");
        stringBuilder.append(n2);
        stringBuilder.append("@");
        stringBuilder.append(d);
        ((zzqx)object).zzj(stringBuilder.toString());
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final MediaCodecInfo.CodecProfileLevel[] zzh() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzd;
        if (codecCapabilities == null) return new MediaCodecInfo.CodecProfileLevel[0];
        if (codecCapabilities.profileLevels != null) return this.zzd.profileLevels;
        return new MediaCodecInfo.CodecProfileLevel[0];
    }
}

