/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzfvu;
import com.google.android.gms.internal.ads.zzgas;
import com.google.android.gms.internal.ads.zzggg;
import com.google.android.gms.internal.ads.zzgmv;
import com.google.android.gms.internal.ads.zzgnn;
import com.google.android.gms.internal.ads.zzgnz;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class zzgmu
implements zzfvu {
    private static final Collection zza = Arrays.asList(64);
    private static final byte[] zzb = new byte[16];
    private final zzgnz zzc;
    private final byte[] zzd;

    public zzgmu(byte[] byArray) throws GeneralSecurityException {
        if (!zzgas.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-SIV in FIPS-mode.");
        }
        int n = byArray.length;
        if (!zza.contains(n)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("invalid key size: ");
            stringBuilder.append(n);
            stringBuilder.append(" bytes; key must have 64 bytes");
            throw new InvalidKeyException(stringBuilder.toString());
        }
        int n2 = n >> 1;
        byArray = Arrays.copyOfRange(byArray, 0, n2);
        this.zzd = Arrays.copyOfRange(byArray, n2, n);
        this.zzc = new zzgnz(byArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byArray.length > 0x7FFFFFEF) {
            throw new GeneralSecurityException("plaintext too long");
        }
        Cipher cipher = (Cipher)zzgnn.zza.zza("AES/CTR/NoPadding");
        byte[][] byArrayArray = new byte[][]{byArray2, byArray};
        byArray2 = this.zzc.zza(zzb, 16);
        for (int i = 0; i <= 0; ++i) {
            byte[] byArray3 = byArrayArray[i];
            if (byArray3 == null) {
                byArray3 = new byte[]{};
            }
            byArray2 = zzgmv.zzc(zzggg.zzb(byArray2), this.zzc.zza(byArray3, 16));
        }
        byte[] byArray4 = byArrayArray[1];
        int n = byArray4.length;
        if (n >= 16) {
            int n2 = byArray2.length;
            if (n < n2) {
                throw new IllegalArgumentException("xorEnd requires a.length >= b.length");
            }
            byte[] byArray5 = Arrays.copyOf(byArray4, n);
            for (int i = 0; i < byArray2.length; ++i) {
                int n3 = n - n2 + i;
                byArray5[n3] = (byte)(byArray5[n3] ^ byArray2[i]);
            }
            byArray2 = byArray5;
        } else {
            byArray2 = zzgmv.zzc(zzggg.zza(byArray4), zzggg.zzb(byArray2));
        }
        byArray2 = this.zzc.zza(byArray2, 16);
        byte[] byArray6 = (byte[])byArray2.clone();
        byArray6[8] = (byte)(byArray6[8] & 0x7F);
        byArray6[12] = (byte)(byArray6[12] & 0x7F);
        cipher.init(1, (Key)new SecretKeySpec(this.zzd, "AES"), new IvParameterSpec(byArray6));
        return zzgmv.zzb(byArray2, cipher.doFinal(byArray));
    }
}

