/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgak;
import com.google.android.gms.internal.ads.zzgap;
import com.google.android.gms.internal.ads.zzgas;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import javax.crypto.AEADBadTagException;

abstract class zzgam {
    private final zzgak zza;
    private final zzgak zzb;

    abstract zzgak zza(byte[] var1, int var2) throws InvalidKeyException;

    public zzgam(byte[] byArray) throws GeneralSecurityException {
        if (!zzgas.zza(1)) {
            throw new GeneralSecurityException("Can not use ChaCha20Poly1305 in FIPS-mode.");
        }
        this.zza = this.zza(byArray, 1);
        this.zzb = this.zza(byArray, 0);
    }

    public final void zzb(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        if (byteBuffer.remaining() < byArray2.length + 16) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        this.zza.zzd(byteBuffer2, byArray, byArray2);
        byteBuffer2.position(byteBuffer.position());
        ByteBuffer byteBuffer3 = byteBuffer;
        byteBuffer3.limit(byteBuffer3.limit() + -16);
        ByteBuffer byteBuffer4 = byteBuffer;
        byteBuffer4.limit(byteBuffer4.limit() + 16);
        byteBuffer4.put(zzgap.zza(this.zze(byArray), zzgam.zzf(byArray3, byteBuffer)));
    }

    public final byte[] zzc(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        int n;
        block5: {
            if (byteBuffer.remaining() < 16) {
                throw new GeneralSecurityException("ciphertext too short");
            }
            n = byteBuffer.position();
            byte[] byArray3 = new byte[16];
            ByteBuffer byteBuffer2 = byteBuffer;
            byteBuffer2.position(byteBuffer2.limit() + -16);
            byteBuffer.get(byArray3);
            byteBuffer.position(n);
            ByteBuffer byteBuffer3 = byteBuffer;
            byteBuffer3.limit(byteBuffer3.limit() + -16);
            if (byArray2 == null) {
                byArray2 = new byte[]{};
            }
            try {
                byte[] byArray4 = this.zze(byArray);
                byArray2 = zzgam.zzf(byArray2, byteBuffer);
                boolean bl = MessageDigest.isEqual(zzgap.zza(byArray4, byArray2), byArray3);
                if (bl) break block5;
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new AEADBadTagException(generalSecurityException.toString());
            }
            throw new GeneralSecurityException("invalid MAC");
        }
        byteBuffer.position(n);
        return this.zza.zze(byArray, byteBuffer);
    }

    public final byte[] zzd(byte[] byArray, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        int n = byArray2.length;
        if (n > 0x7FFFFFEF) {
            throw new GeneralSecurityException("plaintext too long");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n + 16);
        this.zzb(byteBuffer, byArray, byArray2, byArray3);
        return byteBuffer.array();
    }

    private final byte[] zze(byte[] byArray) throws GeneralSecurityException {
        byte[] byArray2 = new byte[32];
        this.zzb.zzc(byArray, 0).get(byArray2);
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static byte[] zzf(byte[] byArray, ByteBuffer byteBuffer) {
        int n = byArray.length;
        int n2 = n & 0xF;
        n2 = n2 == 0 ? n : n + 16 - n2;
        int n3 = byteBuffer.remaining();
        int n4 = n3 % 16;
        n4 = n4 == 0 ? n3 : n3 + 16 - n4;
        int n5 = n2 + n4;
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(n5 + 16).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer2.put(byArray);
        byteBuffer2.position(n2);
        byteBuffer2.put(byteBuffer);
        byteBuffer2.position(n5);
        byteBuffer2.putLong(n);
        byteBuffer2.putLong(n3);
        return byteBuffer2.array();
    }
}

