/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.app.UiModeManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Point;
import android.hardware.display.DisplayManager;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.SystemClock;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.internal.ads.zzad;
import com.google.android.gms.internal.ads.zzaf;
import com.google.android.gms.internal.ads.zzca;
import com.google.android.gms.internal.ads.zzcc;
import com.google.android.gms.internal.ads.zzcg;
import com.google.android.gms.internal.ads.zzdl;
import com.google.android.gms.internal.ads.zzee;
import com.google.android.gms.internal.ads.zzev;
import com.google.android.gms.internal.ads.zzfnb;
import com.google.android.gms.internal.ads.zzfnh;
import com.google.android.gms.internal.ads.zzm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzew {
    public static final int zza = Build.VERSION.SDK_INT;
    public static final String zzb = Build.DEVICE;
    public static final String zzc = Build.MANUFACTURER;
    public static final String zzd = Build.MODEL;
    public static final String zze;
    public static final byte[] zzf;
    private static final Pattern zzg;
    private static final Pattern zzh;
    private static final Pattern zzi;
    private static final Pattern zzj;
    @Nullable
    private static HashMap zzk;
    private static final String[] zzl;
    private static final String[] zzm;
    private static final int[] zzn;
    private static final int[] zzo;

    public static float zza(float f, float f2, float f3) {
        return Math.max(f2, Math.min(f, f3));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zzb(long[] lArray, long l, boolean bl, boolean n) {
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            return ~n;
        }
        while (++n < lArray.length && lArray[n] == l) {
        }
        if (bl) return n + -1;
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzc(int[] nArray, int n, boolean bl, boolean bl2) {
        int n2;
        int n3 = Arrays.binarySearch(nArray, n);
        if (n3 < 0) {
            n2 = -(n3 + 2);
        } else {
            while (--n3 >= 0 && nArray[n3] == n) {
            }
            n2 = bl ? n3 + 1 : n3;
        }
        if (bl2) {
            return Math.max(0, n2);
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzd(long[] lArray, long l, boolean n, boolean bl) {
        int n2;
        n = Arrays.binarySearch(lArray, l);
        if (n < 0) {
            n2 = -(n + 2);
        } else {
            while (--n >= 0 && lArray[n] == l) {
            }
            n2 = n + 1;
        }
        if (bl) {
            return Math.max(0, n2);
        }
        return n2;
    }

    public static int zze(int n, int n2) {
        return (n + n2 + -1) / n2;
    }

    public static int zzf(int n, int n2, int n3) {
        return Math.max(n2, Math.min(n, n3));
    }

    public static int zzg(byte[] byArray, int n, int n2, int n3) {
        n = -1;
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = n << 8;
            n >>>= 24;
            n = n4 ^ zzn[n ^ byArray[n3] & 0xFF];
        }
        return n;
    }

    public static int zzh(byte[] byArray, int n, int n2, int n3) {
        int n4 = n;
        n = 0;
        for (n3 = v812275; n3 < n2; ++n3) {
            n = zzo[n ^ byArray[n3] & 0xFF];
        }
        return n;
    }

    @RequiresApi(value=21)
    public static int zzi(Context context) {
        if ((context = (AudioManager)context.getSystemService("audio")) == null) {
            return -1;
        }
        return context.generateAudioSessionId();
    }

    @SuppressLint(value={"InlinedApi"})
    public static int zzj(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 12: {
                return 743676;
            }
            case 8: {
                return 6396;
            }
            case 7: {
                return 1276;
            }
            case 6: {
                return 252;
            }
            case 5: {
                return 220;
            }
            case 4: {
                return 204;
            }
            case 3: {
                return 28;
            }
            case 2: {
                return 12;
            }
            case 1: 
        }
        return 4;
    }

    public static int zzk(ByteBuffer byteBuffer, int n) {
        n = byteBuffer.getInt(n);
        if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            return n;
        }
        return Integer.reverseBytes(n);
    }

    public static int zzl(int n) {
        switch (n) {
            default: {
                return 6006;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return 6002;
            }
            case 10: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return 6004;
            }
            case 8: 
            case 15: {
                return 6003;
            }
            case 2: 
            case 4: 
            case 7: 
            case 16: 
            case 18: 
        }
        return 6005;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static int zzm(@Nullable String var0) {
        block9: {
            block7: {
                block8: {
                    if (var0 == null) {
                        return 0;
                    }
                    var1_2 = ((String[])(var0 = var0.split("_", -1))).length;
                    if (var1_2 < 2) {
                        return 0;
                    }
                    var2_3 = var0[var1_2 + -1];
                    if (var1_2 < 3) break block7;
                    if (!"neg".equals(var0 = var0[var1_2 + -2])) break block8;
                    var0_1 = true;
lbl10:
                    // 3 sources

                    while (var2_3 != null) {
                        block6: {
                            var1_2 = Integer.parseInt(var2_3);
                            if (!var0_1) break block6;
                            return -var1_2;
                        }
                        return var1_2;
                    }
                    break block9;
                }
                var0_1 = false;
                ** GOTO lbl10
            }
            var0_1 = false;
            ** GOTO lbl10
        }
        try {
            throw null;
        }
        catch (NumberFormatException v0) {
            return 0;
        }
    }

    public static int zzn(int n) {
        switch (n) {
            default: {
                return 0;
            }
            case 32: {
                return 0x30000000;
            }
            case 24: {
                return 0x20000000;
            }
            case 16: {
                return 2;
            }
            case 8: 
        }
        return 3;
    }

    public static int zzo(int n, int n2) {
        switch (n) {
            default: {
                throw new IllegalArgumentException();
            }
            case 0x20000000: {
                return n2 * 3;
            }
            case 4: 
            case 0x30000000: {
                return n2 * 4;
            }
            case 3: {
                return n2;
            }
            case 2: 
            case 0x10000000: 
        }
        int n3 = n2;
        return n3 + n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int zzp(Uri object) {
        block16: {
            int n;
            block17: {
                String string2 = object.getScheme();
                if (string2 != null && zzfnb.zzc((CharSequence)"rtsp", (CharSequence)string2)) {
                    return 3;
                }
                string2 = object.getLastPathSegment();
                if (string2 == null) {
                    return 4;
                }
                int n2 = string2.lastIndexOf(46);
                if (n2 < 0) break block16;
                string2 = zzfnb.zza((String)string2.substring(n2 + 1));
                switch (string2.hashCode()) {
                    case 3299913: {
                        if (!string2.equals("m3u8")) break;
                        n = 1;
                        break block17;
                    }
                    case 3242057: {
                        if (!string2.equals("isml")) break;
                        n = 3;
                        break block17;
                    }
                    case 108321: {
                        if (!string2.equals("mpd")) break;
                        n = 0;
                        break block17;
                    }
                    case 104579: {
                        if (!string2.equals("ism")) break;
                        n = 2;
                        break block17;
                    }
                }
                n = -1;
            }
            switch (n) {
                default: {
                    n = 4;
                    break;
                }
                case 2: 
                case 3: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
                case 0: {
                    return 0;
                }
            }
            if (n != 4) {
                return n;
            }
        }
        Pattern pattern = zzj;
        if ((object = object.getPath()) == null) throw null;
        if (!((Matcher)(object = pattern.matcher((CharSequence)object))).matches()) {
            return 4;
        }
        if ((object = ((Matcher)object).group(2)) == null) return 1;
        if (((String)object).contains("format=mpd-time-csf")) {
            return 0;
        }
        if (!((String)object).contains("format=m3u8-aapl")) return 1;
        return 2;
    }

    public static long zzq(long l, long l2, long l3) {
        long l4 = l + l2;
        if (((l ^ l4) & (l2 ^ l4)) < 0L) {
            return Long.MAX_VALUE;
        }
        return l4;
    }

    public static long zzr(long l, long l2, long l3) {
        return Math.max(l2, Math.min(l, l3));
    }

    public static long zzs(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l * (double)f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long zzt(long l) {
        if (l != -9223372036854775807L) return SystemClock.elapsedRealtime() + l;
        return System.currentTimeMillis();
    }

    public static long zzu(long l, float f) {
        if (f == 1.0f) {
            return l;
        }
        return Math.round((double)l / (double)f);
    }

    public static long zzv(long l) {
        if (l == -9223372036854775807L || l == Long.MIN_VALUE) {
            return l;
        }
        return l * 1000L;
    }

    public static long zzw(long l, long l2, long l3) {
        if (l3 < l2 || l3 % l2 != 0L) {
            if (l3 < l2 && l2 % l3 == 0L) {
                return l * (l2 / l3);
            }
            double d = l2;
            double d2 = l3;
            return (long)((double)l * (d / d2));
        }
        return l / (l3 / l2);
    }

    public static long zzx(long l, long l2, long l3) {
        long l4 = l - l2;
        if (((l ^ l2) & (l ^ l4)) < 0L) {
            return Long.MIN_VALUE;
        }
        return l4;
    }

    public static long zzy(int n, int n2) {
        long l = n2;
        return ((long)n & 0xFFFFFFFFL) << 32 | l & 0xFFFFFFFFL;
    }

    public static long zzz(long l) {
        if (l == -9223372036854775807L || l == Long.MIN_VALUE) {
            return l;
        }
        return l / 1000L;
    }

    @Nullable
    public static Intent zzA(Context context, @Nullable BroadcastReceiver broadcastReceiver, IntentFilter intentFilter) {
        if (zza < 33) {
            return context.registerReceiver(broadcastReceiver, intentFilter);
        }
        return context.registerReceiver(broadcastReceiver, intentFilter, 4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point zzB(Context context) {
        Object object = (DisplayManager)context.getSystemService("display");
        object = object != null ? object.getDisplay(0) : null;
        if (object == null) {
            object = (WindowManager)context.getSystemService("window");
            if (object == null) throw null;
            object = object.getDefaultDisplay();
        }
        if (object.getDisplayId() == 0 && zzew.zzY(context)) {
            String string2 = zza < 28 ? zzew.zzaj("sys.display-size") : zzew.zzaj("vendor.display-size");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                try {
                    String[] stringArray = string2.trim();
                    String string3 = "x";
                    stringArray = stringArray.split(string3, -1);
                    int n = stringArray.length;
                    if (n == 2) {
                        n = Integer.parseInt(stringArray[0]);
                        int n2 = Integer.parseInt(stringArray[1]);
                        if (n > 0 && n2 > 0) {
                            Point point = new Point(n, n2);
                            return point;
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                string2 = String.valueOf(string2);
                String string4 = "Invalid display size: ";
                zzee.zzb("Util", string4.concat(string2));
            }
            if ("Sony".equals(zzc) && zzd.startsWith("BRAVIA") && context.getPackageManager().hasSystemFeature("com.sony.dtv.hardware.panel.qfhd")) {
                return new Point(3840, 2160);
            }
        }
        context = new Point();
        if (zza >= 23) {
            Context context2 = context;
            Display.Mode mode = object.getMode();
            context2.x = mode.getPhysicalWidth();
            context2.y = mode.getPhysicalHeight();
            return context;
        }
        object.getRealSize((Point)context);
        return context;
    }

    public static Handler zzC(Looper looper, @Nullable Handler.Callback callback) {
        return new Handler(looper, callback);
    }

    public static Handler zzD(@Nullable Handler.Callback callback) {
        callback = Looper.myLooper();
        zzdl.zzb(callback);
        return new Handler((Looper)callback, null);
    }

    public static Looper zzE() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            return looper;
        }
        return Looper.getMainLooper();
    }

    public static zzaf zzF(int n, int n2, int n3) {
        zzad zzad2 = new zzad();
        zzad2.zzS("audio/raw");
        zzad2.zzw(n2);
        zzad2.zzT(n3);
        zzad2.zzN(n);
        return zzad2.zzY();
    }

    /*
     * Unable to fully structure code
     */
    public static zzcc zzG(zzcg var0, zzcc var1_2) {
        block30: {
            block10: {
                var4_3 = var0.zzA();
                var5_4 = var0.zzd();
                var2_5 = ((zzm)var0).zzq();
                if (!var2_5.zzo()) break block10;
                var2_6 = false;
lbl6:
                // 3 sources

                while (true) {
                    block29: {
                        block11: {
                            var3_7 = ((zzm)var0).zzq();
                            if (!var3_7.zzo()) break block11;
                            var3_8 = false;
lbl10:
                            // 3 sources

                            while (true) {
                                block12: {
                                    block13: {
                                        var6_9 = var0.zzc();
                                        var7_10 = var0.zzb();
                                        var8_11 = var0.zzq().zzo();
                                        var9_12 = new zzca();
                                        var9_12.zzb(var1_2);
                                        var9_12.zzd(4, var4_3 ^ true);
                                        if (!var5_4) break block12;
                                        if (var4_3) break block13;
                                        var0_1 = true;
lbl22:
                                        // 3 sources

                                        while (true) {
                                            block14: {
                                                block15: {
                                                    var9_12.zzd(5, var0_1);
                                                    if (!var2_6) break block14;
                                                    if (var4_3) break block15;
                                                    var0_1 = true;
lbl28:
                                                    // 3 sources

                                                    while (true) {
                                                        block16: {
                                                            block17: {
                                                                block18: {
                                                                    var9_12.zzd(6, var0_1);
                                                                    if (var8_11) break block16;
                                                                    if (!var2_6 && var6_9 && !var5_4) break block17;
                                                                    if (var4_3) break block18;
                                                                    var0_1 = true;
lbl35:
                                                                    // 4 sources

                                                                    while (true) {
                                                                        block19: {
                                                                            block20: {
                                                                                var9_12.zzd(7, var0_1);
                                                                                if (!var3_8) break block19;
                                                                                if (var4_3) break block20;
                                                                                var0_1 = true;
lbl41:
                                                                                // 3 sources

                                                                                while (true) {
                                                                                    block21: {
                                                                                        block23: {
                                                                                            block24: {
                                                                                                block25: {
                                                                                                    block22: {
                                                                                                        var9_12.zzd(8, var0_1);
                                                                                                        if (var8_11) break block21;
                                                                                                        if (var3_8) break block22;
                                                                                                        if (!var6_9) break block23;
                                                                                                        if (!var7_10) break block24;
                                                                                                    }
                                                                                                    if (var4_3) break block25;
                                                                                                    var0_1 = true;
lbl51:
                                                                                                    // 5 sources

                                                                                                    while (true) {
                                                                                                        block26: {
                                                                                                            block27: {
                                                                                                                var9_12.zzd(9, var0_1);
                                                                                                                var9_12.zzd(10, var4_3 ^ true);
                                                                                                                if (!var5_4) break block26;
                                                                                                                if (var4_3) break block27;
                                                                                                                var0_1 = true;
lbl59:
                                                                                                                // 3 sources

                                                                                                                while (true) {
                                                                                                                    block28: {
                                                                                                                        var9_12.zzd(11, var0_1);
                                                                                                                        if (!var5_4) break block28;
                                                                                                                        if (!var4_3) {
                                                                                                                            var0_1 = true;
lbl65:
                                                                                                                            // 3 sources

                                                                                                                            while (true) {
                                                                                                                                var9_12.zzd(12, var0_1);
                                                                                                                                return var9_12.zze();
                                                                                                                            }
                                                                                                                        }
                                                                                                                        var0_1 = false;
                                                                                                                        ** GOTO lbl65
                                                                                                                    }
                                                                                                                    var0_1 = false;
                                                                                                                    ** continue;
                                                                                                                    break;
                                                                                                                }
                                                                                                            }
                                                                                                            var0_1 = false;
                                                                                                            ** GOTO lbl59
                                                                                                        }
                                                                                                        var0_1 = false;
                                                                                                        ** continue;
                                                                                                        break;
                                                                                                    }
                                                                                                }
                                                                                                var0_1 = false;
                                                                                                ** GOTO lbl51
                                                                                            }
                                                                                            var0_1 = false;
                                                                                            ** GOTO lbl51
                                                                                        }
                                                                                        var0_1 = false;
                                                                                        ** GOTO lbl51
                                                                                    }
                                                                                    var0_1 = false;
                                                                                    ** continue;
                                                                                    break;
                                                                                }
                                                                            }
                                                                            var0_1 = false;
                                                                            ** GOTO lbl41
                                                                        }
                                                                        var0_1 = false;
                                                                        ** continue;
                                                                        break;
                                                                    }
                                                                }
                                                                var0_1 = false;
                                                                ** GOTO lbl35
                                                            }
                                                            var0_1 = false;
                                                            ** GOTO lbl35
                                                        }
                                                        var0_1 = false;
                                                        ** continue;
                                                        break;
                                                    }
                                                }
                                                var0_1 = false;
                                                ** GOTO lbl28
                                            }
                                            var0_1 = false;
                                            ** continue;
                                            break;
                                        }
                                    }
                                    var0_1 = false;
                                    ** GOTO lbl22
                                }
                                var0_1 = false;
                                ** continue;
                                break;
                            }
                        }
                        v0 = ((zzm)var0).zzg();
                        ((zzm)var0).zzk();
                        ((zzm)var0).zzz();
                        if (var3_7.zzj(v0, 0, false) == -1) break block29;
                        var3_8 = true;
                        ** GOTO lbl10
                    }
                    var3_8 = false;
                    ** continue;
                    break;
                }
            }
            v1 = ((zzm)var0).zzg();
            ((zzm)var0).zzk();
            ((zzm)var0).zzz();
            if (var2_5.zzk(v1, 0, false) == -1) break block30;
            var2_6 = true;
            ** GOTO lbl6
        }
        var2_6 = false;
        ** while (true)
    }

    @EnsuresNonNull(value={"#1"})
    public static Object zzH(@Nullable Object object) {
        return object;
    }

    public static String zzI(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    public static String zzJ(byte[] byArray, int n, int n2) {
        return new String(byArray, n, n2, zzfnh.zzc);
    }

    public static String zzK(Object[] objectArray) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < (n = objectArray.length); ++i) {
            stringBuilder.append(objectArray[i].getClass().getSimpleName());
            if (i >= n + -1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String zzL(@Nullable Context object) {
        if (object != null && (object = (TelephonyManager)object.getSystemService("phone")) != null && !TextUtils.isEmpty((CharSequence)(object = object.getNetworkCountryIso()))) {
            return zzfnb.zzb((String)object);
        }
        return zzfnb.zzb((String)Locale.getDefault().getCountry());
    }

    public static String zzM(int n) {
        switch (n) {
            default: {
                throw new IllegalStateException();
            }
            case 4: {
                return "YES";
            }
            case 3: {
                return "NO_EXCEEDS_CAPABILITIES";
            }
            case 2: {
                return "NO_UNSUPPORTED_DRM";
            }
            case 1: {
                return "NO_UNSUPPORTED_TYPE";
            }
            case 0: 
        }
        return "NO";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String zzN(Locale object) {
        if (zza < 21) return ((Locale)object).toString();
        return ((Locale)object).toLanguageTag();
    }

    @Nullable
    private static String zzaj(String string2) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            string2 = (String)clazz.getMethod("get", String.class).invoke(clazz, string2);
            return string2;
        }
        catch (Exception exception) {
            string2 = "Failed to read system property ".concat(string2);
            zzee.zzc("Util", string2, exception);
            return null;
        }
    }

    public static String zzO(int n) {
        switch (n) {
            default: {
                return "camera motion";
            }
            case -2: {
                return "none";
            }
            case 5: {
                return "metadata";
            }
            case 4: {
                return "image";
            }
            case 3: {
                return "text";
            }
            case 2: {
                return "video";
            }
            case 1: {
                return "audio";
            }
            case 0: {
                return "default";
            }
            case -1: 
        }
        return "unknown";
    }

    public static String zzP(int n) {
        return Integer.toString(n, 36);
    }

    public static String zzQ(String string2) {
        block8: {
            String[] stringArray;
            if (string2 == null) {
                return null;
            }
            String[] stringArray2 = string2.replace('_', '-');
            if (!stringArray2.isEmpty() && !stringArray2.equals("und")) {
                string2 = stringArray2;
            }
            string2 = zzfnb.zza((String)string2);
            stringArray2 = string2.split("-", 2)[0];
            if (zzk == null) {
                zzk = zzew.zzak();
            }
            if ((stringArray = (String[])zzk.get(stringArray2)) != null) {
                string2 = stringArray.concat(String.valueOf(string2.substring(stringArray2.length())));
                stringArray2 = stringArray;
            }
            if (!"no".equals(stringArray2) && !"i".equals(stringArray2) && !"zh".equals(stringArray2)) break block8;
            int n = 0;
            while (true) {
                block10: {
                    block9: {
                        stringArray = zzm;
                        int cfr_ignored_0 = stringArray.length;
                        if (n >= 18) break block9;
                        if (!string2.startsWith(stringArray[n])) break block10;
                        int n2 = n + 1;
                        String[] stringArray3 = zzm;
                        string2 = string2.substring(stringArray3[n].length());
                        string2 = String.valueOf(stringArray3[n2]).concat(String.valueOf(string2));
                    }
                    return string2;
                }
                n += 2;
            }
        }
        return string2;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap zzak() {
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int cfr_ignored_0 = zzl.length;
        HashMap<String, String> hashMap = new HashMap<String, String>(n + 88);
        int n2 = 0;
        while (true) {
            block7: {
                if (n2 < n) {
                    String string2 = stringArray[n2];
                    String string3 = new Locale(string2).getISO3Language();
                    boolean bl = TextUtils.isEmpty((CharSequence)string3);
                    if (!bl) {
                        hashMap.put(string3, string2);
                    }
                    break block7;
                }
                n2 = 0;
                while (true) {
                    stringArray = zzl;
                    int cfr_ignored_1 = stringArray.length;
                    if (n2 >= 88) {
                        return hashMap;
                    }
                    hashMap.put(stringArray[n2], stringArray[n2 + 1]);
                    n2 += 2;
                }
                catch (MissingResourceException missingResourceException) {}
            }
            ++n2;
        }
    }

    public static ExecutorService zzR(String string2) {
        return Executors.newSingleThreadExecutor(new zzev(string2));
    }

    static {
        String string2 = zzb;
        String string3 = zzd;
        String string4 = zzc;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append(", ");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(string4);
        stringBuilder.append(", ");
        stringBuilder.append(zza);
        zze = stringBuilder.toString();
        zzf = new byte[0];
        zzg = Pattern.compile("(\\d\\d\\d\\d)\\-(\\d\\d)\\-(\\d\\d)[Tt](\\d\\d):(\\d\\d):(\\d\\d)([\\.,](\\d+))?([Zz]|((\\+|\\-)(\\d?\\d):?(\\d\\d)))?");
        zzh = Pattern.compile("^(-)?P(([0-9]*)Y)?(([0-9]*)M)?(([0-9]*)D)?(T(([0-9]*)H)?(([0-9]*)M)?(([0-9.]*)S)?)?$");
        zzi = Pattern.compile("%([A-Fa-f0-9]{2})");
        zzj = Pattern.compile("(?:.*\\.)?isml?(?:/(manifest(.*))?)?", 2);
        string2 = "alb";
        zzl = new String[]{string2, "sq", "arm", "hy", "baq", "eu", "bur", "my", "tib", "bo", "chi", "zh", "cze", "cs", "dut", "nl", "ger", "de", "gre", "el", "fre", "fr", "geo", "ka", "ice", "is", "mac", "mk", "mao", "mi", "may", "ms", "per", "fa", "rum", "ro", "scc", "hbs-srp", "slo", "sk", "wel", "cy", "id", "ms-ind", "iw", "he", "heb", "he", "ji", "yi", "arb", "ar-arb", "in", "ms-ind", "ind", "ms-ind", "nb", "no-nob", "nob", "no-nob", "nn", "no-nno", "nno", "no-nno", "tw", "ak-twi", "twi", "ak-twi", "bs", "hbs-bos", "bos", "hbs-bos", "hr", "hbs-hrv", "hrv", "hbs-hrv", "sr", "hbs-srp", "srp", "hbs-srp", "cmn", "zh-cmn", "hak", "zh-hak", "nan", "zh-nan", "hsn", "zh-hsn"};
        zzm = new String[]{"i-lux", "lb", "i-hak", "zh-hak", "i-navajo", "nv", "no-bok", "no-nob", "no-nyn", "no-nno", "zh-guoyu", "zh-cmn", "zh-hakka", "zh-hak", "zh-min-nan", "zh-nan", "zh-xiang", "zh-hsn"};
        zzn = new int[]{0, 79764919, 159529838, 222504665, 319059676, 398814059, 445009330, 507990021, 638119352, 583659535, 797628118, 726387553, 890018660, 835552979, 1015980042, 944750013, 1276238704, 1221641927, 1167319070, 1095957929, 1595256236, 1540665371, 1452775106, 1381403509, 1780037320, 1859660671, 1671105958, 1733955601, 2031960084, 2111593891, 1889500026, 1952343757, -1742489888, -1662866601, -1851683442, -1788833735, -1960329156, -1880695413, -2103051438, -2040207643, -1104454824, -1159051537, -1213636554, -1284997759, -1389417084, -1444007885, -1532160278, -1603531939, -734892656, -789352409, -575645954, -646886583, -952755380, -1007220997, -827056094, -898286187, -231047128, -151282273, -71779514, -8804623, -515967244, -436212925, -390279782, -327299027, 881225847, 809987520, 1023691545, 969234094, 662832811, 591600412, 771767749, 717299826, 311336399, 374308984, 453813921, 533576470, 25881363, 88864420, 134795389, 214552010, 2023205639, 2086057648, 1897238633, 1976864222, 1804852699, 1867694188, 1645340341, 1724971778, 1587496639, 1516133128, 1461550545, 1406951526, 1302016099, 1230646740, 1142491917, 1087903418, -1398421865, -1469785312, -1524105735, -1578704818, -1079922613, -1151291908, -1239184603, -1293773166, -1968362705, -1905510760, -2094067647, -2014441994, -1716953613, -1654112188, -1876203875, -1796572374, -525066777, -462094256, -382327159, -302564546, -206542021, -143559028, -97365931, -17609246, -960696225, -1031934488, -817968335, -872425850, -709327229, -780559564, -600130067, -654598054, 1762451694, 1842216281, 1619975040, 1682949687, 2047383090, 2127137669, 1938468188, 2001449195, 1325665622, 1271206113, 1183200824, 1111960463, 1543535498, 1489069629, 1434599652, 1363369299, 622672798, 568075817, 748617968, 677256519, 907627842, 853037301, 1067152940, 995781531, 51762726, 131386257, 177728840, 240578815, 269590778, 349224269, 429104020, 491947555, -248556018, -168932423, -122852000, -60002089, -500490030, -420856475, -341238852, -278395381, -685261898, -739858943, -559578920, -630940305, -1004286614, -1058877219, -845023740, -916395085, -1119974018, -1174433591, -1262701040, -1333941337, -1371866206, -1426332139, -1481064244, -1552294533, -1690935098, -1611170447, -1833673816, -1770699233, -2009983462, -1930228819, -2119160460, -2056179517, 1569362073, 1498123566, 1409854455, 1355396672, 1317987909, 1246755826, 1192025387, 1137557660, 2072149281, 2135122070, 1912620623, 1992383480, 1753615357, 1816598090, 1627664531, 1707420964, 295390185, 358241886, 404320391, 483945776, 43990325, 106832002, 186451547, 266083308, 932423249, 861060070, 1041341759, 986742920, 613929101, 542559546, 756411363, 701822548, -978770311, -1050133554, -869589737, -924188512, -693284699, -764654318, -550540341, -605129092, -475935807, -413084042, -366743377, -287118056, -257573603, -194731862, -114850189, -35218492, -1984365303, -1921392450, -2143631769, -2063868976, -1698919467, -1635936670, -1824608069, -1744851700, -1347415887, -1418654458, -1506661409, -1561119128, -1129027987, -1200260134, -1254728445, -1309196108};
        zzo = new int[]{0, 7, 14, 9, 28, 27, 18, 21, 56, 63, 54, 49, 36, 35, 42, 45, 112, 119, 126, 121, 108, 107, 98, 101, 72, 79, 70, 65, 84, 83, 90, 93, 224, 231, 238, 233, 252, 251, 242, 245, 216, 223, 214, 209, 196, 195, 202, 205, 144, 151, 158, 153, 140, 139, 130, 133, 168, 175, 166, 161, 180, 179, 186, 189, 199, 192, 201, 206, 219, 220, 213, 210, 255, 248, 241, 246, 227, 228, 237, 234, 183, 176, 185, 190, 171, 172, 165, 162, 143, 136, 129, 134, 147, 148, 157, 154, 39, 32, 41, 46, 59, 60, 53, 50, 31, 24, 17, 22, 3, 4, 13, 10, 87, 80, 89, 94, 75, 76, 69, 66, 111, 104, 97, 102, 115, 116, 125, 122, 137, 142, 135, 128, 149, 146, 155, 156, 177, 182, 191, 184, 173, 170, 163, 164, 249, 254, 247, 240, 229, 226, 235, 236, 193, 198, 207, 200, 221, 218, 211, 212, 105, 110, 103, 96, 117, 114, 123, 124, 81, 86, 95, 88, 77, 74, 67, 68, 25, 30, 23, 16, 5, 2, 11, 12, 33, 38, 47, 40, 61, 58, 51, 52, 78, 73, 64, 71, 82, 85, 92, 91, 118, 113, 120, 127, 106, 109, 100, 99, 62, 57, 48, 55, 34, 37, 44, 43, 6, 1, 8, 15, 26, 29, 20, 19, 174, 169, 160, 167, 178, 181, 188, 187, 150, 145, 152, 159, 138, 141, 132, 131, 222, 217, 208, 215, 194, 197, 204, 203, 230, 225, 232, 239, 250, 253, 244, 243};
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void zzS(long[] lArray, long l, long l2) {
        if (l2 >= 1000000L && l2 % 1000000L == 0L) {
            long l3 = l2 / 1000000L;
            int n = 0;
            while (n < lArray.length) {
                int n2 = n++;
                lArray[n2] = lArray[n2] / l3;
            }
            return;
        } else if (l2 < 1000000L && 1000000L % l2 == 0L) {
            long l4 = 1000000L / l2;
            int n = 0;
            while (n < lArray.length) {
                int n3 = n++;
                lArray[n3] = lArray[n3] * l4;
            }
            return;
        } else {
            double d = l2;
            int n = 0;
            while (n < lArray.length) {
                double d2 = 1000000.0 / d;
                int n4 = n++;
                lArray[n4] = (long)((double)lArray[n4] * d2);
            }
        }
    }

    public static void zzT(Parcel parcel, boolean bl) {
        parcel.writeInt(bl ? 1 : 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zzU(@Nullable Object object, @Nullable Object object2) {
        if (object != null) return object.equals(object2);
        if (object2 == null) return true;
        return false;
    }

    public static boolean zzV(int n) {
        return n == 0x20000000 || n == 0x30000000 || n == 4;
    }

    public static boolean zzW(int n) {
        return n == 3 || n == 2 || n == 0x10000000 || n == 0x20000000 || n == 0x30000000 || n == 4;
    }

    public static boolean zzX(Uri object) {
        return TextUtils.isEmpty((CharSequence)(object = object.getScheme())) || "file".equals(object);
    }

    public static boolean zzY(Context context) {
        return (context = (UiModeManager)context.getApplicationContext().getSystemService("uimode")) != null && context.getCurrentModeType() == 4;
    }

    public static boolean zzZ(Handler handler, Runnable runnable) {
        if (!handler.getLooper().getThread().isAlive()) {
            return false;
        }
        if (handler.getLooper() == Looper.myLooper()) {
            runnable.run();
            return true;
        }
        return handler.post(runnable);
    }

    public static boolean zzaa(Parcel parcel) {
        return parcel.readInt() != 0;
    }

    public static byte[] zzab(String string2) {
        return string2.getBytes(zzfnh.zzc);
    }

    public static byte[] zzac(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @EnsuresNonNull(value={"#1"})
    public static Object[] zzad(Object[] objectArray) {
        return objectArray;
    }

    public static Object[] zzae(Object[] objectArray, Object[] objectArray2) {
        int n = objectArray.length;
        int n2 = objectArray2.length;
        Object[] objectArray3 = Arrays.copyOf(objectArray, n + n2);
        System.arraycopy(objectArray2, 0, objectArray3, n, n2);
        return objectArray3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Object[] zzaf(Object[] objectArray, int n) {
        boolean bl = n <= objectArray.length;
        zzdl.zzd(bl);
        return Arrays.copyOf(objectArray, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] zzag() {
        String[] stringArray = Resources.getSystem().getConfiguration();
        stringArray = zza >= 24 ? stringArray.getLocales().toLanguageTags().split(",", -1) : new String[]{zzew.zzN(stringArray.locale)};
        int n = 0;
        while (n < stringArray.length) {
            int n2 = n++;
            stringArray[n2] = zzew.zzQ(stringArray[n2]);
        }
        return stringArray;
    }

    public static String[] zzah(String string2, String string3) {
        return string2.split(string3, -1);
    }

    public static String[] zzai(String string2, String string3) {
        return string2.split(string3, 2);
    }
}

