/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzdq;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbdi;
import com.google.android.gms.internal.ads.zzbdu;
import com.google.android.gms.internal.ads.zzbjz;
import com.google.android.gms.internal.ads.zzbkd;
import com.google.android.gms.internal.ads.zzbza;
import com.google.android.gms.internal.ads.zzcaa;
import com.google.android.gms.internal.ads.zzcqm;
import com.google.android.gms.internal.ads.zzdgd;
import com.google.android.gms.internal.ads.zzdgi;
import com.google.android.gms.internal.ads.zzdkf;
import java.util.Collections;

public final class zzdkg
extends zzbjz
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbdi {
    private View zza;
    private zzdq zzb;
    private zzdgd zzc;
    private boolean zzd;
    private boolean zze;

    @Nullable
    public final zzdq zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            zzbza.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    @Nullable
    public final zzbdu zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdkg)((Object)zzdgd2)).zzd) {
            zzbza.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdgd zzdgd2 = ((zzdkg)((Object)zzdgd2)).zzc;
        if (zzdgd2 != null && zzdgd2.zzc() != null) {
            return zzdgd2.zzc().zza();
        }
        return null;
    }

    public zzdkg(zzdgd zzdgd2, zzdgi zzdgi2) {
        this.zza = zzdgi2.zzf();
        this.zzb = zzdgi2.zzj();
        this.zzc = zzdgd2;
        this.zzd = false;
        this.zze = false;
        if (zzdgi2.zzr() != null) {
            zzdgi2.zzr().zzam(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdgd zzdgd2 = this.zzc;
        if (zzdgd2 != null) {
            ((zzcqm)zzdgd2).zzb();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdgd zzdgd2 = this.zzc;
        if (zzdgd2 != null && (view = this.zza) != null) {
            zzdgd2.zzA(view, Collections.emptyMap(), Collections.emptyMap(), zzdgd.zzW(this.zza));
            return;
        }
    }

    private final void zzh() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzf(iObjectWrapper, (zzbkd)new zzdkf(this));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper iObjectWrapper, zzbkd zzbkd2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdkg)((Object)string2)).zzd) {
            zzbza.zzg((String)"Instream ad can not be shown after destroy().");
            zzdkg.zzi(zzbkd2, 2);
            return;
        }
        View view = ((zzdkg)((Object)string2)).zza;
        if (view == null || ((zzdkg)((Object)string2)).zzb == null) {
            String string2 = view == null ? "can not get video view." : "can not get video controller.";
            zzbza.zzg((String)"Instream internal error: ".concat(string2));
            zzdkg.zzi(zzbkd2, 0);
            return;
        }
        if (((zzdkg)((Object)string2)).zze) {
            zzbza.zzg((String)"Instream ad should not be used again.");
            zzdkg.zzi(zzbkd2, 1);
            return;
        }
        ((zzdkg)((Object)string2)).zze = true;
        super.zzh();
        ((ViewGroup)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).addView(((zzdkg)((Object)string2)).zza, new ViewGroup.LayoutParams(-1, -1));
        zzt.zzx();
        zzcaa.zza(((zzdkg)((Object)string2)).zza, (ViewTreeObserver.OnGlobalLayoutListener)string2);
        zzt.zzx();
        zzcaa.zzb(((zzdkg)((Object)string2)).zza, (ViewTreeObserver.OnScrollChangedListener)string2);
        super.zzg();
        try {
            zzbkd2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            zzbza.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbkd zzbkd2, int n) {
        try {
            zzbkd2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbza.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

